/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.action.ActionType;
import com.ibm.cognos.fmeng.platform.impl.EMFHandleHelper;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DebugUtil {
    private static DebugUtil s_debugUtil;
    private NumberFormat m_format;
    private DebugFrame m_debugFrame;
    private static boolean s_debugEnabled;
    private HashMap<CATEGORY, TRACELEVEL> m_enabledCategories = new HashMap();

    static {
        s_debugEnabled = false;
    }

    public static DebugUtil GetInstance() {
        if (s_debugUtil == null) {
            s_debugUtil = new DebugUtil();
        }
        return s_debugUtil;
    }

    public static void Terminate() {
        DebugUtil.s_debugUtil.m_debugFrame.setVisible(false);
        DebugUtil.s_debugUtil.m_debugFrame.dispose();
        DebugUtil.s_debugUtil.m_debugFrame = null;
        s_debugUtil = null;
    }

    private DebugUtil() {
        CATEGORY[] cats;
        s_debugUtil = this;
        this.m_format = NumberFormat.getIntegerInstance();
        CATEGORY[] cATEGORYArray = cats = CATEGORY.values();
        int n = cats.length;
        int n2 = 0;
        while (n2 < n) {
            CATEGORY cat = cATEGORYArray[n2];
            if (cat.equals((Object)CATEGORY.NOTIFICATIONS)) {
                DebugUtil.s_debugUtil.m_enabledCategories.put(cat, TRACELEVEL.OFF);
            } else {
                DebugUtil.s_debugUtil.m_enabledCategories.put(cat, TRACELEVEL.INFO);
            }
            ++n2;
        }
        if (s_debugEnabled) {
            this.m_debugFrame = new DebugFrame();
        }
    }

    public void debug(Throwable e) {
        if (this.m_debugFrame != null) {
            this.m_debugFrame.debug(e);
        }
    }

    public boolean isActionEnabled(int action) {
        if (this.m_debugFrame != null) {
            return this.m_debugFrame.isActionEnabled(action);
        }
        return false;
    }

    public void debug(String str, CATEGORY category) {
        if (this.m_debugFrame != null) {
            this.m_debugFrame.debug(str, category);
        }
    }

    public void dumpMemory() {
        if (this.isCategoryEnabledForInfo(CATEGORY.MEMORY_STATS)) {
            this.dumpMemoryImpl();
        }
    }

    private void dumpMemoryImpl() {
        if (this.m_debugFrame != null) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totMemory = Runtime.getRuntime().totalMemory();
            long usedMemory = totMemory - freeMemory;
            this.m_debugFrame.debug("Free memory:" + this.m_format.format(freeMemory));
            this.m_debugFrame.debug("Total memory: " + this.m_format.format(totMemory));
            this.m_debugFrame.debug("Used memory: " + this.m_format.format(usedMemory));
        }
    }

    public void dumpMethodStats() {
        Enumeration<String> keys = EMFHandleHelper.METHOD_STATS.keys();
        long totalTime = 0L;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            EMFHandleHelper.StatKeeper statKeeper = EMFHandleHelper.METHOD_STATS.get(key);
            this.m_debugFrame.debug(key);
            this.m_debugFrame.debug("Call count:" + statKeeper.callCount);
            long totalNanoSeconds = statKeeper.cumalitiveTime;
            long millis = TimeUnit.NANOSECONDS.toMillis(totalNanoSeconds);
            totalTime += millis;
            this.m_debugFrame.debug("Cumalitive time :" + millis);
            this.m_debugFrame.debug("-------------------------------------------");
        }
        this.m_debugFrame.debug("Total time in EMFHandleHelper: " + totalTime);
        this.m_debugFrame.debug("Total handles: " + EMFHandleHelper.m_numHandles);
    }

    public void clearStats() {
        EMFHandleHelper.METHOD_STATS.clear();
    }

    void setCategoryEnabled(CATEGORY category, TRACELEVEL enabled) {
        this.m_enabledCategories.put(category, enabled);
    }

    public boolean isCategoryEnabledForInfo(CATEGORY cat) {
        TRACELEVEL level = this.m_enabledCategories.get((Object)cat);
        return level == TRACELEVEL.INFO || level == TRACELEVEL.DEBUG;
    }

    public boolean isCategoryEnabled(CATEGORY cat, TRACELEVEL level) {
        if (level == TRACELEVEL.INFO) {
            return this.isCategoryEnabledForInfo(cat);
        }
        return this.m_enabledCategories.get((Object)cat) == level;
    }

    class ActionFilter
    extends Frame
    implements ItemListener,
    WindowListener {
        private static final long serialVersionUID = 5828039074222790768L;
        private Set<String> m_enabledActions = new HashSet<String>();
        private Button m_selectAll = new Button("Deselect All");
        private Panel m_checkboxPanel;

        public ActionFilter() {
            this.addWindowListener(this);
            this.setSize(300, 600);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_selectAll, "South");
            this.m_selectAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (ActionFilter.this.m_selectAll.getLabel().equals("Select All")) {
                        ActionFilter.this.m_selectAll.setLabel("Deselect All");
                        ActionFilter.this.setAll(true);
                    } else {
                        ActionFilter.this.m_selectAll.setLabel("Select All");
                        ActionFilter.this.setAll(false);
                    }
                }
            });
            Collection<Integer> values = ActionType.actionMap.values();
            ScrollPane sp = new ScrollPane();
            this.m_checkboxPanel = new Panel();
            this.m_checkboxPanel.setLayout(new GridLayout(values.size(), 1));
            ArrayList<Integer> sortedValues = new ArrayList<Integer>();
            sortedValues.addAll(values);
            Collections.sort(sortedValues);
            for (Integer action : sortedValues) {
                Checkbox b = new Checkbox(String.valueOf(ActionType.GetActionString(action)) + ": " + action.toString());
                b.setState(true);
                b.setName(action.toString());
                b.addItemListener(this);
                this.m_enabledActions.add(action.toString());
                this.m_checkboxPanel.add(b);
            }
            sp.add(this.m_checkboxPanel);
            this.add((Component)sp, "Center");
        }

        boolean isActionEnabled(int action) {
            return this.m_enabledActions.contains(new Integer(action).toString());
        }

        private void setAll(boolean selected) {
            Component[] children = this.m_checkboxPanel.getComponents();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Checkbox) {
                    ((Checkbox)children[i]).setState(selected);
                    if (selected) {
                        this.m_enabledActions.add(children[i].getName());
                    } else {
                        this.m_enabledActions.remove(children[i].getName());
                    }
                }
                ++i;
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.m_enabledActions.add(((Checkbox)e.getSource()).getName());
            } else {
                this.m_enabledActions.remove(((Checkbox)e.getSource()).getName());
            }
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
            this.setVisible(false);
        }

        public void windowClosing(WindowEvent e) {
            this.setVisible(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CATEGORY {
        REFERENCES,
        MEMORY_STATS,
        EXCEPTIONS,
        ACTIONS,
        LIFECYCLE,
        LOAD,
        NOTIFICATIONS,
        UPGRADE;

    }

    class DebugFrame
    extends Frame {
        private static final long serialVersionUID = -8661090223752653813L;
        private TextArea m_textArea = new TextArea();
        private Button m_forceGC = new Button("Force GC");
        private Button m_forceHeapDump = new Button("Force Heap Dump");
        private Button m_printMemoryUseage = new Button("Print Memory Usage");
        private Button m_clearOutput = new Button("Clear Output");
        private Button m_dumpStats = new Button("Dump Stats");
        private Button m_clearStats = new Button("Clear Stats");
        private Button m_filterActions = new Button("Filter actions...");
        private ActionFilter m_actionFilters;

        public DebugFrame() {
            this.setBounds(0, 0, 700, 700);
            this.setLayout(new BorderLayout());
            Panel p = new Panel();
            p.setLayout(new GridLayout(3, 1));
            Panel top = new Panel();
            top.setLayout(new FlowLayout());
            top.add(this.m_forceGC);
            top.add(this.m_forceHeapDump);
            top.add(this.m_printMemoryUseage);
            top.add(this.m_clearOutput);
            top.add(this.m_filterActions);
            p.add(top);
            Panel bottom = new Panel();
            bottom.setLayout(new FlowLayout());
            bottom.add(this.m_dumpStats);
            bottom.add(this.m_clearStats);
            p.add(bottom);
            Component logConfiguration = this.buildLogControlPane();
            p.add(logConfiguration);
            this.add((Component)p, "North");
            this.add((Component)this.m_textArea, "Center");
            this.setVisible(true);
            this.m_actionFilters = new ActionFilter();
            this.m_forceHeapDump.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DebugFrame.this.forceHeapDump();
                }
            });
            this.m_forceGC.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    System.gc();
                    DebugFrame.this.debug("Forced gc");
                    DebugUtil.GetInstance().dumpMemoryImpl();
                }
            });
            this.m_printMemoryUseage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DebugUtil.GetInstance().dumpMemoryImpl();
                }
            });
            this.m_clearOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DebugFrame.this.m_textArea.setText("");
                }
            });
            this.m_dumpStats.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DebugUtil.this.dumpMethodStats();
                }
            });
            this.m_clearStats.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DebugUtil.this.clearStats();
                }
            });
            this.m_filterActions.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DebugFrame.this.m_actionFilters.setVisible(true);
                    DebugFrame.this.m_actionFilters.toFront();
                }
            });
        }

        public boolean isActionEnabled(int action) {
            return this.m_actionFilters.isActionEnabled(action);
        }

        private Component addDebugControl(CATEGORY item, ItemListener listener) {
            Panel p = new Panel();
            p.setLayout(new GridLayout(1, 2));
            p.add(new Label(item.toString()));
            Choice c = new Choice();
            c.add("INFO");
            c.add("DEBUG");
            c.add("OFF");
            c.addItemListener(listener);
            TRACELEVEL level = (TRACELEVEL)((Object)DebugUtil.this.m_enabledCategories.get((Object)item));
            c.select(level.toString());
            p.add(c);
            return p;
        }

        private Component buildLogControlPane() {
            Panel p = new Panel();
            p.setLayout(new GridLayout(4, 2));
            CATEGORY[] values = CATEGORY.values();
            int i = 0;
            while (i < values.length) {
                CategoryListener listener = new CategoryListener(values[i]);
                p.add(this.addDebugControl(values[i], listener));
                ++i;
            }
            ScrollPane sp = new ScrollPane();
            sp.add(p);
            return sp;
        }

        private void forceHeapDump() {
            try {
                Class<?> dumpClazz = Class.forName("com.ibm.jvm.Dump");
                Method heapDump = dumpClazz.getMethod("HeapDump", new Class[]{null});
                heapDump.invoke(null, new Object[]{null});
                Method systemDump = dumpClazz.getMethod("SystemDump", new Class[]{null});
                this.debug("Dumped heap dump .phd, use Heap Roots");
                systemDump.invoke(null, new Object[]{null});
                this.debug("System dump .dmp, use Memory Analyzer");
                Method javaDump = dumpClazz.getMethod("JavaDump", new Class[]{null});
                javaDump.invoke(null, new Object[]{null});
                this.debug("Java dump .txt, use Memory Analyzer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.debug("Dump is not supported on the current VM");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.debug("Dump is not supported on the current VM");
            }
            catch (InvocationTargetException invocationTargetException) {
                this.debug("Dump is not supported on the current VM");
            }
            catch (IllegalAccessException illegalAccessException) {
                this.debug("Dump is not supported on the current VM");
            }
        }

        private void debug(String str) {
            this.m_textArea.append(str);
            this.m_textArea.append("\n");
        }

        public void debug(String str, CATEGORY cat) {
            if (DebugUtil.this.isCategoryEnabledForInfo(cat)) {
                this.debug(str);
            }
        }

        private void debug(Throwable e) {
            if (DebugUtil.this.isCategoryEnabledForInfo(CATEGORY.EXCEPTIONS)) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.getClass().toString();
                }
                this.debug(msg);
                StackTraceElement[] st = e.getStackTrace();
                int i = 0;
                while (i < st.length) {
                    this.debug(st[i].toString());
                    ++i;
                }
            }
        }

        private class CategoryListener
        implements ItemListener {
            private CATEGORY m_category;

            public CategoryListener(CATEGORY category) {
                this.m_category = category;
            }

            public void itemStateChanged(ItemEvent e) {
                DebugUtil.this.setCategoryEnabled(this.m_category, TRACELEVEL.valueOf(e.getItemSelectable().getSelectedObjects()[0].toString()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TRACELEVEL {
        DEBUG,
        INFO,
        OFF;

    }
}

