/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.genmodel.GenmodelFactory;
import com.ibm.cognos.fmeng.platform.impl.UnresolvedReference;
import com.ibm.cognos.fmeng.utility.SerializationListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCustomModelSerializer {
    private OutputStream m_outStream;
    private SerializationListener m_listener;
    private XMLResource m_resource;
    private ExtendedMetaData m_extendedMetadata;

    public EMFCustomModelSerializer(OutputStream outStream, XMLResource resource, SerializationListener listener) {
        this.m_outStream = outStream;
        this.m_listener = listener;
        this.m_resource = resource;
        this.m_extendedMetadata = (ExtendedMetaData)resource.getDefaultSaveOptions().get("EXTENDED_META_DATA");
    }

    public void serialize(EObject obj, boolean includeRoot) {
        this.serializeImpl(obj, includeRoot);
    }

    private SerializationListener.SerializationStatus checkProceed(EObject obj) {
        if (this.m_listener != null) {
            return this.m_listener.serializeStatus(obj, this.m_outStream);
        }
        return SerializationListener.SerializationStatus.K_INCLUDE;
    }

    private void validateReference(EObject obj) {
        if (this.m_listener != null) {
            this.m_listener.validateReference(obj);
        }
    }

    private void serializeImpl(EObject parentNode, boolean includeRoot) {
        SerializationListener.SerializationStatus processingStatus = this.checkProceed(parentNode);
        if (SerializationListener.SerializationStatus.K_EXCLUDE != processingStatus && SerializationListener.SerializationStatus.K_OVERRIDDEN != processingStatus) {
            boolean bSuppress;
            boolean bl = bSuppress = SerializationListener.SerializationStatus.K_SUPPRESS == processingStatus;
            if (includeRoot && !bSuppress) {
                this.dumpStartTag(parentNode);
            }
            EList structuralFeatures = parentNode.eClass().getEAllStructuralFeatures();
            for (EStructuralFeature currentFeature : structuralFeatures) {
                BasicFeatureMap map;
                if (currentFeature == null || currentFeature.isTransient()) continue;
                int sfKind = this.m_extendedMetadata.getFeatureKind(currentFeature);
                if (!parentNode.eIsSet(currentFeature)) continue;
                Object obj = parentNode.eGet(currentFeature);
                if (sfKind == 1 && !bSuppress) {
                    this.dumpItEncoded(obj.toString());
                    continue;
                }
                if (sfKind == 5) {
                    map = (BasicFeatureMap)obj;
                    this.processChildList(map.basicList(), currentFeature, bSuppress);
                    continue;
                }
                if (sfKind == 4) {
                    if (obj instanceof EObject) {
                        this.dumpElement(currentFeature, (EObject)obj, bSuppress);
                        continue;
                    }
                    if (obj instanceof List) {
                        List list = (List)obj;
                        this.processChildList(list, currentFeature, bSuppress);
                        continue;
                    }
                    if (bSuppress) continue;
                    this.dumpIt("<" + currentFeature.getName());
                    this.dumpIt(">");
                    this.dumpItEncoded(obj.toString());
                    this.dumpIt("</");
                    this.dumpIt(currentFeature.getName());
                    this.dumpIt(">");
                    continue;
                }
                if (sfKind != 6) continue;
                map = (BasicFeatureMap)obj;
                this.processChildList(map.basicList(), currentFeature, bSuppress);
            }
            if (includeRoot && !bSuppress && parentNode.eContainingFeature() != null) {
                this.dumpIt("</");
                String nm = parentNode.eContainingFeature().getName();
                this.dumpIt(nm);
                this.dumpIt(">");
            }
        }
    }

    private void dumpElement(EStructuralFeature sf, EObject obj, boolean bSuppress) {
        boolean isReference = false;
        if (sf instanceof EReference) {
            EReference ref = (EReference)sf;
            boolean bl = isReference = !ref.isContainment();
        }
        if (isReference && !bSuppress) {
            this.validateReference(obj);
            this.dumpIt("<");
            this.dumpIt(sf.getName());
            this.dumpIt(">");
            if (obj instanceof UnresolvedReference) {
                this.dumpItEncoded(((UnresolvedReference)obj).getReference());
            } else {
                this.dumpItEncoded(((XMLResource)obj.eResource()).getID(obj));
            }
            this.dumpIt("</");
            this.dumpIt(sf.getName());
            this.dumpIt(">");
        } else if (!bSuppress || this.m_listener.canBeSuppressed(obj)) {
            this.serializeImpl(obj, true);
        }
    }

    private void processChildList(List<?> childList, EStructuralFeature listFeature, boolean bSuppress) {
        for (Object obj : childList) {
            FeatureMap.Entry entry;
            Object value;
            if (obj instanceof EObject) {
                if (bSuppress && !this.m_listener.canBeSuppressed((EObject)obj)) continue;
                EObject currentChild = (EObject)obj;
                this.dumpElement(listFeature, currentChild, bSuppress);
                continue;
            }
            if (!(obj instanceof FeatureMap.Entry) || (value = (entry = (FeatureMap.Entry)obj).getValue()) == null) continue;
            EStructuralFeature sf = entry.getEStructuralFeature();
            int sfKind = this.m_extendedMetadata.getFeatureKind(sf);
            if (sfKind == 1 && !bSuppress) {
                this.dumpItEncoded(value.toString());
                continue;
            }
            if (sf == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text()) {
                this.dumpItEncoded(value.toString());
                continue;
            }
            if (sfKind != 4) continue;
            if (value instanceof String && !bSuppress) {
                this.dumpIt("<");
                this.dumpIt(sf.getName());
                this.dumpIt(">");
                this.dumpItEncoded(value.toString());
                this.dumpIt("</");
                this.dumpIt(sf.getName());
                this.dumpIt(">");
                continue;
            }
            if (!(value instanceof EObject)) continue;
            this.dumpElement(sf, (EObject)value, bSuppress);
        }
    }

    private void dumpStartTag(EObject obj) {
        EStructuralFeature currentFeature = obj.eContainingFeature();
        this.dumpIt("<" + currentFeature.getName());
        EClass eClzz = obj.eClass();
        List atts = this.m_extendedMetadata.getAllAttributes(eClzz);
        for (EStructuralFeature feature : atts) {
            if (!obj.eIsSet(feature)) continue;
            Object value = obj.eGet(feature);
            this.dumpAttribute(feature.getName(), value.toString());
        }
        if (obj.eContainer() == this.m_resource.getContents().get(0)) {
            this.addNamespaceDeclarations();
        }
        this.dumpIt(">");
    }

    private void dumpItEncoded(String value) {
        String res = StringEscapeUtils.escapeXml((String)value.toString());
        this.dumpIt(res);
    }

    private void dumpIt(String str) {
        this.write(str);
    }

    private void dumpAttribute(String attName, String attValue) {
        this.write(" ");
        this.write(attName);
        this.write("=");
        this.write("\"");
        this.write(attValue);
        this.write("\"");
    }

    private void write(String str) {
        try {
            this.m_outStream.write(str.getBytes("UTF-8"));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage());
        }
    }

    protected void addNamespaceDeclarations() {
        EMap xsiSchemaLocationMap;
        EPackage pkg = GenmodelFactory.eINSTANCE.getEPackage();
        StringBuffer xsiSchemaLocation = new StringBuffer();
        EObject root = (EObject)this.m_resource.getContents().get(0);
        EClass eClass = root.eClass();
        EReference xsiSchemaLocationMapFeature = this.m_extendedMetadata.getXSISchemaLocationMapFeature(eClass);
        if (xsiSchemaLocationMapFeature != null && !(xsiSchemaLocationMap = (EMap)root.eGet((EStructuralFeature)xsiSchemaLocationMapFeature)).isEmpty()) {
            for (Map.Entry entry : xsiSchemaLocationMap.entrySet()) {
                String namespace = (String)entry.getKey();
                URI location = URI.createURI((String)((String)entry.getValue()));
                if (namespace == null) continue;
                if (xsiSchemaLocation.length() > 0) {
                    xsiSchemaLocation.append(' ');
                }
                xsiSchemaLocation.append(namespace);
                xsiSchemaLocation.append(' ');
                xsiSchemaLocation.append(location.toString());
            }
        }
        this.dumpAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        String nsURI = this.m_extendedMetadata.getNamespace(pkg);
        this.dumpAttribute("xmlns", nsURI);
        this.dumpAttribute("xsi:schemaLocation", xsiSchemaLocation.toString());
    }
}

