/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtractNamespace {
    protected String m_namespace = null;
    private InputStream m_is = null;
    private int m_major = 0;
    private int m_minor = 0;
    private String m_canonical = null;
    DefaultHandler nsExtractorHandler = new DefaultHandler(){

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            int i = 0;
            while (i < attributes.getLength()) {
                if (attributes.getQName(i).equals("xmlns")) {
                    ExtractNamespace.this.m_namespace = attributes.getValue(i);
                    throw new SAXException("Done");
                }
                ++i;
            }
            throw new SAXException("Done");
        }
    };

    public ExtractNamespace(InputStream is) {
        this.m_is = is;
    }

    public ExtractNamespace(String sourceNamespace) {
        this.m_namespace = sourceNamespace;
    }

    public String getNamespace() {
        if (this.m_canonical == null) {
            this.extractNamespace();
        }
        return this.m_namespace;
    }

    public String getCanonicalNamespace() {
        if (this.m_canonical == null) {
            this.extractNamespace();
        }
        return this.m_canonical;
    }

    public int getMajor() {
        if (this.m_canonical == null) {
            this.extractNamespace();
        }
        return this.m_major;
    }

    public int getMinor() {
        if (this.m_canonical == null) {
            this.extractNamespace();
        }
        return this.m_minor;
    }

    public boolean isValid() {
        if (this.m_canonical == null) {
            this.extractNamespace();
        }
        if (this.m_canonical == null) {
            return false;
        }
        return !this.m_canonical.equals("bad");
    }

    private void extractNamespace() {
        if (this.m_is != null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(this.m_is, this.nsExtractorHandler);
            }
            catch (IOException iOException) {
                this.m_namespace = null;
            }
            catch (SAXException se) {
                if (!se.getMessage().equals("Done")) {
                    this.m_namespace = null;
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                this.m_namespace = null;
            }
        }
        if (this.m_namespace != null) {
            int last = this.m_namespace.lastIndexOf("/");
            try {
                String stub = this.m_namespace.substring(last + 1, this.m_namespace.length());
                this.m_minor = Integer.valueOf(stub);
            }
            catch (RuntimeException runtimeException) {
                this.m_canonical = "bad";
                return;
            }
            int nextlast = this.m_namespace.lastIndexOf("/", last - 1);
            try {
                String stub = this.m_namespace.substring(nextlast + 1, last);
                this.m_major = Integer.valueOf(stub);
            }
            catch (RuntimeException runtimeException) {
                this.m_canonical = "bad";
                return;
            }
            this.m_canonical = "http://www.developer.cognos.com/schemas/bmt/60/13".substring(0, nextlast);
        }
    }
}

