/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmMDException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final int SEVERITY_WARNING = 0;
    public static final int SEVERITY_ERROR = 1;
    private int mErrorCode = 0;
    private List<FmMessage> mMsgs = new ArrayList<FmMessage>();
    private short mMsgCount = 0;
    private int m_severity = 1;

    public static final void ASSERT(boolean expr, String devHint) {
        if (!expr) {
            throw new FmMDException("BMT_MD_GENERIC_INTERNAL_ERROR", new Object[]{devHint});
        }
    }

    public FmMDException(int errorCode) {
        this.mErrorCode = errorCode;
    }

    public FmMDException() {
        this.mErrorCode = 0;
    }

    public FmMDException(String msgKey) {
        this.mErrorCode = 0;
        this.addMessage(new FmMessage(msgKey));
    }

    public FmMDException(String msgKey, Object[] msgParams) {
        this.mErrorCode = 0;
        this.addMessage(new FmMessage(msgKey, msgParams));
    }

    public FmMDException(String msgKey, String ... msgParams) {
        this.mErrorCode = 0;
        this.addMessage(new FmMessage(msgKey, msgParams));
    }

    public FmMDException(int errorCode, String msgKey, Object[] msgParams) {
        this.mErrorCode = errorCode;
        this.addMessage(new FmMessage(msgKey, msgParams));
    }

    public FmMDException(String msgKey, Object[] msgParams, Throwable e) {
        Object[] newMsgParams;
        this.mErrorCode = 0;
        if (msgParams == null) {
            newMsgParams = new Object[]{e.getMessage()};
        } else {
            newMsgParams = new Object[msgParams.length + 1];
            System.arraycopy(msgParams, 0, newMsgParams, 0, msgParams.length);
            newMsgParams[msgParams.length] = e.getMessage();
        }
        this.addMessage(new FmMessage(msgKey, newMsgParams));
    }

    public void setSeverity(int severity) {
        this.m_severity = severity;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    public short getMessageCount() {
        return this.mMsgCount;
    }

    public FmMessage getMessage(int msgIdx) {
        return this.mMsgs.get(msgIdx);
    }

    public void addMessage(FmMessage msg) {
        this.mMsgs.add(msg);
        this.mMsgCount = (short)(this.mMsgCount + 1);
    }

    public void addMessages(List<FmMessage> msgs) {
        this.mMsgs.addAll(msgs);
        this.mMsgCount = (short)(this.mMsgCount + msgs.size());
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(new Locale("en"));
    }

    public String getLocalizedMessage(Locale aLocale) {
        StringBuilder outMsgStr = new StringBuilder();
        String currBundleName = null;
        ResourceBundle currBundle = null;
        int idx = 0;
        while (idx < this.mMsgs.size()) {
            FmMessage aMsg = this.mMsgs.get(idx);
            if (currBundleName == null || !currBundleName.equals(aMsg.getBundleName())) {
                currBundleName = aMsg.getBundleName();
                currBundle = ResourceBundle.getBundle(currBundleName, aLocale);
            }
            outMsgStr.append(aMsg.render(currBundle, aLocale));
            if (idx < this.mMsgs.size() - 1) {
                outMsgStr.append("\n\t");
            }
            ++idx;
        }
        return outMsgStr.toString();
    }
}

