/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.cognos.ccl4j.resource.CCLResourceManager;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FmMessage {
    public static final String FMMD_BUNDLE_NAME = "fmeng";
    private String mBundleName = "fmeng";
    private String mMsgKey;
    private Object[] mMsgParams = null;

    public FmMessage(String msgKey) {
        this.mMsgKey = msgKey;
        this.mMsgParams = null;
    }

    public FmMessage(String msgKey, String ... msgParams) {
        this.mMsgKey = msgKey;
        this.mMsgParams = msgParams;
    }

    public FmMessage(String msgKey, Object[] msgParams) {
        this.mMsgKey = msgKey;
        this.mMsgParams = msgParams;
    }

    public String getBundleName() {
        return this.mBundleName;
    }

    public static String render(String key, Locale locale) {
        FmMessage msg = new FmMessage(key);
        return msg.render(locale);
    }

    public static String render(String key, String locale) {
        FmMessage msg = new FmMessage(key);
        return msg.render(locale);
    }

    public static String render(String key, String locale, String ... args) {
        FmMessage msg = new FmMessage(key, args);
        return msg.render(locale);
    }

    public static String render(String key, Locale locale, String ... args) {
        FmMessage msg = new FmMessage(key, args);
        return msg.render(locale);
    }

    public static void test(String key, Locale locale) throws MissingResourceException {
        ResourceBundle resBundle = ResourceBundle.getBundle(FMMD_BUNDLE_NAME, locale);
        resBundle.getString(key);
    }

    public String render(String crnLocale) {
        Locale aLocale = CCLResourceManager.getLocale((String)crnLocale);
        ResourceBundle resBundle = ResourceBundle.getBundle(this.mBundleName, aLocale);
        return this.render(resBundle, aLocale);
    }

    public String render(Locale locale) {
        ResourceBundle resBundle = ResourceBundle.getBundle(this.mBundleName, locale);
        return this.render(resBundle, locale);
    }

    String render(ResourceBundle resBundle, Locale aLocale) {
        String localizedMessage = null;
        try {
            localizedMessage = resBundle.getString(this.mMsgKey);
        }
        catch (MissingResourceException mre) {
            return mre.getMessage();
        }
        MessageFormat aFormatter = new MessageFormat(localizedMessage, aLocale);
        localizedMessage = aFormatter.format(this.mMsgParams, new StringBuffer(), (FieldPosition)null).toString();
        return localizedMessage;
    }

    public boolean verifyKey(String key) {
        return this.mMsgKey.equals(key);
    }

    public String getKey() {
        return this.mMsgKey;
    }

    public List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        Object[] objectArray = this.mMsgParams;
        int n = this.mMsgParams.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            params.add(obj.toString());
            ++n2;
        }
        return params;
    }
}

