/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FmPreferences {
    private static FmPreferences gSingleton = new FmPreferences();
    private static ICCLConfiguration m_cclConfiguration;
    private HashMap<String, String> m_prefMap = new HashMap();

    public static FmPreferences getInstance() {
        return gSingleton;
    }

    public String getFMPreference(String section, String preference) {
        return this.m_prefMap.get(String.valueOf(section) + preference);
    }

    public boolean getFMPreferenceAsBool(String section, String preference) {
        String value = this.m_prefMap.get(String.valueOf(section) + preference);
        return value != null && value.compareToIgnoreCase("TRUE") == 0;
    }

    public String getDispatcherEndPoint() {
        String ep = this.getFMPreference("ccloverrides", "dispatcherURL");
        if (ep != null) {
            return ep;
        }
        try {
            return this.getCCLConfiguration().getValue("sdk", false);
        }
        catch (CCLConfigurationException ce) {
            throw new RuntimeException(ce);
        }
    }

    public String getDataDirectory() {
        String dataDir = null;
        try {
            dataDir = this.getCCLConfiguration().getValue("data", true);
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            dataDir = this.getCCLConfiguration().resolveEffectivePath("../data");
        }
        return dataDir;
    }

    public void setDispatcherEndPoint(String endPoint) {
        this.m_prefMap.put("ccloverridesdispatcherURL", endPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICCLConfiguration getCCLConfiguration() {
        FmPreferences fmPreferences = this;
        synchronized (fmPreferences) {
            if (m_cclConfiguration == null) {
                m_cclConfiguration = CCLConfigurationFactory.getInstance();
                try {
                    m_cclConfiguration.init();
                }
                catch (CCLConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return m_cclConfiguration;
    }

    private FmPreferences() {
        this.loadPrefs();
    }

    private void loadPrefs() {
        try {
            FileInputStream fmIniFile = new FileInputStream("../configuration/fm.ini");
            DocumentBuilder myBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document docFmIni = myBuilder.parse(fmIniFile);
            Element root = docFmIni.getDocumentElement();
            NodeList sectionNodes = root.getElementsByTagName("Section");
            int i = 0;
            while (i < sectionNodes.getLength()) {
                Element currSection = (Element)sectionNodes.item(i);
                NodeList prefNodes = currSection.getElementsByTagName("Preference");
                int ii = 0;
                while (ii < prefNodes.getLength()) {
                    String prefValue;
                    Element currPref = (Element)prefNodes.item(ii);
                    Node prefNode = currPref.getFirstChild();
                    String string = prefValue = prefNode != null ? prefNode.getNodeValue() : null;
                    if (prefValue != null) {
                        this.addPreference(currSection.getAttribute("Name"), currPref.getAttribute("Name"), prefValue);
                    }
                    ++ii;
                }
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void addPreference(String sectionName, String prefName, String prefValue) {
        String key = String.valueOf(sectionName) + prefName;
        this.m_prefMap.put(key, prefValue);
    }
}

