/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MFWModelSerializer {
    private XMLStreamWriter m_writer;
    private MFWGateway m_gateway;
    private MFWModelRes m_modelRes;

    private MFWModelSerializer(MFWGateway gateway, XMLStreamWriter writer) {
        this.m_writer = writer;
        this.m_gateway = gateway;
        this.m_modelRes = MFWModelRes.getInstance();
    }

    private void serialize() {
        MFWNodeHandle[] project = this.m_gateway.query(MFWQuerySpec.create((String)"/project"));
        try {
            this.m_writer.writeStartDocument();
            this.writeProject(project[0]);
            this.m_writer.writeEndDocument();
            this.m_writer.flush();
            this.m_writer.close();
        }
        catch (XMLStreamException xse) {
            throw new RuntimeException(xse.getMessage(), xse);
        }
    }

    private void writeProject(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("project");
        this.m_writer.writeDefaultNamespace("http://www.developer.cognos.com/schemas/bmt/60/1");
        this.writeModelObjectTypeProperties(object);
        this.m_writer.writeStartElement("locales");
        MFWNodeHandle[] locales = this.m_gateway.getObjectChildren(object, this.m_modelRes.RID_locale);
        if (locales != null) {
            MFWNodeHandle[] mFWNodeHandleArray = locales;
            int n = locales.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle locale = mFWNodeHandleArray[n2];
                this.m_writer.writeStartElement("locale");
                this.m_writer.writeCharacters(this.m_gateway.getPropertyValue(locale));
                this.m_writer.writeEndElement();
                ++n2;
            }
        }
        this.m_writer.writeEndElement();
        this.writeSimpleProperty(object, this.m_modelRes.RID_defaultLocale, "defaultLocale");
        this.writeQosOverrides(object);
        this.writeSimpleProperty(object, this.m_modelRes.getResourceID("isNullSuppressionAllowed"), "isNullSuppressionAllowed");
        this.writeSimpleProperty(object, this.m_modelRes.getResourceID("isMultiEdgeNullSuppressionAllowed"), "isMultiEdgeNullSuppressionAllowed");
        this.writeSimpleProperty(object, this.m_modelRes.getResourceID("isAccessToNullSuppressionOptionsAllowed"), "isAccessToNullSuppressionOptionsAllowed");
        MFWNodeHandle[] rootNamespace = this.m_gateway.getObjectChildren(object, this.m_modelRes.RID_namespace);
        this.writeNamespace(rootNamespace[0]);
        this.m_writer.writeStartElement("dataSources");
        MFWNodeHandle[] dataSources = this.m_gateway.getObjectChildren(object, this.m_modelRes.RID_dataSource);
        if (dataSources != null) {
            MFWNodeHandle[] mFWNodeHandleArray = dataSources;
            int n = dataSources.length;
            int n3 = 0;
            while (n3 < n) {
                MFWNodeHandle dataSource = mFWNodeHandleArray[n3];
                this.writeDatasource(dataSource);
                ++n3;
            }
        }
        this.m_writer.writeEndElement();
        this.writeParameterMaps(this.m_gateway.getObjectChildren(object, this.m_modelRes.RID_parameterMaps)[0]);
        this.writeSecurityViews(this.m_gateway.getObjectChildren(object, this.m_modelRes.RID_securityViews)[0]);
        this.m_writer.writeStartElement("packages");
        this.m_writer.writeEndElement();
        this.m_writer.writeEndElement();
    }

    private void writeQosOverrides(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] qosOverrides = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_qosOverride);
        if (qosOverrides != null) {
            this.m_writer.writeStartElement("qosOverrides");
            MFWNodeHandle[] mFWNodeHandleArray = qosOverrides;
            int n = qosOverrides.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle override = mFWNodeHandleArray[n2];
                this.writeQosOverride(override);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    private void writeQosOverride(MFWNodeHandle parent) throws XMLStreamException {
        this.m_writer.writeStartElement("qosOverride");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_functionId, "functionId");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_qosLevel, "qosLevel");
        this.m_writer.writeEndElement();
    }

    private void writeDatasource(MFWNodeHandle dataSource) throws XMLStreamException {
        this.m_writer.writeStartElement("dataSource");
        this.writeModelObjectTypeProperties(dataSource);
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_queryProcessing, "queryProcessing");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_rollupProcessing, "rollupProcessing");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cmDataSource, "cmDataSource");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_catalog, "catalog");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cube, "cube");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_schema, "schema");
        this.m_writer.writeStartElement("type");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_queryType, "queryType");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_interface, "interface");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_functionSetID, "functionSetID");
        this.m_writer.writeEndElement();
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_connectionString, "connectionString");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_aliasTableMapRef, "aliasTableMapRef");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubeDescription, "cubeDescription");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubePath, "cubePath");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubeCreatedOn, "cubeCreatedOn");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubeDataUpdatedOn, "cubeDataUpdatedOn");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubeSchemaUpdatedOn, "cubeSchemaUpdatedOn");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubeIsOptimized, "cubeIsOptimized");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubeDefaultMeasure, "cubeDefaultMeasure");
        this.writeSimpleProperty(dataSource, this.m_modelRes.RID_cubeCurrentPeriod, "cubeCurrentPeriod");
        this.writeSimpleProperty(dataSource, this.m_modelRes.getResourceID("attributeDimensionsAsProperties"), "attributeDimensionsAsProperties");
        this.m_writer.writeEndElement();
    }

    private void writeParameterMaps(MFWNodeHandle parameterMapsObj) throws XMLStreamException {
        this.m_writer.writeStartElement("parameterMaps");
        MFWNodeHandle[] parameterMaps = this.m_gateway.getObjectChildren(parameterMapsObj, this.m_modelRes.RID_parameterMap);
        if (parameterMaps != null) {
            MFWNodeHandle[] mFWNodeHandleArray = parameterMaps;
            int n = parameterMaps.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle parametermap = mFWNodeHandleArray[n2];
                this.writeParametermap(parametermap);
                ++n2;
            }
        }
        this.m_writer.writeEndElement();
    }

    private void writeParametermap(MFWNodeHandle parameterMap) throws XMLStreamException {
        MFWNodeHandle[] queryItemMap;
        this.m_writer.writeStartElement("parameterMap");
        this.writeSimpleAttribute(parameterMap, this.m_modelRes.RID_hidden, "hidden");
        this.writeModelObjectTypeProperties(parameterMap);
        this.writeSimpleProperty(parameterMap, this.m_modelRes.RID_defaultValue, "defaultValue");
        MFWNodeHandle[] parameterMapEntries = this.m_gateway.getObjectChildren(parameterMap, this.m_modelRes.RID_parameterMapEntry);
        if (parameterMapEntries != null) {
            MFWNodeHandle[] mFWNodeHandleArray = parameterMapEntries;
            int n = parameterMapEntries.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle mapEntry = mFWNodeHandleArray[n2];
                this.m_writer.writeStartElement("parameterMapEntry");
                this.writeSimpleProperty(mapEntry, this.m_modelRes.RID_key, "key");
                this.writeSimpleProperty(mapEntry, this.m_modelRes.RID_value, "value");
                this.m_writer.writeEndElement();
                ++n2;
            }
        }
        if ((queryItemMap = this.m_gateway.getObjectChildren(parameterMap, this.m_modelRes.RID_queryItemMap)) != null && queryItemMap.length > 0) {
            this.m_writer.writeStartElement("queryItemMap");
            this.writeSimpleProperty(parameterMap, this.m_modelRes.RID_keyRef, "keyRef");
            this.writeSimpleProperty(parameterMap, this.m_modelRes.RID_valueRef, "valueRef");
            this.m_writer.writeEndElement();
        }
        this.m_writer.writeEndElement();
    }

    private void writeSecurityViews(MFWNodeHandle securityViews) throws XMLStreamException {
        this.m_writer.writeStartElement("securityViews");
        MFWNodeHandle[] securityViewObjects = this.m_gateway.getObjectChildren(securityViews, this.m_modelRes.RID_securityView);
        if (securityViewObjects != null) {
            MFWNodeHandle[] mFWNodeHandleArray = securityViewObjects;
            int n = securityViewObjects.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle securityView = mFWNodeHandleArray[n2];
                this.writeSecurityView(securityView);
                ++n2;
            }
        }
        this.m_writer.writeEndElement();
    }

    private void writeSecurityView(MFWNodeHandle securityView) throws XMLStreamException {
        int n;
        this.m_writer.writeStartElement("securityView");
        this.writeSimpleAttribute(securityView, this.m_modelRes.RID_isRoleBased, "isRoleBased");
        this.writeModelObjectTypeProperties(securityView);
        this.m_writer.writeStartElement("definition");
        MFWNodeHandle[] sets = this.m_gateway.getObjectChildren(securityView, this.m_modelRes.RID_set);
        if (sets != null) {
            MFWNodeHandle[] mFWNodeHandleArray = sets;
            n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle set = mFWNodeHandleArray[n2];
                this.writeSet(set);
                ++n2;
            }
        }
        this.m_writer.writeEndElement();
        this.m_writer.writeStartElement("access");
        this.m_writer.writeStartElement("decisionRole");
        MFWNodeHandle[] securityObjects = this.m_gateway.getObjectChildren(securityView, this.m_modelRes.RID_securityObject);
        if (securityObjects != null) {
            MFWNodeHandle[] mFWNodeHandleArray = securityObjects;
            int n3 = securityObjects.length;
            n = 0;
            while (n < n3) {
                MFWNodeHandle securityObject = mFWNodeHandleArray[n];
                this.writeSecurityObject(securityObject);
                ++n;
            }
        }
        this.m_writer.writeEndElement();
        this.m_writer.writeEndElement();
        MFWNodeHandle[] functionSets = this.m_gateway.getObjectChildren(securityView, this.m_modelRes.RID_functionSet);
        if (functionSets != null) {
            MFWNodeHandle[] mFWNodeHandleArray = functionSets;
            int n4 = functionSets.length;
            int n5 = 0;
            while (n5 < n4) {
                MFWNodeHandle functionSet = mFWNodeHandleArray[n5];
                this.m_writer.writeStartElement("functionSet");
                this.writeSimpleProperty(functionSet, this.m_modelRes.RID_functionSetID, "functionSetID");
                this.m_writer.writeEndElement();
                ++n5;
            }
        }
        this.writeQosOverrides(securityView);
        this.m_writer.writeEndElement();
    }

    private void writeSet(MFWNodeHandle set) throws XMLStreamException {
        MFWNodeHandle[] viewRefs;
        int n;
        this.m_writer.writeStartElement("set");
        this.writeSimpleAttribute(set, this.m_modelRes.RID_includeRule, "includeRule");
        MFWNodeHandle[] refObjs = this.m_gateway.getObjectChildren(set, this.m_modelRes.RID_refobj);
        if (refObjs != null) {
            MFWNodeHandle[] mFWNodeHandleArray = refObjs;
            n = refObjs.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle refObj = mFWNodeHandleArray[n2];
                this.m_writer.writeStartElement("refobj");
                this.m_writer.writeCharacters(this.m_gateway.getPropertyValue(refObj));
                this.m_writer.writeEndElement();
                ++n2;
            }
        }
        if ((viewRefs = this.m_gateway.getObjectChildren(set, this.m_modelRes.getResourceID("viewref"))) != null) {
            MFWNodeHandle[] mFWNodeHandleArray = viewRefs;
            int n3 = viewRefs.length;
            n = 0;
            while (n < n3) {
                MFWNodeHandle viewRef = mFWNodeHandleArray[n];
                this.m_writer.writeStartElement("viewref");
                this.m_writer.writeCharacters(this.m_gateway.getPropertyValue(viewRef));
                this.m_writer.writeEndElement();
                ++n;
            }
        }
        this.m_writer.writeEndElement();
    }

    private void writeNamespace(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("namespace");
        this.writeSectionTypeProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeCalculation(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("calculation");
        this.writeReportObjectTypeProperties(object);
        this.writeExpressionProperty(object, this.m_modelRes.RID_expression);
        this.writePreviewFilters(object);
        this.writeSecurityFilters(object);
        this.writeReportingColumnProperties(object);
        this.writeMdProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeDimension(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("dimension");
        this.writeQuerySubjectTypeProperties(object);
        this.writeDimensionProperties(object);
        this.writeMeasureDimensionItems(object);
        this.writeMemberDimensionProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeDimensionProperties(MFWNodeHandle dimension) throws XMLStreamException {
        this.writeSimpleProperty(dimension, this.m_modelRes.RID_type, "type");
        this.writeSimpleProperty(dimension, this.m_modelRes.RID_membersRollup, "membersRollup");
        this.writeSimpleProperty(dimension, this.m_modelRes.getResourceID("sortMembersMetadata"), "sortMembersMetadata");
        this.writeSimpleProperty(dimension, this.m_modelRes.getResourceID("sortMembersData"), "sortMembersData");
        this.writeSimpleProperty(dimension, this.m_modelRes.getResourceID("sortMembersAndEnableMrf"), "sortMembersAndEnableMrf");
        this.writeSimpleProperty(dimension, this.m_modelRes.getResourceID("aliasTableMapRef"), "aliasTableMapRef");
    }

    private void writeMeasureDimensionItems(MFWNodeHandle dimension) throws XMLStreamException {
        MFWNodeHandle[] children;
        MFWNodeHandle[] mFWNodeHandleArray = children = this.m_gateway.getAllObjectChildren(dimension);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle child = mFWNodeHandleArray[n2];
            switch (child.getInfo().getGUID()) {
                case 208: {
                    this.writeMeasure(child);
                    break;
                }
                case 209: {
                    this.writeMeasureFolder(child);
                    break;
                }
                case 198: {
                    this.writeQueryItem(child);
                    break;
                }
                case 199: {
                    this.writeQueryItemFolder(child);
                }
            }
            ++n2;
        }
    }

    private void writeMemberDimensionProperties(MFWNodeHandle dimension) throws XMLStreamException {
        MFWNodeHandle[] children;
        this.writeSimpleProperty(dimension, this.m_modelRes.RID_defaultHierarchy, "defaultHierarchy");
        MFWNodeHandle[] mFWNodeHandleArray = children = this.m_gateway.getAllObjectChildren(dimension);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle child = mFWNodeHandleArray[n2];
            switch (child.getInfo().getGUID()) {
                case 218: {
                    this.writeHierarchy(child);
                    break;
                }
                case 231: {
                    this.writeHierarchyFolder(child);
                }
            }
            ++n2;
        }
    }

    private void writeHierarchy(MFWNodeHandle hierarchy) throws XMLStreamException {
        MFWNodeHandle[] children;
        this.m_writer.writeStartElement("hierarchy");
        this.writeReportObjectTypeProperties(hierarchy);
        MFWNodeHandle[] mFWNodeHandleArray = children = this.m_gateway.getAllObjectChildren(hierarchy);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle child = mFWNodeHandleArray[n2];
            switch (child.getInfo().getGUID()) {
                case 210: {
                    this.writeLevel(child);
                    break;
                }
                case 198: {
                    this.writeHierarchyFolder(child);
                    break;
                }
                case 199: {
                    this.writeQueryItemFolder(child);
                }
            }
            ++n2;
        }
        this.writeHierarchyProperties(hierarchy);
        this.m_writer.writeEndElement();
    }

    private void writeLevel(MFWNodeHandle level) throws XMLStreamException {
        this.m_writer.writeStartElement("level");
        this.writeQueryItemFolderProperties(level);
        this.writeSimpleProperty(level, this.m_modelRes.RID_isUnique, "isUnique");
        this.writeSimpleProperty(level, this.m_modelRes.RID_externalName, "externalName");
        this.writeSimpleProperty(level, this.m_modelRes.RID_externalOrdinal, "externalOrdinal");
        this.writeSimpleProperty(level, this.m_modelRes.RID_isManual, "isManual");
        MFWNodeHandle[] sortItems = this.m_gateway.getObjectChildren(level, this.m_modelRes.RID_sortItem);
        if (sortItems != null && sortItems.length > 0) {
            this.m_writer.writeStartElement("memberSort");
            MFWNodeHandle[] mFWNodeHandleArray = sortItems;
            int n = sortItems.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle sortItem = mFWNodeHandleArray[n2];
                this.m_writer.writeStartElement("sortItem");
                this.writeSimpleAttribute(sortItem, this.m_modelRes.RID_sort, "sort");
                this.writeSimpleAttribute(sortItem, this.m_modelRes.getResourceID("nullPlacement"), "nullPlacement");
                this.writeSimpleProperty(level, this.m_modelRes.RID_refobj, "refobj");
                this.m_writer.writeEndElement();
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
        this.m_writer.writeEndElement();
    }

    private void writeHierarchyProperties(MFWNodeHandle hierarchy) throws XMLStreamException {
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_externalName, "externalName");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_multiRoot, "multiRoot");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_balanced, "balanced");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_ragged, "ragged");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_rootMember, "rootMember");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.getResourceID("rootMUN"), "rootMUN");
        this.writeMulilingualProperties(hierarchy, this.m_modelRes.RID_rootCaption, "rootCaption");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_sortedHierarchy, "sortedHierarchy");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_cardinality, "cardinality");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_parentChild, "parentChild");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_externalNumberOfLevels, "externalNumberOfLevels");
        this.writeSimpleProperty(hierarchy, this.m_modelRes.RID_externalNumberOfLevels, "externalNumberOfLevels");
    }

    private void writeHierarchyFolder(MFWNodeHandle hierarchyFolder) throws XMLStreamException {
        MFWNodeHandle[] allChildren;
        this.m_writer.writeStartElement("hierarchyFolder");
        this.writeReportObjectTypeProperties(hierarchyFolder);
        MFWNodeHandle[] mFWNodeHandleArray = allChildren = this.m_gateway.getAllObjectChildren(hierarchyFolder);
        int n = allChildren.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle child = mFWNodeHandleArray[n2];
            switch (child.getInfo().getGUID()) {
                case 231: {
                    this.writeHierarchyFolder(child);
                    break;
                }
                case 218: {
                    this.writeHierarchy(child);
                }
            }
            ++n2;
        }
        this.m_writer.writeEndElement();
    }

    private void writeMeasure(MFWNodeHandle measure) throws XMLStreamException {
        this.m_writer.writeStartElement("measure");
        this.writeQueryItemProperties(measure);
        this.writeSimpleProperty(measure, this.m_modelRes.RID_isHierarchical, "isHierarchical");
        MFWNodeHandle[] aggregateRules = this.m_gateway.getObjectChildren(measure, this.m_modelRes.RID_aggregateRule);
        if (aggregateRules != null && aggregateRules.length > 0) {
            this.m_writer.writeStartElement("aggregateRules");
            MFWNodeHandle[] mFWNodeHandleArray = aggregateRules;
            int n = aggregateRules.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle aggregateRule = mFWNodeHandleArray[n2];
                this.writeAggregateRule(aggregateRule);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
        this.writeSimpleProperty(measure, this.m_modelRes.getResourceID("allocationRule"), "allocationRule");
        this.m_writer.writeEndElement();
    }

    private void writeAggregateRule(MFWNodeHandle aggRule) throws XMLStreamException {
        this.m_writer.writeStartElement("aggregateRule");
        this.writeSimpleProperty(aggRule, this.m_modelRes.RID_dimensionRef, "dimensionRef");
        this.writeSimpleProperty(aggRule, this.m_modelRes.RID_applyAggregate, "applyAggregate");
        this.m_writer.writeEndElement();
    }

    private void writeMeasureFolder(MFWNodeHandle measureFolder) throws XMLStreamException {
        MFWNodeHandle[] allChildren;
        this.m_writer.writeStartElement("measureFolder");
        this.writeReportObjectTypeProperties(measureFolder);
        this.writeSimpleProperty(measureFolder, this.m_modelRes.RID_hidden, "hidden");
        MFWNodeHandle[] mFWNodeHandleArray = allChildren = this.m_gateway.getAllObjectChildren(measureFolder);
        int n = allChildren.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle child = mFWNodeHandleArray[n2];
            switch (child.getInfo().getGUID()) {
                case 209: {
                    this.writeMeasureFolder(child);
                    break;
                }
                case 208: {
                    this.writeMeasure(child);
                }
            }
            ++n2;
        }
        this.m_writer.writeEndElement();
    }

    private void writeFilter(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("filter");
        this.writeReportObjectTypeProperties(object);
        this.writeExpressionProperty(object, this.m_modelRes.RID_expression);
        this.m_writer.writeEndElement();
    }

    private void writeFolder(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("folder");
        this.writeSectionTypeProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeFunction(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("function");
        this.writeReportObjectTypeProperties(object);
        this.writeMulilingualProperties(object, this.m_modelRes.RID_name, "syntaxTip");
        this.writeSimpleProperty(object, this.m_modelRes.RID_canonicalName, "canonicalName");
        this.writeSimpleProperty(object, this.m_modelRes.RID_dataSourceRef, "dataSourceRef");
        this.writeResult(object);
        this.writeProcParameters(object);
        this.m_writer.writeEndElement();
    }

    private void writeResult(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("result");
        this.writeDataColumnProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeProcParameters(MFWNodeHandle object) throws XMLStreamException {
        MFWNodeHandle[] procParams = this.m_gateway.getObjectChildren(object, this.m_modelRes.RID_procParameter);
        if (procParams != null && procParams.length > 0) {
            this.m_writer.writeStartElement("procParameters");
            MFWNodeHandle[] mFWNodeHandleArray = procParams;
            int n = procParams.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle procParam = mFWNodeHandleArray[n2];
                this.writeProcParameter(procParam);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    private void writeProcParameter(MFWNodeHandle procParam) throws XMLStreamException {
        this.m_writer.writeStartElement("procParameter");
        this.writeCallParameterProperties(procParam);
        this.m_writer.writeEndElement();
    }

    private void writeCallParameterProperties(MFWNodeHandle parent) throws XMLStreamException {
        this.writeSimpleProperty(parent, this.m_modelRes.getResourceID("parameterName"), "parameterName");
        this.writeSimpleProperty(parent, this.m_modelRes.getResourceID("mode"), "mode");
        this.writeDataColumnProperties(parent);
    }

    private void writeQuerySubject(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("querySubject");
        this.writeQuerySubjectProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeQuerySubjectTypeProperties(MFWNodeHandle querySubjectType) throws XMLStreamException {
        this.writeReportObjectTypeProperties(querySubjectType);
        this.writeDefinition(querySubjectType);
        this.writePreviewFilters(querySubjectType);
        this.writeSecurityFilters(querySubjectType);
    }

    private void writeQueryItemsAndQueryItemFolders(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] allChildren;
        MFWNodeHandle[] mFWNodeHandleArray = allChildren = this.m_gateway.getAllObjectChildren(parent);
        int n = allChildren.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle child = mFWNodeHandleArray[n2];
            switch (child.getInfo().getGUID()) {
                case 198: {
                    this.writeQueryItem(child);
                    break;
                }
                case 199: {
                    this.writeQueryItemFolder(child);
                }
            }
            ++n2;
        }
    }

    private void writeQuerySubjectProperties(MFWNodeHandle parent) throws XMLStreamException {
        this.writeQuerySubjectTypeProperties(parent);
        this.writeDeterminants(parent);
        this.writeQueryItemsAndQueryItemFolders(parent);
    }

    private void writeQueryItemFolder(MFWNodeHandle queryItemFolder) throws XMLStreamException {
        this.m_writer.writeStartElement("queryItemFolder");
        this.writeQueryItemFolderProperties(queryItemFolder);
        this.m_writer.writeEndElement();
    }

    private void writeQueryItemFolderProperties(MFWNodeHandle queryItemFolder) throws XMLStreamException {
        this.writeReportObjectTypeProperties(queryItemFolder);
        this.writeSimpleProperty(queryItemFolder, this.m_modelRes.RID_hidden, "hidden");
        this.writeQueryItemsAndQueryItemFolders(queryItemFolder);
    }

    private void writeDeterminants(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] determinants = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_determinant);
        if (determinants != null && determinants.length > 0) {
            this.m_writer.writeStartElement("determinants");
            MFWNodeHandle[] mFWNodeHandleArray = determinants;
            int n = determinants.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle determinant = mFWNodeHandleArray[n2];
                this.writeDeterminant(determinant);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    private void writeDeterminant(MFWNodeHandle determinant) throws XMLStreamException {
        this.m_writer.writeStartElement("determinant");
        this.writeSimpleProperty(determinant, this.m_modelRes.RID_name, "name");
        this.writeRefObjCollection(determinant, this.m_modelRes.RID_key, "key", this.m_modelRes.RID_refobj, "refobj");
        this.writeRefObjCollection(determinant, this.m_modelRes.RID_attributes, "attributes", this.m_modelRes.RID_refobj, "refobj");
        this.writeSimpleProperty(determinant, this.m_modelRes.RID_canGroup, "canGroup");
        this.writeSimpleProperty(determinant, this.m_modelRes.RID_identifiesRow, "identifiesRow");
        this.m_writer.writeEndElement();
    }

    private void writeDefinition(MFWNodeHandle parent) throws XMLStreamException {
        String definitionType = this.m_gateway.getObjectPropertyValue(parent, this.m_modelRes.RID_definitionType);
        this.m_writer.writeStartElement("definition");
        if (!"unknown".equals(definitionType)) {
            if ("dbQuery".equals(definitionType)) {
                this.writeDbQuery(parent);
            } else if ("modelQuery".equals(definitionType)) {
                this.writeModelQuery(parent);
            } else if ("storedProcedure".equals(definitionType)) {
                this.writeStoredProcedure(parent);
            } else if ("mdQuery".equals(definitionType)) {
                this.writeMdQuery(parent);
            } else if ("queryOperation".equals(definitionType)) {
                this.writeQueryOperation(parent);
            }
        }
        this.m_writer.writeEndElement();
    }

    private void writeDbQuery(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] indexs;
        int n;
        this.m_writer.writeStartElement("dbQuery");
        this.writeSources(parent);
        this.writeSimpleProperty(parent, this.m_modelRes.RID_generateSQL, "generateSQL");
        String value = this.m_gateway.getObjectPropertyValue(parent, this.m_modelRes.RID_sql);
        this.writeWrappedTag(value, "<sql>");
        MFWNodeHandle[] keys = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_key);
        if (keys != null && keys.length > 0) {
            MFWNodeHandle[] mFWNodeHandleArray = keys;
            n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle key = mFWNodeHandleArray[n2];
                this.writeKey(key);
                ++n2;
            }
        }
        if ((indexs = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_index)) != null && indexs.length > 0) {
            MFWNodeHandle[] mFWNodeHandleArray = indexs;
            int n3 = indexs.length;
            n = 0;
            while (n < n3) {
                MFWNodeHandle index = mFWNodeHandleArray[n];
                this.writeIndex(index);
                ++n;
            }
        }
        this.writeFilters(parent);
        this.writeSimpleProperty(parent, this.m_modelRes.RID_tableType, "tableType");
        this.m_writer.writeEndElement();
    }

    private void writeFilters(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] filterDefinitions = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_filterDefinition);
        if (filterDefinitions != null && filterDefinitions.length > 0) {
            this.m_writer.writeStartElement("filters");
            MFWNodeHandle[] mFWNodeHandleArray = filterDefinitions;
            int n = filterDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle filterDef = mFWNodeHandleArray[n2];
                this.writeFilterDefinition(filterDef);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    private void writeFilterDefinition(MFWNodeHandle filterDefinition) throws XMLStreamException {
        this.m_writer.writeStartElement("filterDefinition");
        this.writeSimpleProperty(filterDefinition, this.m_modelRes.RID_apply, "apply");
        this.writeSimpleProperty(filterDefinition, this.m_modelRes.RID_refobj, "refobj");
        this.writeExpressionProperty(filterDefinition, this.m_modelRes.RID_expression);
        this.m_writer.writeEndElement();
    }

    private void writeKey(MFWNodeHandle key) throws XMLStreamException {
        this.m_writer.writeStartElement("key");
        this.writeSimpleProperty(key, this.m_modelRes.RID_name, "name");
        this.writeRefObjCollection(key, this.m_modelRes.getResourceID("queryItems_collection"), "queryItems_collection", this.m_modelRes.RID_refobj, "refobj");
        this.m_writer.writeEndElement();
    }

    private void writeIndex(MFWNodeHandle index) throws XMLStreamException {
        this.m_writer.writeStartElement("index");
        this.writeSimpleProperty(index, this.m_modelRes.getResourceID("unique"), "unique");
        this.writeRefObjCollection(index, this.m_modelRes.getResourceID("queryItems_collection"), "queryItems_collection", this.m_modelRes.RID_refobj, "refobj");
        this.m_writer.writeEndElement();
    }

    private void writeSources(MFWNodeHandle parent) throws XMLStreamException {
        this.m_writer.writeStartElement("sources");
        MFWNodeHandle[] dataSourceRefs = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_dataSourceRef);
        if (dataSourceRefs != null) {
            MFWNodeHandle[] mFWNodeHandleArray = dataSourceRefs;
            int n = dataSourceRefs.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle dataSourceRef = mFWNodeHandleArray[n2];
                this.m_writer.writeStartElement("dataSourceRef");
                this.m_writer.writeCharacters(this.m_gateway.getPropertyValue(dataSourceRef));
                this.m_writer.writeEndElement();
                ++n2;
            }
        }
        this.m_writer.writeEndElement();
    }

    private void writeModelQuery(MFWNodeHandle parent) throws XMLStreamException {
        this.m_writer.writeStartElement("modelQuery");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_generateSQL, "generateSQL");
        String value = this.m_gateway.getObjectPropertyValue(parent, this.m_modelRes.RID_sql);
        this.writeWrappedTag(value, "<sql>");
        this.writeFilters(parent);
        this.m_writer.writeEndElement();
    }

    private void writeStoredProcedure(MFWNodeHandle parent) throws XMLStreamException {
        this.m_writer.writeStartElement("storedProcedure");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_dataSourceRef, "dataSourceRef");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_canonicalName, "canonicalName");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_type, "type");
        this.writeProcParameters(parent);
        this.m_writer.writeEndElement();
    }

    private void writeMdQuery(MFWNodeHandle parent) throws XMLStreamException {
        this.m_writer.writeStartElement("mdQuery");
        this.writeSources(parent);
        if (parent.getInfo().findChildInfo(this.m_modelRes.RID_externalName) != null) {
            this.writeSimpleProperty(parent, this.m_modelRes.RID_externalName, "mdDimension");
        }
        this.writeFilters(parent);
        this.m_writer.writeEndElement();
    }

    private void writeQueryOperation(MFWNodeHandle parent) throws XMLStreamException {
        this.m_writer.writeStartElement("queryOperation");
        this.writeRefObjCollection(parent, this.m_modelRes.RID_querySubjectRefs, "querySubjectRefs", this.m_modelRes.RID_refobj, "refobj");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_setOperation, "setOperation");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_duplicates, "duplicates");
        this.writeFilters(parent);
        this.m_writer.writeEndElement();
    }

    private void writeRelationship(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("relationship");
        this.writeModelObjectTypeProperties(object);
        this.writeExpressionProperty(object, this.m_modelRes.RID_expression);
        String value = this.m_gateway.getObjectPropertyValue(object, this.m_modelRes.RID_sql);
        if (value != null && value.length() > 0) {
            this.writeWrappedTag(value, "<sql>");
        }
        this.writeRelationshipEnd(object, this.m_modelRes.RID_leftmaxcard, this.m_modelRes.RID_leftmincard, this.m_modelRes.RID_leftrefobj, "left");
        this.writeRelationshipEnd(object, this.m_modelRes.RID_rightmaxcard, this.m_modelRes.RID_rightmincard, this.m_modelRes.RID_rightrefobj, "right");
        this.m_writer.writeEndElement();
    }

    private void writeRelationshipEnd(MFWNodeHandle rel, short maxCard, short minCard, short refObj, String fmName) throws XMLStreamException {
        this.m_writer.writeStartElement(fmName);
        this.writeSimpleProperty(rel, refObj, "refobj");
        this.writeSimpleProperty(rel, minCard, "mincard");
        this.writeSimpleProperty(rel, maxCard, "maxcard");
        this.m_writer.writeEndElement();
    }

    private void writeModelObjectTypeProperties(MFWNodeHandle object) throws XMLStreamException {
        this.writeSimpleProperty(object, this.m_modelRes.RID_name, "name");
        this.writeSimpleProperty(object, this.m_modelRes.RID_guid, "guid");
        if (object.getInfo().findChildInfo(this.m_modelRes.RID_property) != null) {
            this.writeCustomProperties(object);
        }
    }

    private void writeRelationshipShortcut(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("relationshipShortcut");
        this.writeModelObjectTypeProperties(object);
        this.m_writer.writeStartElement("left");
        this.writeSimpleProperty(object, this.m_modelRes.RID_leftrefobj, "refobj");
        this.m_writer.writeEndElement();
        this.m_writer.writeStartElement("right");
        this.writeSimpleProperty(object, this.m_modelRes.RID_rightrefobj, "refobj");
        this.m_writer.writeEndElement();
        this.writeSimpleProperty(object, this.m_modelRes.RID_relationshipRef, "relationshipRef");
        this.m_writer.writeEndElement();
    }

    private void writeShortcut(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("shortcut");
        this.writeReportObjectTypeProperties(object);
        this.writeSimpleProperty(object, this.m_modelRes.RID_guid, "refobj");
        this.writeSimpleProperty(object, this.m_modelRes.RID_guid, "targetType");
        this.writeSimpleProperty(object, this.m_modelRes.RID_guid, "treatAs");
        this.m_writer.writeEndElement();
    }

    private void writeScopeRelationship(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("scopeRelationship");
        this.writeModelObjectTypeProperties(object);
        this.writeRelationshipEnd(object, this.m_modelRes.RID_leftmaxcard, this.m_modelRes.RID_leftmincard, this.m_modelRes.RID_leftrefobj, "left");
        this.writeRelationshipEnd(object, this.m_modelRes.RID_rightmaxcard, this.m_modelRes.RID_rightmincard, this.m_modelRes.RID_rightrefobj, "right");
        MFWNodeHandle[] scopes = this.m_gateway.getObjectChildren(object, this.m_modelRes.RID_scope);
        if (scopes != null) {
            MFWNodeHandle[] mFWNodeHandleArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle scope = mFWNodeHandleArray[n2];
                this.writeScope(scope);
                ++n2;
            }
        }
        this.m_writer.writeEndElement();
    }

    private void writeScope(MFWNodeHandle scope) throws XMLStreamException {
        this.m_writer.writeStartElement("scope");
        this.writeSimpleProperty(scope, this.m_modelRes.RID_levelRef, "levelRef");
        MFWNodeHandle[] measureScopes = this.m_gateway.getObjectChildren(scope, this.m_modelRes.RID_measureScope);
        if (measureScopes != null) {
            MFWNodeHandle[] mFWNodeHandleArray = measureScopes;
            int n = measureScopes.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle measureScope = mFWNodeHandleArray[n2];
                this.writeMeasureScope(measureScope);
                ++n2;
            }
        }
        this.m_writer.writeEndElement();
    }

    private void writeMeasureScope(MFWNodeHandle measureScope) throws XMLStreamException {
        this.m_writer.writeStartElement("measureScope");
        this.writeSimpleProperty(measureScope, this.m_modelRes.RID_excluded, "excluded");
        this.writeSimpleProperty(measureScope, this.m_modelRes.RID_refobj, "refobj");
        this.m_writer.writeEndElement();
    }

    private void writeUpdateSubject(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("updateSubject");
        this.writeQuerySubjectTypeProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeQueryItem(MFWNodeHandle object) throws XMLStreamException {
        this.m_writer.writeStartElement("queryItem");
        this.writeQueryItemProperties(object);
        this.m_writer.writeEndElement();
    }

    private void writeQueryItemProperties(MFWNodeHandle object) throws XMLStreamException {
        this.writeReportObjectTypeProperties(object);
        this.writeExpressionProperty(object, this.m_modelRes.RID_expression);
        this.writeSimpleProperty(object, this.m_modelRes.RID_externalName, "externalName");
        this.writeReportingColumnProperties(object);
        this.writeCollationProperties(object);
    }

    private void writeCollationProperties(MFWNodeHandle parent) throws XMLStreamException {
        this.writeSimpleProperty(parent, this.m_modelRes.RID_collationSequenceName, "collationSequenceName");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_collationSequenceLevel, "collationSequenceLevel");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_originalCollationSequenceName, "originalCollationSequenceName");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_originalEncodingName, "originalEncodingName");
    }

    private void writeSectionTypeProperties(MFWNodeHandle object) throws XMLStreamException {
        MFWNodeHandle[] objects;
        this.writeReportObjectTypeProperties(object);
        MFWNodeHandle[] mFWNodeHandleArray = objects = this.m_gateway.getAllObjectChildren(object);
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle handle = mFWNodeHandleArray[n2];
            switch (handle.getInfo().getGUID()) {
                case 295: {
                    this.writeFolder(handle);
                    break;
                }
                case 253: {
                    this.writeFunction(handle);
                    break;
                }
                case 294: {
                    this.writeNamespace(handle);
                    break;
                }
                case 243: {
                    this.writeShortcut(handle);
                    break;
                }
                case 238: {
                    this.writeQuerySubject(handle);
                    break;
                }
                case 242: {
                    this.writeUpdateSubject(handle);
                    break;
                }
                case 246: {
                    this.writeRelationship(handle);
                    break;
                }
                case 247: {
                    this.writeRelationshipShortcut(handle);
                    break;
                }
                case 200: {
                    this.writeFilter(handle);
                    break;
                }
                case 201: {
                    this.writeCalculation(handle);
                    break;
                }
                case 232: {
                    this.writeDimension(handle);
                    break;
                }
                case 249: {
                    this.writeScopeRelationship(handle);
                }
            }
            ++n2;
        }
    }

    private void writeReportObjectTypeProperties(MFWNodeHandle object) throws XMLStreamException {
        this.writeMulilingualProperties(object, this.m_modelRes.RID_name, "name");
        this.writeMulilingualProperties(object, this.m_modelRes.RID_description, "description");
        this.writeChangeManagementProperties(object);
        this.writeMulilingualProperties(object, this.m_modelRes.RID_screenTip, "screenTip");
        this.writeCustomProperties(object);
    }

    private void writeMulilingualProperties(MFWNodeHandle parent, short propertyRid, String fmPropertyName) throws XMLStreamException {
        MFWNodeHandle[] names;
        MFWNodeHandle[] mFWNodeHandleArray = names = this.m_gateway.getObjectChildren(parent, propertyRid);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle nameHandle = mFWNodeHandleArray[n2];
            this.m_writer.writeStartElement(fmPropertyName);
            String locale = this.m_gateway.getObjectPropertyValue(nameHandle, this.m_modelRes.RID_locale);
            this.m_writer.writeAttribute("locale", locale);
            String value = this.m_gateway.getObjectPropertyValue(nameHandle, this.m_modelRes.RID__Value);
            this.m_writer.writeCharacters(value);
            this.m_writer.writeEndElement();
            ++n2;
        }
    }

    private void writeChangeManagementProperties(MFWNodeHandle parent) throws XMLStreamException {
        this.writeSimpleProperty(parent, this.m_modelRes.RID_guid, "guid");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_lastChanged, "lastChanged");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_lastChangedBy, "lastChangedBy");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_comment, "comment");
    }

    private void writeSimpleProperty(MFWNodeHandle parent, short rid, String fmPropertyName) throws XMLStreamException {
        String value = this.m_gateway.getObjectPropertyValue(parent, rid);
        if (value != null && value.length() > 0) {
            MFWInfoProperty info = (MFWInfoProperty)parent.getInfo().findChildInfo(rid);
            if (value.equals(info.getDefaultValue())) {
                switch (((MFWInfoObject)parent.getInfo()).findChildMultiplicity(rid)) {
                    case 2: 
                    case 3: {
                        return;
                    }
                }
            }
            this.m_writer.writeStartElement(fmPropertyName);
            this.m_writer.writeCharacters(value);
            this.m_writer.writeEndElement();
        }
    }

    private void writeSimpleAttribute(MFWNodeHandle parent, short rid, String fmAtributeName) throws XMLStreamException {
        String value = this.m_gateway.getObjectPropertyValue(parent, rid);
        if (value != null && value.length() > 0) {
            this.m_writer.writeAttribute(fmAtributeName, value);
        }
    }

    private void writeCustomProperties(MFWNodeHandle parent) throws XMLStreamException {
        String value;
        MFWNodeHandle[] mFWNodeHandleArray;
        MFWNodeHandle[] ppds;
        MFWNodeHandle[] properties;
        MFWNodeHandle[] mFWNodeHandleArray2 = properties = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_property);
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            MFWNodeHandle propertyHandle = mFWNodeHandleArray2[n2];
            this.m_writer.writeStartElement("property");
            String name = this.m_gateway.getObjectPropertyValue(propertyHandle, this.m_modelRes.RID_name);
            this.m_writer.writeAttribute("name", name);
            String type = this.m_gateway.getObjectPropertyValue(propertyHandle, this.m_modelRes.RID_type);
            if (type != null && type.length() > 0) {
                this.m_writer.writeAttribute("type", type);
            }
            String value2 = this.m_gateway.getObjectPropertyValue(propertyHandle, this.m_modelRes.RID__Value);
            this.m_writer.writeCharacters(value2);
            this.writeCustomProperties(propertyHandle);
            this.m_writer.writeEndElement();
            ++n2;
        }
        if (parent.getInfo().findChildInfo(this.m_modelRes.RID_PPDS_CODE) != null) {
            mFWNodeHandleArray = ppds = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_PPDS_CODE);
            int n3 = ppds.length;
            n = 0;
            while (n < n3) {
                MFWNodeHandle propertyHandle = mFWNodeHandleArray[n];
                this.m_writer.writeStartElement("property");
                this.m_writer.writeAttribute("name", "PPDS_CODE");
                value = this.m_gateway.getPropertyValue(propertyHandle);
                this.m_writer.writeCharacters(value);
                this.m_writer.writeEndElement();
                ++n;
            }
        }
        if (parent.getInfo().findChildInfo(this.m_modelRes.RID_rootMemberRollup) != null) {
            mFWNodeHandleArray = ppds = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_rootMemberRollup);
            int n4 = ppds.length;
            n = 0;
            while (n < n4) {
                MFWNodeHandle propertyHandle = mFWNodeHandleArray[n];
                this.m_writer.writeStartElement("property");
                this.m_writer.writeAttribute("name", "rootMemberRollup");
                value = this.m_gateway.getPropertyValue(propertyHandle);
                this.m_writer.writeCharacters(value);
                this.m_writer.writeEndElement();
                ++n;
            }
        }
    }

    private void writeExpressionProperty(MFWNodeHandle parent, short ridProperty) throws XMLStreamException {
        String value = this.m_gateway.getObjectPropertyValue(parent, ridProperty);
        if (value != null) {
            this.writeWrappedTag(value, "<expression>");
        }
    }

    private void writeWrappedTag(String xmlValue, String expectedStart) throws XMLStreamException {
        DefaultHandler handler = new DefaultHandler(){

            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                try {
                    MFWModelSerializer.this.m_writer.writeStartElement(localName);
                    int i = 0;
                    while (i < attributes.getLength()) {
                        MFWModelSerializer.this.m_writer.writeAttribute(attributes.getLocalName(i), attributes.getValue(i));
                        ++i;
                    }
                }
                catch (XMLStreamException xse) {
                    throw new RuntimeException(xse.getMessage(), xse);
                }
            }

            public void endElement(String uri, String localName, String qName) {
                try {
                    MFWModelSerializer.this.m_writer.writeEndElement();
                }
                catch (XMLStreamException xse) {
                    throw new RuntimeException(xse.getMessage(), xse);
                }
            }

            public void characters(char[] ch, int start, int length) {
                try {
                    MFWModelSerializer.this.m_writer.writeCharacters(ch, start, length);
                }
                catch (XMLStreamException xse) {
                    throw new RuntimeException(xse.getMessage(), xse);
                }
            }
        };
        if (xmlValue.startsWith(expectedStart)) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse((InputStream)new ByteArrayInputStream(xmlValue.getBytes("UTF-8")), handler);
            }
            catch (IOException io) {
                throw new RuntimeException(io.getMessage(), io);
            }
            catch (SAXException se) {
                throw new RuntimeException(se.getMessage(), se);
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce.getMessage(), pce);
            }
        } else {
            this.m_writer.writeCharacters(xmlValue);
        }
    }

    private void writePreviewFilters(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] previewFilters = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_previewFilter);
        if (previewFilters != null && previewFilters.length > 0) {
            this.m_writer.writeStartElement("previewFilters");
            MFWNodeHandle[] mFWNodeHandleArray = previewFilters;
            int n = previewFilters.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle previewFilter = mFWNodeHandleArray[n2];
                this.writePreviewFilter(previewFilter);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    private void writePreviewFilter(MFWNodeHandle previewFilter) throws XMLStreamException {
        String expression;
        this.m_writer.writeStartElement("previewFitler");
        String refObj = this.m_gateway.getObjectPropertyValue(previewFilter, this.m_modelRes.RID_refobj);
        if (refObj != null && refObj.length() > 0) {
            this.m_writer.writeStartElement("refobj");
            this.m_writer.writeCharacters(refObj);
            this.m_writer.writeEndElement();
        }
        if ((expression = this.m_gateway.getObjectPropertyValue(previewFilter, this.m_modelRes.RID_expression)) != null && expression.length() > 0) {
            this.writeWrappedTag(expression, "<expression>");
        }
        this.m_writer.writeEndElement();
    }

    private void writeSecurityFilters(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] securityFilters = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_securityFilterDefinition);
        if (securityFilters != null && securityFilters.length > 0) {
            this.m_writer.writeStartElement("previewFilters");
            MFWNodeHandle[] mFWNodeHandleArray = securityFilters;
            int n = securityFilters.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle securityFilter = mFWNodeHandleArray[n2];
                this.writeSecurityFilterDefinition(securityFilter);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    private void writeSecurityFilterDefinition(MFWNodeHandle securityFilterDefinition) throws XMLStreamException {
        String expression;
        String refObj;
        MFWNodeHandle[] basedOn;
        this.m_writer.writeStartElement("securityFilterDefinition");
        MFWNodeHandle[] securityObject = this.m_gateway.getObjectChildren(securityFilterDefinition, this.m_modelRes.RID_securityObject);
        if (securityObject != null && securityObject.length > 0) {
            this.writeSecurityObject(securityObject[0]);
        }
        if ((basedOn = this.m_gateway.getObjectChildren(securityFilterDefinition, this.m_modelRes.RID_basedOn)) != null && basedOn.length > 0) {
            this.writeBasedOn(basedOn[0]);
        }
        if ((refObj = this.m_gateway.getObjectPropertyValue(securityFilterDefinition, this.m_modelRes.RID_refobj)) != null && refObj.length() > 0) {
            this.m_writer.writeStartElement("refobj");
            this.m_writer.writeCharacters(refObj);
            this.m_writer.writeEndElement();
        }
        if ((expression = this.m_gateway.getObjectPropertyValue(securityFilterDefinition, this.m_modelRes.RID_expression)) != null && expression.length() > 0) {
            this.writeWrappedTag(expression, "<expression>");
        }
        this.m_writer.writeEndElement();
    }

    private void writeSecurityObject(MFWNodeHandle securityObject) throws XMLStreamException {
        this.m_writer.writeStartElement("securityObject");
        this.writeSimpleAttribute(securityObject, this.m_modelRes.RID_type, "type");
        this.writeSimpleProperty(securityObject, this.m_modelRes.getResourceID("displayPath"), "displayPath");
        this.writeSimpleProperty(securityObject, this.m_modelRes.RID_cmSearchPath, "cmSearchPath");
        this.m_writer.writeEndElement();
    }

    private void writeBasedOn(MFWNodeHandle basedOn) throws XMLStreamException {
        this.m_writer.writeStartElement("basedOn");
        this.writeSimpleProperty(basedOn, this.m_modelRes.RID_cmSearchPath, "cmSearchPath");
        this.m_writer.writeEndElement();
    }

    private void writeReportingColumnProperties(MFWNodeHandle parent) throws XMLStreamException {
        this.writeSimpleProperty(parent, this.m_modelRes.RID_hidden, "hidden");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_usage, "usage");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_format, "format");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_currency, "currency");
        this.writeDataColumnProperties(parent);
        this.writeSimpleProperty(parent, this.m_modelRes.RID_displayType, "displayType");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_MIMEType, "MIMEType");
        this.writePromptInfo(parent);
        this.writeSimpleProperty(parent, this.m_modelRes.RID_regularAggregate, "regularAggregate");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_semiAggregate, "semiAggregate");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_sortOnRef, "sortOnRef");
        this.writeSimpleProperty(parent, this.m_modelRes.getResourceID("unSortable"), "unSortable");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_sort, "sort");
        if (parent.getInfo().findChildInfo(this.m_modelRes.RID_role) != null) {
            this.writeRoles(parent);
        }
        this.writeSimpleProperty(parent, this.m_modelRes.getResourceID("conformanceRef"), "conformanceRef");
    }

    private void writeDataColumnProperties(MFWNodeHandle parent) throws XMLStreamException {
        this.writeSimpleProperty(parent, this.m_modelRes.RID_datatype, "datatype");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_precision, "precision");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_scale, "scale");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_size, "size");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_nullable, "nullable");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_aggregationRule, "aggregationRule");
    }

    private void writePromptInfo(MFWNodeHandle parent) throws XMLStreamException {
        this.m_writer.writeStartElement("promptInfo");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_promptType, "promptType");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_promptCascadeOnRef, "promptCascadeOnRef");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_promptDisplayItemRef, "promptDisplayItemRef");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_promptFilterItemRef, "promptFilterItemRef");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_promptUseItemRef, "promptUseItemRef");
        this.m_writer.writeEndElement();
    }

    private void writeRoles(MFWNodeHandle parent) throws XMLStreamException {
        MFWNodeHandle[] roles = this.m_gateway.getObjectChildren(parent, this.m_modelRes.RID_role);
        if (roles.length > 0) {
            this.m_writer.writeStartElement("roles");
            MFWNodeHandle[] mFWNodeHandleArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle role = mFWNodeHandleArray[n2];
                this.writeRole(role);
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    private void writeRole(MFWNodeHandle role) throws XMLStreamException {
        this.m_writer.writeStartElement("role");
        this.writeSimpleProperty(role, this.m_modelRes.RID_intrinsic, "intrinsic");
        this.writeMulilingualProperties(role, this.m_modelRes.RID_name, "name");
        this.m_writer.writeEndElement();
    }

    private void writeMdProperties(MFWNodeHandle parent) throws XMLStreamException {
        this.writeSimpleProperty(parent, this.m_modelRes.RID_externalName, "externalName");
        this.writeSimpleProperty(parent, this.m_modelRes.RID_calcType, "calcType");
        this.writeRefObjCollection(parent, this.m_modelRes.RID_hierarchies, "hierarchies", this.m_modelRes.RID_refobj, "refobj");
        this.writeRefObjCollection(parent, this.m_modelRes.RID_dimensions, "dimensions", this.m_modelRes.RID_refobj, "refobj");
        this.writeRefObjCollection(parent, this.m_modelRes.RID_datasources, "dataSources", this.m_modelRes.RID_dataSourceRef, "dataSourceRef");
    }

    private void writeRefObjCollection(MFWNodeHandle parent, short collectionRid, String fmCollectionName, short referenceRid, String fmReferenceName) throws XMLStreamException {
        MFWNodeHandle[] hierarchies = this.m_gateway.getObjectChildren(parent, collectionRid);
        if (hierarchies != null && hierarchies.length > 0) {
            MFWNodeHandle[] refObj;
            this.m_writer.writeStartElement(fmCollectionName);
            MFWNodeHandle[] mFWNodeHandleArray = refObj = this.m_gateway.getObjectChildren(hierarchies[0], referenceRid);
            int n = refObj.length;
            int n2 = 0;
            while (n2 < n) {
                MFWNodeHandle refObject = mFWNodeHandleArray[n2];
                this.m_writer.writeStartElement(fmReferenceName);
                this.m_writer.writeCharacters(this.m_gateway.getPropertyValue(refObject));
                this.m_writer.writeEndElement();
                ++n2;
            }
            this.m_writer.writeEndElement();
        }
    }

    public static void serialize(MFWGateway gateway, OutputStream outStream) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(outStream, "UTF-8");
            MFWModelSerializer ms = new MFWModelSerializer(gateway, writer);
            ms.serialize();
            outStream.flush();
            outStream.close();
        }
        catch (XMLStreamException xse) {
            throw new RuntimeException(xse.getMessage(), xse);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }
}

