/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSecurityView;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.util.EmfHelper;
import com.ibm.cognos.fmeng.genmodel.CalculationType;
import com.ibm.cognos.fmeng.genmodel.DimensionType;
import com.ibm.cognos.fmeng.genmodel.FilterType;
import com.ibm.cognos.fmeng.genmodel.HierarchyFolderType;
import com.ibm.cognos.fmeng.genmodel.HierarchyType;
import com.ibm.cognos.fmeng.genmodel.IncludeRuleType;
import com.ibm.cognos.fmeng.genmodel.LevelType;
import com.ibm.cognos.fmeng.genmodel.MeasureFolderType;
import com.ibm.cognos.fmeng.genmodel.MeasureType;
import com.ibm.cognos.fmeng.genmodel.PackageViewType;
import com.ibm.cognos.fmeng.genmodel.QueryItemFolderType;
import com.ibm.cognos.fmeng.genmodel.QueryItemType;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectType;
import com.ibm.cognos.fmeng.genmodel.RelationshipShortcutType;
import com.ibm.cognos.fmeng.genmodel.RelationshipType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import com.ibm.cognos.fmeng.genmodel.ScopeRelationshipType;
import com.ibm.cognos.fmeng.genmodel.SectionType;
import com.ibm.cognos.fmeng.genmodel.SecurityDefinitionSetType;
import com.ibm.cognos.fmeng.genmodel.SecurityViewType;
import com.ibm.cognos.fmeng.genmodel.ShortcutType;
import com.ibm.cognos.fmeng.genmodel.ViewDefinitionType;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.impl.EMFSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.SerializationListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishSerializationListener
implements SerializationListener {
    EMFSession m_session = null;
    private List<Object> m_apexSet = null;
    private List<Object> m_excludeSet = null;
    private List<Object> m_hiddenSet = null;
    private List<FmNamespace> m_apexNamespacesSet = new ArrayList<FmNamespace>();
    private FmNamespace m_rootNamespace = null;
    private boolean m_bNoViewsSet = false;
    private boolean m_expandViews = false;
    private List<Object> m_packageViewSet = new ArrayList<Object>();
    private FmPackage m_package = null;
    private StringBuffer m_stringBuff = new StringBuffer();

    public static PublishSerializationListener create(FMMDSession session, FmPackage pckg, boolean expandViews) {
        PublishSerializationListener serializer = new PublishSerializationListener(session, pckg);
        FmSecurityView view = pckg.getSecurityView();
        serializer.m_apexSet = view.getConsolidatedIncludeSet();
        serializer.m_excludeSet = view.getConsolidatedExcludeSet();
        serializer.m_hiddenSet = view.getConsolidatedHiddenSet();
        serializer.m_expandViews = expandViews;
        serializer.m_rootNamespace = (FmNamespace)FmModelFactory.getInstance().getProject(session).getRootNamespace();
        ArrayList<FmSecurityView> pckViews = new ArrayList<FmSecurityView>();
        pckg.getSecurityView().getAllReferencedViews(pckViews);
        for (FmSecurityView sv : pckViews) {
            serializer.m_packageViewSet.add(sv.getInternal());
        }
        serializer.m_bNoViewsSet = serializer.m_excludeSet.size() == 0 && serializer.m_apexSet.size() == 1 && serializer.m_apexSet.contains(serializer.m_rootNamespace.getInternal());
        for (Object cur : serializer.m_apexSet) {
            FmBaseObject currBaseObj = (FmBaseObject)((Object)FmModelFactory.getInstance().get(session, cur));
            FmNamespace ns = currBaseObj.getParentNamespace();
            if (ns != null) {
                serializer.m_apexNamespacesSet.add(ns);
                continue;
            }
            serializer.m_apexNamespacesSet.add(serializer.m_rootNamespace);
        }
        return serializer;
    }

    private PublishSerializationListener(FMMDSession session, FmPackage pckg) {
        this.m_session = (EMFSession)session;
        this.m_package = pckg;
    }

    @Override
    public SerializationListener.SerializationStatus serializeStatus(Object obj, OutputStream outStream) {
        if (obj instanceof SecurityViewType) {
            if (((SecurityViewType)obj).isIsRoleBased() || this.m_packageViewSet.contains(obj)) {
                return SerializationListener.SerializationStatus.K_INCLUDE;
            }
            return SerializationListener.SerializationStatus.K_EXCLUDE;
        }
        if (obj instanceof PackageViewType) {
            if (obj == this.m_package.getInternal()) {
                return SerializationListener.SerializationStatus.K_INCLUDE;
            }
            return SerializationListener.SerializationStatus.K_EXCLUDE;
        }
        if (obj instanceof ViewDefinitionType) {
            this.writeViewDefinitionType((ViewDefinitionType)obj, outStream);
            return SerializationListener.SerializationStatus.K_OVERRIDDEN;
        }
        if (this.m_bNoViewsSet) {
            return SerializationListener.SerializationStatus.K_INCLUDE;
        }
        if (!this.canBeSuppressed(obj)) {
            return SerializationListener.SerializationStatus.K_INCLUDE;
        }
        if (obj instanceof RelationshipType) {
            FmRelationship rel = FmRelationship.get(this.m_session, obj);
            RelationshipEnd end = rel.getRightEnd();
            if (end != null && !this.isReferenceIncludedInPackage(end.getInternal())) {
                return SerializationListener.SerializationStatus.K_EXCLUDE;
            }
            end = rel.getLeftEnd();
            if (end != null && !this.isReferenceIncludedInPackage(end.getInternal())) {
                return SerializationListener.SerializationStatus.K_EXCLUDE;
            }
        }
        SerializationListener.SerializationStatus status = SerializationListener.SerializationStatus.K_EXCLUDE;
        List<Object> ancestorList = this.m_session.getGateway().getAncestorList(obj, this.m_rootNamespace.getInternal());
        if (this.m_apexSet.size() > 0 && (status = this.statusInApexChain(obj, ancestorList)) == SerializationListener.SerializationStatus.K_INCLUDE && this.isAncestorChainInSet(this.m_excludeSet, obj, ancestorList)) {
            status = SerializationListener.SerializationStatus.K_EXCLUDE;
        }
        return status;
    }

    private void writeViewDefinitionType(ViewDefinitionType viewDefObj, OutputStream outStream) {
        boolean isRoleBased = ((SecurityViewType)viewDefObj.eContainer()).isIsRoleBased();
        EList<SecurityDefinitionSetType> orginalSets = viewDefObj.getSet();
        this.dumpString("<definition>", outStream);
        int iSet = 0;
        while (iSet < orginalSets.size()) {
            SecurityDefinitionSetType orginalSet = (SecurityDefinitionSetType)orginalSets.get(iSet);
            IncludeRuleType ruleType = orginalSet.getIncludeRule();
            ArrayList<Object> checkRefList = new ArrayList<Object>();
            int icheck = 0;
            while (icheck < orginalSets.size()) {
                SecurityDefinitionSetType set = (SecurityDefinitionSetType)orginalSets.get(icheck);
                if (set.getIncludeRule() != ruleType) {
                    checkRefList.addAll((Collection<Object>)set.getRefobj());
                }
                ++icheck;
            }
            if (isRoleBased || ruleType != IncludeRuleType.EXCLUDE) {
                StringBuffer buf = new StringBuffer();
                buf.append("<set includeRule=\"");
                buf.append(ruleType.getLiteral());
                buf.append("\">");
                this.dumpString(buf.toString(), outStream);
                EList<EObject> refList = orginalSet.getRefobj();
                for (Object currObj : refList) {
                    if (this.m_excludeSet.contains(currObj)) continue;
                    this.dumpElement("refobj", this.m_session.getGateway().getID(currObj), outStream);
                    if (!this.m_expandViews) continue;
                    List<Object> descendentList = this.getDescendentEObjRefs(currObj, checkRefList);
                    for (Object currDesObj : descendentList) {
                        if (this.m_excludeSet.contains(currDesObj)) continue;
                        this.dumpElement("refobj", this.m_session.getGateway().getID(currDesObj), outStream);
                    }
                }
                this.dumpString("</set>", outStream);
            }
            ++iSet;
        }
        this.dumpString("</definition>", outStream);
    }

    private void dumpElement(String elementName, String value, OutputStream outStream) {
        this.m_stringBuff.setLength(0);
        this.m_stringBuff.append("<");
        this.m_stringBuff.append(elementName);
        this.m_stringBuff.append(">");
        this.m_stringBuff.append(StringEscapeUtils.escapeXml((String)value));
        this.m_stringBuff.append("</");
        this.m_stringBuff.append(elementName);
        this.m_stringBuff.append(">");
        this.dumpString(this.m_stringBuff.toString(), outStream);
    }

    private void dumpString(String value, OutputStream outStream) {
        try {
            outStream.write(value.getBytes("UTF-8"));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage());
        }
    }

    private List<Object> getDescendentEObjRefs(Object o, List<Object> checkRefList) {
        ArrayList<Object> childList = new ArrayList<Object>();
        List<?> children = this.m_session.getGateway().getChildren(o);
        for (Object child : children) {
            if (!(child instanceof ReportObjectType) || checkRefList.contains(child)) continue;
            childList.add(child);
            childList.addAll(this.getDescendentEObjRefs(child, checkRefList));
        }
        return childList;
    }

    private boolean isReferenceIncludedInPackage(Object obj) {
        List<Object> aList = this.m_session.getGateway().getAncestorList(obj, this.m_rootNamespace.getInternal());
        if (this.isAncestorChainInSet(this.m_excludeSet, obj, aList)) {
            return false;
        }
        if (this.isAncestorChainInSet(this.m_hiddenSet, obj, aList)) {
            return true;
        }
        if (this.isAncestorChainInSet(this.m_apexSet, obj, aList)) {
            return true;
        }
        return true;
    }

    private boolean isAncestorChainInSet(List<Object> set, Object obj, List<Object> ancestorList) {
        if (set.size() > 0) {
            if (set.contains(obj)) {
                return true;
            }
            for (Object ancestor : ancestorList) {
                if (!set.contains(ancestor)) continue;
                return true;
            }
        }
        return false;
    }

    private SerializationListener.SerializationStatus statusInApexChain(Object obj, List<Object> objAncestorList) {
        TopLevelObject currObj = FmModelFactory.getInstance().get(this.m_session, obj);
        if (objAncestorList.size() == 0) {
            if (this.m_apexNamespacesSet.contains(currObj)) {
                return SerializationListener.SerializationStatus.K_INCLUDE;
            }
            return SerializationListener.SerializationStatus.K_SUPPRESS;
        }
        if (this.m_apexNamespacesSet.contains(currObj)) {
            return SerializationListener.SerializationStatus.K_INCLUDE;
        }
        if (this.m_apexSet.contains(obj)) {
            return SerializationListener.SerializationStatus.K_INCLUDE;
        }
        for (Object ancestor : objAncestorList) {
            if (!this.m_apexSet.contains(ancestor)) continue;
            return SerializationListener.SerializationStatus.K_INCLUDE;
        }
        if (currObj instanceof FmSection) {
            for (FmNamespace ns : this.m_apexNamespacesSet) {
                Object eNsObj = ns.getInternal();
                if (EmfHelper.getAncestorList(obj, eNsObj).size() > 0) {
                    return SerializationListener.SerializationStatus.K_INCLUDE;
                }
                if (EmfHelper.getAncestorList(eNsObj, obj).size() <= 0) continue;
                return SerializationListener.SerializationStatus.K_SUPPRESS;
            }
        }
        return SerializationListener.SerializationStatus.K_EXCLUDE;
    }

    @Override
    public boolean canBeSuppressed(Object obj) {
        return obj instanceof SectionType || obj instanceof QuerySubjectType || obj instanceof QueryItemType || obj instanceof QueryItemFolderType || obj instanceof DimensionType || obj instanceof HierarchyType || obj instanceof LevelType || obj instanceof MeasureType || obj instanceof MeasureFolderType || obj instanceof HierarchyFolderType || obj instanceof FilterType || obj instanceof CalculationType || obj instanceof RelationshipType || obj instanceof RelationshipShortcutType || obj instanceof ScopeRelationshipType || obj instanceof ShortcutType || obj instanceof SecurityViewType;
    }

    @Override
    public void validateReference(Object obj) {
        if (obj instanceof ReportObjectType && !this.isReferenceIncludedInPackage(obj)) {
            throw new FmMDException("BMT_MD_EXCLUDED_REF_DURING_PUBLISH", new Object[]{this.m_session.getGateway().getID(obj)});
        }
    }
}

