/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.fmmd.impl.task.ModelPublisher;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.soap.ContentManagerServiceRequest;
import com.ibm.cognos.fmeng.utility.soap.ReportServerRequestHelper;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRolapDataSource {
    protected String mRolapDatasourceName = null;
    protected FMMDSession mFmmdSession = null;
    protected Element mElemResponse = null;
    private PublishModelHelper mPmh = null;
    private String mCmPath = "";

    public QueryRolapDataSource(FMMDSession fmmdSession, String sRolapDatasourceName) {
        this.mFmmdSession = fmmdSession;
        this.mRolapDatasourceName = sRolapDatasourceName;
    }

    public void connect() {
        if (this.mPmh == null) {
            this.mPmh = new PublishModelHelper(this.mFmmdSession, this.mRolapDatasourceName);
            this.mCmPath = this.mPmh.createSessionPackage();
        }
    }

    public void exec() {
        Document MAResponse = this.queryMA(this.mCmPath);
        this.mElemResponse = MAResponse.getRootElement();
    }

    public String getDatasourceName() {
        return this.mRolapDatasourceName;
    }

    public List<Element> getFolderNodes() {
        List folders = this.mElemResponse.selectNodes("/ResponseRoot/folder");
        return folders;
    }

    public List<String> getMeasureNames(String sParentMeasureDimID) {
        ArrayList<String> listMeasureNames = new ArrayList<String>();
        List members = this.mElemResponse.selectNodes("/ResponseRoot/folder/dimension[@_ref='" + sParentMeasureDimID + "'][@type='measure']/measure");
        for (Node member : members) {
            Element mem = (Element)member;
            listMeasureNames.add(mem.attributeValue("name"));
        }
        return listMeasureNames;
    }

    public List<String> getLevelNames(String sParentHierarchyID) {
        ArrayList<String> listLevelNames = new ArrayList<String>();
        List members = this.mElemResponse.getDocument().selectNodes("/ResponseRoot/folder/dimension/hierarchy[@_ref='" + sParentHierarchyID + "']/level");
        for (Node member : members) {
            Element mem = (Element)member;
            listLevelNames.add(mem.attributeValue("name"));
        }
        return listLevelNames;
    }

    public String getDefaultLocale() {
        return this.mFmmdSession.getProject().getDefaultLocale();
    }

    private Document queryMA(String sCmPath) {
        ReportServerRequestHelper rsqh = new ReportServerRequestHelper(this.mFmmdSession);
        String xmlSpec = rsqh.BuildMetadataRequest(sCmPath);
        rsqh.runMetadataSpecification(xmlSpec);
        return rsqh.getResponse();
    }

    public List<MAMember> execRootMemberQuery(String hierarchyCrnId) {
        ArrayList<MAMember> rootMembers = new ArrayList<MAMember>();
        ReportServerRequestHelper rsqh = new ReportServerRequestHelper(this.mFmmdSession);
        String rootMemberRequest = rsqh.BuildMemberRequest(this.mCmPath, hierarchyCrnId);
        rsqh.runMetadataSpecification(rootMemberRequest);
        Document responseDoc = rsqh.getResponse();
        this.parseRootMembersResponse(responseDoc, rootMembers);
        return rootMembers;
    }

    public List<MAMember> execMemberQuery(String parentMUN) {
        ArrayList<MAMember> members = new ArrayList<MAMember>();
        ReportServerRequestHelper rsqh = new ReportServerRequestHelper(this.mFmmdSession);
        String memberRequest = rsqh.BuildMemberRequest(this.mCmPath, parentMUN);
        rsqh.runMetadataSpecification(memberRequest);
        Document responseDoc = rsqh.getResponse();
        this.parseMemberResponse(responseDoc, members);
        return members;
    }

    private void parseMemberResponse(Document responseDoc, List<MAMember> members) {
        Element root = responseDoc.getRootElement();
        List memberNodes = root.selectNodes("member/member");
        for (Node memberNode : memberNodes) {
            Element e = (Element)memberNode;
            members.add(new MAMember(e.attributeValue("memberUniqueName"), e.attributeValue("memberCaption")));
        }
    }

    private void parseRootMembersResponse(Document responseDoc, List<MAMember> members) {
        Element root = responseDoc.getRootElement();
        List memberNodes = root.selectNodes("hierarchy/member");
        for (Node memberNode : memberNodes) {
            Element e = (Element)memberNode;
            members.add(new MAMember(e.attributeValue("memberUniqueName"), e.attributeValue("memberCaption")));
        }
    }

    public class MAMember {
        private String m_mun;
        private String m_caption;

        private MAMember(String mun, String caption) {
            this.m_mun = mun;
            this.m_caption = caption;
        }

        public String getMun() {
            return this.m_mun;
        }

        public String getCaption() {
            return this.m_caption;
        }
    }

    class PublishModelHelper {
        private static final String FMT_DATASOURCE_QUERY_PACKAGENAME = "__DatasourceQueryPkg__%s";
        private static final String CM_SESSION_ID = "~~";
        private FMMDSession mFmmdSession;
        private String msCmDataSource;
        private String msModelPath;

        public PublishModelHelper(FMMDSession fmmdSession, String sCmRolapDataSource) {
            FmMDException.ASSERT(fmmdSession != null, "fmmdSession is NULL");
            FmMDException.ASSERT(sCmRolapDataSource != null && sCmRolapDataSource.length() > 0, "sCmRolapDataSource is empty or NULL");
            this.mFmmdSession = fmmdSession;
            this.msCmDataSource = sCmRolapDataSource;
        }

        public String createSessionPackage() {
            FMMDSession tempSessionNewModel = this.generateLWM();
            this.msModelPath = this.publishSessionPackage(tempSessionNewModel);
            return this.msModelPath;
        }

        public void deleteSessionPackage() {
            String pkgPath = this.msModelPath.substring(0, this.msModelPath.lastIndexOf("/model"));
            ContentManagerServiceRequest cmRequest = new ContentManagerServiceRequest(this.mFmmdSession.getActiveLocale(), this.mFmmdSession.getPassport());
            cmRequest.deletePackage(pkgPath);
        }

        private String publishSessionPackage(FMMDSession tempSessionNewModel) {
            String sPackageName = String.format(FMT_DATASOURCE_QUERY_PACKAGENAME, this.msCmDataSource);
            ModelPublisher publisher = new ModelPublisher(tempSessionNewModel);
            String sModelPath = publisher.publishModelToCM(CM_SESSION_ID, sPackageName, Long.toString(System.nanoTime()), null);
            return sModelPath;
        }

        private FMMDSession generateLWM() {
            FMMDSession tempNewModelSession = FMMDSession.createFMMDSession(this.mFmmdSession);
            tempNewModelSession.create(ProjectFactory.createInMemoryProject());
            tempNewModelSession.createLWMDynamicModel(this.msCmDataSource, this.mFmmdSession.getDefaultLocale());
            tempNewModelSession.setPassport(this.mFmmdSession.getPassport());
            return tempNewModelSession;
        }
    }
}

