/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.axis.encoding.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class StringDecryptionHelper {
    private static final String ENCRYPTED_VALUE = "encryptedValue";
    static final String CAM_INIT_PARAM = "<initializeDocument><serviceID>FMENG</serviceID></initializeDocument>";
    private String mDecryptedCredentialAsXML = null;

    public StringDecryptionHelper(String credentialXML) {
        this.extractAndDecryptCMCredentials(credentialXML);
    }

    private void extractAndDecryptCMCredentials(String credentialXML) {
        if (credentialXML == null) {
            return;
        }
        Document domCredential = null;
        try {
            SAXReader reader = new SAXReader();
            domCredential = reader.read((Reader)new StringReader(credentialXML));
        }
        catch (Throwable throwable) {
            return;
        }
        Element credentialsElement = domCredential.getRootElement();
        Element encryptedValueElement = credentialsElement.element(ENCRYPTED_VALUE);
        if (encryptedValueElement == null) {
            this.mDecryptedCredentialAsXML = credentialXML;
            return;
        }
        try {
            this.mDecryptedCredentialAsXML = this.decrypt(encryptedValueElement);
        }
        catch (NoClassDefFoundError e) {
            FmMDException.ASSERT(false, "No class found: " + e.getMessage());
        }
        catch (Throwable e) {
            throw new FmMDException("BMT_MD_CM_ERROR_NESTED_EXCEPTION", null, e);
        }
    }

    private String decrypt(Element encryptedCredential) {
        String base64EncryptedString;
        block4: {
            base64EncryptedString = encryptedCredential.getText();
            if (base64EncryptedString != null) break block4;
            return "";
        }
        try {
            byte[] decodedData = Base64.decode((String)base64EncryptedString);
            CAMFactory camFactory = new CAMFactory();
            camFactory.initialize(CAM_INIT_PARAM.getBytes("UTF-8"));
            EncryptingSession session = camFactory.createEncryptingSession();
            byte[] decryptedData = session.decryptData(decodedData);
            return new String(decryptedData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (CAMCryptoException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String encrypt(String credential) {
        try {
            CAMFactory camFactory = new CAMFactory();
            camFactory.initialize(CAM_INIT_PARAM.getBytes("UTF-8"));
            EncryptingSession session = camFactory.createEncryptingSession();
            byte[] byteData = credential.getBytes("UTF-8");
            byte[] encryptedData = session.encryptData(byteData);
            return "&lt;credential&gt;&lt;encryptedValue&gt;" + Base64.encode((byte[])encryptedData) + "&lt;/encryptedValue&gt;&lt;/credential&gt;";
        }
        catch (CAMCryptoException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String extractCredentialsFromXMLString(String paramItemName) {
        Document doc = null;
        String paramItemValue = "";
        try {
            doc = DocumentHelper.parseText((String)this.mDecryptedCredentialAsXML);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (doc == null) {
            return paramItemValue;
        }
        Element credentialsElement = doc.getRootElement();
        Element paramElement = credentialsElement.element(paramItemName);
        if (paramElement != null) {
            paramItemValue = paramElement.getText();
        }
        return paramItemValue;
    }
}

