/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility;

import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V5DataItem {
    private static HashMap<String, String> properties = new HashMap();
    private String m_v5Expression = null;
    private String m_parentId = null;
    private CubeBase m_cube = null;
    private String m_name = null;
    private dataItemType m_type = dataItemType.eUnknown;

    static {
        properties.put("forMissingMembers", "false");
    }

    public static V5DataItem createV5DataItem(dataItemType type, CubeBase cube, String parentId, String name, String expression) {
        return new V5DataItem(type, cube, parentId, name, expression);
    }

    private V5DataItem(dataItemType type, CubeBase cube, String parentId, String name, String expression) {
        this.m_v5Expression = expression;
        this.m_cube = cube;
        this.m_name = name;
        this.m_type = type;
        this.m_parentId = parentId;
    }

    public String getName() {
        return this.m_name;
    }

    public String getCubeName() {
        return this.m_cube.getName();
    }

    public static HashMap<String, String> getProperties() {
        return properties;
    }

    public String getV5Expression() {
        StringBuilder v5 = new StringBuilder();
        switch (this.m_type) {
            case eCalculatedMember: {
                v5.append("member(");
                v5.append(this.m_v5Expression);
                v5.append(", '', '");
                v5.append(String.valueOf(this.m_name) + "_1");
                v5.append("', ");
                v5.append(this.getParentId());
                v5.append(")");
                break;
            }
            case eNamedSet: 
            case eAccessRole: {
                v5.append(this.m_v5Expression);
                break;
            }
            default: {
                v5.append(this.m_v5Expression);
            }
        }
        return v5.toString();
    }

    private String getParentId() {
        String[] parts = this.m_parentId.split("\\.");
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append("[" + this.getCubeName() + "]");
        int i = 0;
        while (i < parts.length) {
            if (i != 0) {
                uniqueName.append(".");
                uniqueName.append(parts[i]);
            }
            ++i;
        }
        return uniqueName.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum dataItemType {
        eCalculatedMember,
        eCalculatedMeasure,
        eNamedSet,
        eAccessRole,
        eUnknown;

    }
}

