/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility.soap;

import com.cognos.developer.schemas.bibus._3.AccessEnum;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AnyTypeMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.Group;
import com.cognos.developer.schemas.bibus._3.IntProp;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.ModelView;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Namespace;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.PackageConfiguration;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PolicyArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.RetentionRule;
import com.cognos.developer.schemas.bibus._3.RetentionRuleArrayProp;
import com.cognos.developer.schemas.bibus._3.Role;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UiComponentEnum;
import com.cognos.developer.schemas.bibus._3.UiComponentEnumArrayProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnumArrayProp;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.util.CmHelper;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.soap.FmEngSoapRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.OctetStream;
import org.apache.axis.attachments.OctetStreamDataSource;
import org.apache.axis.client.Stub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentManagerServiceRequest
extends FmEngSoapRequest {
    private ContentManagerService_PortType m_cmService;

    public ContentManagerServiceRequest(ContentManagerService_PortType cmService) {
        this.m_cmService = cmService;
    }

    public ContentManagerServiceRequest(Locale locale) {
        this(locale, null);
    }

    public ContentManagerServiceRequest(Locale locale, String passport) {
        ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
        try {
            this.m_cmService = serviceLocator.getcontentManagerService(new URL(this.getDispatcherURL()));
            ContentManagerServiceRequest.initializeStub((Stub)this.m_cmService, passport, locale.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ContentManagerServiceRequest(Locale locale, String passport, String dispatcherURL) {
        ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
        try {
            this.m_cmService = serviceLocator.getcontentManagerService(new URL(dispatcherURL));
            ContentManagerServiceRequest.initializeStub((Stub)this.m_cmService, passport, locale.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public BaseClass[] queryForAccount() {
        try {
            SearchPathMultipleObject smo = new SearchPathMultipleObject("~");
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.identity, PropEnum.storeID, PropEnum.searchPath};
            QueryOptions options = new QueryOptions();
            options.setSchemaInfo(false);
            options.setPermission("read");
            options.setMaxObjects(BigInteger.ZERO);
            options.setSkipObjects(BigInteger.ZERO);
            options.setDataEncoding(EncodingEnum.base64);
            options.setMaxDataBytes(BigInteger.ZERO);
            options.setSkipDataBytes(BigInteger.ZERO);
            BaseClass[] result = this.m_cmService.query(smo, props, null, options);
            return result;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public UserCapabilityEnum[] queryForUserCapabilities() {
        SearchPathMultipleObject smo = new SearchPathMultipleObject("~~");
        PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.userCapabilities};
        QueryOptions options = new QueryOptions();
        try {
            BaseClass[] objs = this.m_cmService.query(smo, props, null, options);
            Session sessionObj = (Session)objs[0];
            UserCapabilityEnumArrayProp capabilites = sessionObj.getUserCapabilities();
            return capabilites.getValue();
        }
        catch (RemoteException e) {
            throw FmEngSoapRequest.handleRemoteException(e);
        }
    }

    public List<String> queryForRoles() {
        ArrayList<String> camids = new ArrayList<String>();
        String searchPath = "CAMID(\":\")/*";
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.name, PropEnum.objectClass};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] foundRoles = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            if (foundRoles.length > 0) {
                BaseClass[] baseClassArray = foundRoles;
                int n = foundRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseClass bc = baseClassArray[n2];
                    if (bc instanceof Role || bc instanceof Group || bc instanceof Account) {
                        StringProp prop = bc.getSearchPath();
                        camids.add(prop.getValue());
                    }
                    ++n2;
                }
            }
            return camids;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public BaseClass queryForRole(String searchPath) {
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.name, PropEnum.objectClass};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] foundRoles = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            if (foundRoles.length > 0) {
                BaseClass[] baseClassArray = foundRoles;
                int n = foundRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseClass bc = baseClassArray[n2];
                    if (bc instanceof Role || bc instanceof Group || bc instanceof Account) {
                        return bc;
                    }
                    ++n2;
                }
            }
            return null;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public UserCapabilityCache queryForUserCapabilityCache() {
        SearchPathMultipleObject smo = new SearchPathMultipleObject("~~");
        PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.userCapabilities};
        QueryOptions options = new QueryOptions();
        UserCapabilityCache ucc = null;
        try {
            this.m_cmService.query(smo, props, null, options);
            BiBusHeader bibus = MFWBiBusHelper.getBiBusHeader((Stub)((Stub)this.m_cmService));
            ucc = bibus.getUserCapabilityCache();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return ucc;
    }

    public String queryForPassport() {
        try {
            SearchPathMultipleObject smo = new SearchPathMultipleObject("~");
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName};
            QueryOptions options = new QueryOptions();
            options.setSchemaInfo(false);
            options.setPermission("read");
            options.setMaxObjects(BigInteger.ZERO);
            options.setSkipObjects(BigInteger.ZERO);
            options.setDataEncoding(EncodingEnum.base64);
            options.setMaxDataBytes(BigInteger.ZERO);
            options.setSkipDataBytes(BigInteger.ZERO);
            this.m_cmService.query(smo, props, null, options);
            BiBusHeader bibus = MFWBiBusHelper.getBiBusHeader((Stub)((Stub)this.m_cmService));
            String passport = bibus.getCAM().getCAMPassport().getId();
            return passport;
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue.getMessage(), mue);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String createPackage(String parentPath, String pkgName, String locale, ReportObject obj) {
        try {
            MultilingualToken[] nameTokens;
            _package cmPackage = new _package();
            if (obj != null) {
                nameTokens = new MultilingualToken[obj.getNames().size()];
                int i = 0;
                while (i < obj.getNames().size()) {
                    nameTokens[i] = new MultilingualToken();
                    nameTokens[i].setLocale(obj.getNames().get(i).getLocale());
                    nameTokens[i].setValue(obj.getNames().get(i).getValue());
                    ++i;
                }
            } else {
                MultilingualToken name = new MultilingualToken();
                name.setLocale(locale);
                name.setValue(pkgName);
                nameTokens = new MultilingualToken[]{name};
            }
            MultilingualTokenProp nameProp = new MultilingualTokenProp();
            nameProp.setValue(nameTokens);
            cmPackage.setName(nameProp);
            this.setModelRetention(cmPackage, 0);
            this.setUserInterfacesForDynamicCubes(cmPackage);
            SearchPathSingleObject searchObj = new SearchPathSingleObject();
            searchObj.set_value(parentPath);
            AddOptions packageAddOptions = new AddOptions();
            packageAddOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
            BaseClass[] objs = new BaseClass[]{cmPackage};
            BaseClass[] retClasses = this.m_cmService.add(searchObj, objs, packageAddOptions);
            if (retClasses != null && retClasses.length > 0) {
                return retClasses[0].getSearchPath().getValue();
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        return null;
    }

    public String updatePackage(String cmPackagePath, String pkgName, String locale, ReportObject obj) {
        try {
            MultilingualToken[] nameTokens;
            _package cmPackage = new _package();
            if (obj != null) {
                nameTokens = new MultilingualToken[obj.getNames().size()];
                int i = 0;
                while (i < obj.getNames().size()) {
                    nameTokens[i] = new MultilingualToken();
                    nameTokens[i].setLocale(obj.getNames().get(i).getLocale());
                    nameTokens[i].setValue(obj.getNames().get(i).getValue());
                    ++i;
                }
            } else {
                MultilingualToken name = new MultilingualToken();
                name.setLocale(locale);
                name.setValue(pkgName);
                nameTokens = new MultilingualToken[]{name};
            }
            MultilingualTokenProp nameProp = new MultilingualTokenProp();
            nameProp.setValue(nameTokens);
            cmPackage.setName(nameProp);
            StringProp cmPathProp = new StringProp();
            cmPathProp.setValue(cmPackagePath);
            cmPackage.setSearchPath(cmPathProp);
            this.setModelRetention(cmPackage, 0);
            this.setUserInterfacesForDynamicCubes(cmPackage);
            UpdateOptions packageUpdateOptions = new UpdateOptions();
            packageUpdateOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
            BaseClass[] objs = new BaseClass[]{cmPackage};
            BaseClass[] retClasses = this.m_cmService.update(objs, packageUpdateOptions);
            if (retClasses != null && retClasses.length > 0) {
                return retClasses[0].getSearchPath().getValue();
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        return null;
    }

    private void setUserInterfacesForDynamicCubes(_package cmPackage) {
        HashSet<UiComponentEnum> uicomps = new HashSet<UiComponentEnum>();
        uicomps.add(UiComponentEnum.eventStudio);
        uicomps.add(UiComponentEnum.queryStudio);
        uicomps.add(UiComponentEnum.reportStudio);
        uicomps.add(UiComponentEnum.analysisStudio);
        UiComponentEnum[] enumArray = uicomps.toArray(new UiComponentEnum[uicomps.size()]);
        UiComponentEnumArrayProp uiComponentEnumProp = new UiComponentEnumArrayProp();
        uiComponentEnumProp.setValue(enumArray);
        cmPackage.setUserInterfaces(uiComponentEnumProp);
    }

    public void updateUIInterfacesForDynamicCubes(String cmPackagePath) {
        _package cmPackage = new _package();
        StringProp cmPathProp = new StringProp();
        cmPathProp.setValue(cmPackagePath);
        cmPackage.setSearchPath(cmPathProp);
        this.setUserInterfacesForDynamicCubes(cmPackage);
        BaseClass[] baseClass = new BaseClass[]{cmPackage};
        try {
            this.m_cmService.update(baseClass, new UpdateOptions());
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public void createPackageConfiguration(String pkgParent, String name) {
        String pkgPath = String.valueOf(pkgParent) + "/package[@name=\"" + name + "\"]";
        try {
            PackageConfiguration pkgConfig = new PackageConfiguration();
            AddOptions addOptions = new AddOptions();
            addOptions.setUpdateAction(UpdateActionEnum.update);
            TokenProp nameToken = new TokenProp();
            nameToken.setValue(name);
            pkgConfig.setDefaultName(nameToken);
            IntProp dcProp = new IntProp();
            dcProp.setValue(5);
            pkgConfig.setCrosstabItemDisplayCountDefault(dcProp);
            IntProp dclProp = new IntProp();
            dclProp.setValue(20);
            pkgConfig.setCrosstabItemDisplayCountLimit(dclProp);
            IntProp mdcdProp = new IntProp();
            mdcdProp.setValue(20);
            pkgConfig.setMemberDisplayCountDefault(mdcdProp);
            IntProp mdclProp = new IntProp();
            mdclProp.setValue(50);
            pkgConfig.setMemberDisplayCountLimit(mdclProp);
            SearchPathSingleObject searchObj = new SearchPathSingleObject();
            searchObj.set_value(pkgPath);
            BaseClass[] addObjs = new BaseClass[]{pkgConfig};
            this.m_cmService.add(searchObj, addObjs, addOptions);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    private void setModelRetention(_package cmPackage, int modelRetention) {
        RetentionRule[] retentionRule = new RetentionRule[]{new RetentionRule()};
        retentionRule[0].setMaxObjects(BigInteger.valueOf(modelRetention));
        retentionRule[0].setObjectClass(ClassEnum.fromString((String)"model"));
        retentionRule[0].setProp(PropEnum.creationTime);
        RetentionRuleArrayProp retentionRuleProp = new RetentionRuleArrayProp();
        retentionRuleProp.setValue(retentionRule);
        cmPackage.setRetentions(retentionRuleProp);
    }

    public String createModel(String cmPackagePath, boolean disableModelVersioning, String modelName, boolean bIsV5DataServerEnabled, ByteArrayOutputStream stream) {
        try {
            if (disableModelVersioning) {
                this.deleteAllModelsInPackage(cmPackagePath);
            }
            Model model = new Model();
            AnyTypeMIMEProp mimeProp = new AnyTypeMIMEProp();
            OctetStream aStream = new OctetStream(stream.toByteArray());
            OctetStreamDataSource ds = new OctetStreamDataSource("somename", aStream);
            DataHandler dh = new DataHandler((DataSource)ds);
            AttachmentPart attachment = new AttachmentPart(dh);
            attachment.setMimeHeader("Content-Encoding", "gzip");
            mimeProp.setValue("[attribute]" + attachment.getContentIdRef());
            model.setModel(mimeProp);
            if (disableModelVersioning) {
                TokenProp nameProp;
                if (modelName == null || modelName.length() == 0) {
                    nameProp = new TokenProp();
                    nameProp.setValue("model");
                    model.setDefaultName(nameProp);
                } else {
                    nameProp = new TokenProp();
                    nameProp.setValue(modelName);
                    model.setDefaultName(nameProp);
                }
            }
            OptionArrayProp optionArrayProp = new OptionArrayProp();
            GenericOptionAnyURI genericOption = new GenericOptionAnyURI();
            genericOption.setName("http://developer.cognos.com/ceba/constants/queryOptionEnum#mode");
            if (bIsV5DataServerEnabled) {
                genericOption.setValue("http://developer.cognos.com/ceba/constants/queryModeEnum#dynamic");
            } else {
                genericOption.setValue("http://developer.cognos.com/ceba/constants/queryModeEnum#compatible");
            }
            Option[] optionArray = new Option[]{genericOption};
            optionArrayProp.setValue(optionArray);
            model.setOptions(optionArrayProp);
            AddOptions modelAddOptions = new AddOptions();
            modelAddOptions.setDataEncoding(EncodingEnum.MIME);
            modelAddOptions.setUpdateAction(UpdateActionEnum.replace);
            modelAddOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
            ((Stub)this.m_cmService).addAttachment((Object)attachment);
            BaseClass[] baseClassObjects = new BaseClass[]{model};
            String modelPath = "";
            BaseClass[] addedItems = null;
            addedItems = this.m_cmService.add(new SearchPathSingleObject(cmPackagePath), baseClassObjects, modelAddOptions);
            if (addedItems.length > 0) {
                modelPath = addedItems[0].getSearchPath().getValue();
            }
            return modelPath;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    private void deleteAllModelsInPackage(String cmPackagePath) throws RemoteException {
        String searchPath = String.valueOf(cmPackagePath) + "/model";
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        BaseClass[] models = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
        if (models.length > 0) {
            DeleteOptions deleteOpt = new DeleteOptions();
            deleteOpt.setForce(true);
            deleteOpt.setRecursive(true);
            this.m_cmService.delete(models, deleteOpt);
        }
    }

    public boolean packageConfigurationExists(String pkgPath, String name) {
        boolean bPackageConfigurationExists = false;
        String pkgCfgPath = String.valueOf(pkgPath) + "/package[@name=\"" + name + "\"]/packageConfiguration";
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.objectClass, PropEnum.name};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] foundPackages = this.m_cmService.query(new SearchPathMultipleObject(pkgCfgPath), propArray, null, queryOpts);
            int idx = 0;
            while (idx < foundPackages.length) {
                if (foundPackages[idx] instanceof PackageConfiguration) {
                    bPackageConfigurationExists = true;
                    break;
                }
                ++idx;
            }
        }
        catch (RemoteException remoteException) {}
        return bPackageConfigurationExists;
    }

    public BaseClass findPackage(String cmPath, List<String> packageNames, List<String> actualNames, List<UiComponentEnum> userInterfaces, HashMap<String, List<BaseClass>> securityObjects) {
        String searchPath = this.buildMultiNameSearchPath(cmPath, packageNames, "package");
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.name, PropEnum.userInterfaces};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] foundPackages = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            String cmPackagePath = null;
            _package foundPkg = null;
            if (foundPackages.length > 1) {
                throw new FmMDException("BMT_MD_TOO_MANY_CM_PACKAGES_WITH_CONFLICTING_NAMES");
            }
            if (foundPackages.length == 1) {
                UiComponentEnumArrayProp cmUserInterfaces;
                FmMDException.ASSERT(foundPackages[0] instanceof _package, "Incorrect CM object encountered: " + foundPackages[0].getClass().toString());
                _package pkg = (_package)foundPackages[0];
                cmPackagePath = pkg.getSearchPath().getValue();
                if (actualNames != null) {
                    MultilingualTokenProp multiProp = ((_package)foundPackages[0]).getName();
                    MultilingualToken[] token = multiProp.getValue();
                    int i = 0;
                    while (i < token.length) {
                        actualNames.add(token[i].getValue());
                        ++i;
                    }
                }
                if (userInterfaces != null && (cmUserInterfaces = pkg.getUserInterfaces()) != null && cmUserInterfaces.getValue() != null) {
                    UiComponentEnum[] uiComponentEnumArray = cmUserInterfaces.getValue();
                    int n = uiComponentEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UiComponentEnum userInterface = uiComponentEnumArray[n2];
                        userInterfaces.add(userInterface);
                        ++n2;
                    }
                }
                if (securityObjects != null) {
                    this.queryForPackageSecurityViews(cmPackagePath, securityObjects);
                }
                foundPkg = pkg;
            }
            return foundPkg;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public String findPackage(String cmPath, List<String> packageNames, HashMap<String, String> packageProperties) {
        String searchPath = this.buildMultiNameSearchPath(cmPath, packageNames, "package");
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.name, PropEnum.userInterfaces, PropEnum.creationTime, PropEnum.modificationTime};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] foundPackages = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            String cmPackagePath = null;
            if (foundPackages.length > 0) {
                FmMDException.ASSERT(foundPackages[0] instanceof _package, "Incorrect CM object encountered: " + foundPackages[0].getClass().toString());
                _package pkg = (_package)foundPackages[0];
                cmPackagePath = pkg.getSearchPath().getValue();
                if (packageProperties != null) {
                    packageProperties.put("searchPath", cmPackagePath);
                    packageProperties.put("creationTime", pkg.getCreationTime().getValue().toString());
                    packageProperties.put("modificationTime", pkg.getModificationTime().getValue().toString());
                }
            }
            return cmPackagePath;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public void queryForPackageSecurityViews(String cmPackagePath, HashMap<String, List<BaseClass>> securityObjects) {
        String modelSearchPath = String.valueOf(cmPackagePath) + "/model[last()]/*";
        PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.policies, PropEnum.objectClass};
        QueryOptions options = new QueryOptions();
        options.setSchemaInfo(false);
        options.setPermission("read");
        options.setMaxObjects(BigInteger.ZERO);
        options.setSkipObjects(BigInteger.ZERO);
        options.setDataEncoding(EncodingEnum.base64);
        options.setMaxDataBytes(BigInteger.ZERO);
        options.setSkipDataBytes(BigInteger.ZERO);
        BaseClass[] rets = null;
        try {
            rets = this.m_cmService.query(new SearchPathMultipleObject(modelSearchPath), props, new Sort[0], options);
        }
        catch (RemoteException e) {
            throw FmEngSoapRequest.handleRemoteException(e);
        }
        if (rets != null) {
            BaseClass[] baseClassArray = rets;
            int n = rets.length;
            int n2 = 0;
            while (n2 < n) {
                BaseClass result = baseClassArray[n2];
                if (result instanceof ModelView) {
                    ModelView modelView = (ModelView)result;
                    String id = modelView.getDefaultName().getValue();
                    ArrayList<BaseClass> securityObjectList = new ArrayList<BaseClass>();
                    PolicyArrayProp policiesArray = modelView.getPolicies();
                    Policy[] policyArray = policiesArray.getValue();
                    int n3 = policyArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Policy somePolicy = policyArray[n4];
                        BaseClass securityObject = somePolicy.getSecurityObject();
                        securityObjectList.add(securityObject);
                        ++n4;
                    }
                    securityObjects.put(id, securityObjectList);
                }
                ++n2;
            }
        }
    }

    public BaseClass findRolapDataSource(String cmParentPath, List<String> cubeNames) {
        String searchPath = this.buildMultiNameSearchPath(cmParentPath, cubeNames, "*");
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.objectClass, PropEnum.name};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] foundDataSources = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            BaseClass foundDs = null;
            if (foundDataSources.length > 1) {
                throw new FmMDException("BMT_MD_TOO_MANY_CM_CUBES_WITH_CONFLICTING_NAMES");
            }
            if (foundDataSources.length == 1) {
                foundDs = foundDataSources[0];
                foundDs.getSearchPath().getValue();
                String eType = foundDataSources[0].getObjectClass().getValue().getValue();
                if (!"rolapDataSource".equals(eType) && !"rolapVirtualDataSource".equals(eType)) {
                    throw new FmMDException("BMT_MD_FAILED_DEPLOY_CUBE_NAME_COLLISION", cubeNames.get(0), eType);
                }
            }
            return foundDs;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public List<CmHelper.DSConnectionRecord> queryForConnections(String cmDatasourcePath) {
        ArrayList<CmHelper.DSConnectionRecord> outConns = new ArrayList<CmHelper.DSConnectionRecord>();
        try {
            SearchPathMultipleObject smo = new SearchPathMultipleObject(cmDatasourcePath);
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.connectionString, PropEnum.credentialNamespaces};
            BaseClass[] results = this.m_cmService.query(smo, props, null, null);
            int idx = 0;
            while (idx < results.length) {
                if (results[idx] != null && results[idx] instanceof DataSourceConnection) {
                    BaseClass[] values;
                    DataSourceConnection cmConn = (DataSourceConnection)results[idx];
                    String connStr = null;
                    if (cmConn.getConnectionString() != null) {
                        connStr = cmConn.getConnectionString().getValue();
                    }
                    String credntialNS = null;
                    BaseClassArrayProp credentialNamespaces = cmConn.getCredentialNamespaces();
                    if (credentialNamespaces != null && (values = credentialNamespaces.getValue()) != null && values.length > 0) {
                        Namespace ns = (Namespace)values[0];
                        StringProp prop = ns.getSearchPath();
                        credntialNS = prop.getValue();
                    }
                    outConns.add(new CmHelper.DSConnectionRecord(cmConn.getDefaultName().getValue(), cmConn.getSearchPath().getValue(), connStr, credntialNS));
                }
                ++idx;
            }
        }
        catch (RemoteException re) {
            throw new FmMDException("BMT_MD_CM_ERROR_NESTED_EXCEPTION", null, re);
        }
        return outConns;
    }

    public List<CmHelper.DSSignonRecord> queryForSignons(String cmConnectionPath) {
        ArrayList<CmHelper.DSSignonRecord> outSignons = new ArrayList<CmHelper.DSSignonRecord>();
        try {
            SearchPathMultipleObject smo = new SearchPathMultipleObject(cmConnectionPath);
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.credentials};
            BaseClass[] results = this.m_cmService.query(smo, props, null, null);
            int idx = 0;
            while (idx < results.length) {
                if (results[idx] != null && results[idx] instanceof DataSourceSignon) {
                    DataSourceSignon aSignon = (DataSourceSignon)results[idx];
                    String signonCred = aSignon.getCredentials() != null ? aSignon.getCredentials().getValue() : null;
                    outSignons.add(new CmHelper.DSSignonRecord(aSignon.getDefaultName().getValue(), aSignon.getSearchPath().getValue(), signonCred));
                }
                ++idx;
            }
            return outSignons;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    private String buildMultiNameSearchPath(String rootPath, List<String> names, String objType) {
        StringBuilder searchPath = new StringBuilder(rootPath);
        if (!rootPath.endsWith("/")) {
            searchPath.append("/");
        }
        if (names.size() > 0) {
            searchPath.append(objType);
            searchPath.append("[@name=\"");
            searchPath.append(names.get(0));
            searchPath.append("\"");
            int i = 1;
            while (i < names.size()) {
                searchPath.append(" or @name=\"");
                searchPath.append(names.get(i));
                searchPath.append("\"");
                ++i;
            }
            searchPath.append("]");
        }
        return searchPath.toString();
    }

    public void addModelView(String cmModelPath, String viewId, List<BaseClass> securityObjects) {
        ModelView modelView = new ModelView();
        TokenProp defaultNameProp = new TokenProp();
        defaultNameProp.setValue(viewId);
        modelView.setDefaultName(defaultNameProp);
        BaseClass[] baseClass = new BaseClass[]{modelView};
        SearchPathSingleObject searchObj = new SearchPathSingleObject();
        searchObj.set_value(cmModelPath);
        AddOptions opt = new AddOptions();
        opt.setUpdateAction(UpdateActionEnum.replace);
        ModelView newModelView = null;
        try {
            BaseClass[] ret = this.m_cmService.add(searchObj, baseClass, opt);
            if (ret.length == 1 && ret[0] instanceof ModelView) {
                newModelView = (ModelView)ret[0];
            }
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        this.setModelViewSecurityObjects(newModelView, securityObjects);
    }

    public void deletePackage(String strSearchPath) {
        BaseClass[] baseClass = new BaseClass[1];
        _package p = new _package();
        StringProp searchPath = new StringProp();
        searchPath.setValue(strSearchPath);
        p.setSearchPath(searchPath);
        baseClass[0] = p;
        DeleteOptions ops = new DeleteOptions();
        ops.setRecursive(true);
        ops.setForce(true);
        try {
            this.m_cmService.delete(baseClass, ops);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public InputStream getPackageModelContent(String modelSearchPath) {
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.model};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.MIMECompressed);
        try {
            BaseClass[] models = this.m_cmService.query(new SearchPathMultipleObject(modelSearchPath), propArray, null, queryOpts);
            Object[] attachments = ((Stub)this.m_cmService).getAttachments();
            if (attachments.length > 0) {
                AttachmentPart attach = (AttachmentPart)attachments[0];
                DataHandler handler = attach.getDataHandler();
                InputStream is = attach.getDataHandler().getInputStream();
                String[] contentEncodingHeader = attach.getMimeHeader("Content-Encoding");
                if (contentEncodingHeader != null && contentEncodingHeader.length > 0 && contentEncodingHeader[0].equals("gzip")) {
                    return new ReleaseInputStream(new GZIPInputStream(is), handler);
                }
                return is;
            }
            if (models.length > 0) {
                Model model = (Model)models[0];
                AnyTypeMIMEProp theMimeProp = model.getModel();
                String strValue = theMimeProp.getValue();
                return new ByteArrayInputStream(strValue.getBytes("UTF-8"));
            }
            throw new FmMDException("BMT_MD_CM_PACKAGE_MODEL_NOT_FOUND", modelSearchPath);
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        catch (SOAPException e) {
            FmEngApplicationLog.getApplicationLog().logException(e);
        }
        return null;
    }

    public int getPackageRetention(String packagePath) {
        int retention = -1;
        PropEnum[] propArray = new PropEnum[]{PropEnum.retentions};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] foundPackages = this.m_cmService.query(new SearchPathMultipleObject(packagePath), propArray, null, queryOpts);
            if (foundPackages.length > 0) {
                RetentionRuleArrayProp prop = ((_package)foundPackages[0]).getRetentions();
                RetentionRule[] rules = prop.getValue();
                int i = 0;
                while (i < rules.length) {
                    if (rules[i].getObjectClass().getValue().equals("model")) {
                        retention = rules[i].getMaxObjects().intValue();
                    }
                    ++i;
                }
            }
            return retention;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public int getPackageModelCnt(String packagePath) {
        String searchPath = String.valueOf(packagePath) + "/model";
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] models = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            return models.length;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public String findModel(String packagePath) {
        String searchPath = String.valueOf(packagePath) + "/model";
        PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath};
        QueryOptions queryOpts = new QueryOptions();
        queryOpts.setPermission("read");
        queryOpts.setSchemaInfo(false);
        queryOpts.setMaxObjects(BigInteger.valueOf(0L));
        queryOpts.setSkipObjects(BigInteger.valueOf(0L));
        queryOpts.setDataEncoding(EncodingEnum.base64);
        queryOpts.setMaxDataBytes(BigInteger.valueOf(0L));
        queryOpts.setSkipDataBytes(BigInteger.valueOf(0L));
        try {
            BaseClass[] models = this.m_cmService.query(new SearchPathMultipleObject(searchPath), propArray, null, queryOpts);
            if (models.length > 0) {
                return ((Model)models[0]).getSearchPath().getValue();
            }
            return null;
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    public void setModelViewSecurityObjects(ModelView baseObj, List<BaseClass> securityObjects) {
        if (securityObjects == null || securityObjects.isEmpty()) {
            return;
        }
        Policy[] policies = new Policy[securityObjects.size()];
        int i = 0;
        while (i < securityObjects.size()) {
            BaseClass securityObject = securityObjects.get(i);
            Policy newPolicy = new Policy();
            if (!baseObj.getDefaultName().getValue().equals("[].[securityViews].[_Everyone]")) {
                Permission ExecPermission = new Permission();
                ExecPermission.setName("execute");
                ExecPermission.setAccess(AccessEnum.deny);
                Permission WritePermission = new Permission();
                WritePermission.setName("write");
                WritePermission.setAccess(AccessEnum.grant);
                Permission ReadPermission = new Permission();
                ReadPermission.setName("read");
                ReadPermission.setAccess(AccessEnum.grant);
                Permission[] permissions = new Permission[]{ExecPermission, WritePermission, ReadPermission};
                newPolicy.setPermissions(permissions);
            } else {
                Permission[] permissions = new Permission[]{};
                newPolicy.setPermissions(permissions);
            }
            newPolicy.setSecurityObject(securityObject);
            policies[i] = newPolicy;
            ++i;
        }
        PolicyArrayProp policiesArray = new PolicyArrayProp();
        policiesArray.setValue(policies);
        baseObj.setPolicies(policiesArray);
        BaseClass[] modelViews = new BaseClass[]{baseObj};
        try {
            this.m_cmService.update(modelViews, new UpdateOptions());
        }
        catch (RemoteException re) {
            throw FmEngSoapRequest.handleRemoteException(re);
        }
    }

    private class ReleaseInputStream
    extends InputStream {
        private InputStream m_stream;
        private Object m_attach;

        public ReleaseInputStream(InputStream stream, Object attach) {
            this.m_stream = stream;
            this.m_attach = attach;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int rd = -1;
            if (this.m_stream != null) {
                rd = this.m_stream.read(b, off, len);
            }
            if (rd == -1) {
                this.m_attach = null;
                this.m_stream = null;
            }
            return rd;
        }

        public int read() throws IOException {
            int rd = -1;
            if (this.m_stream != null && (rd = this.m_stream.read()) == -1) {
                this.m_stream = null;
                this.m_stream = null;
            }
            return rd;
        }
    }
}

