/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility.soap;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.ibm.cognos.fmeng.fmmd.helpers.DomHelper;
import com.ibm.cognos.fmeng.utility.CAMFaultException;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmPreferences;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.w3c.dom.Element;

public abstract class FmEngSoapRequest {
    public String getDispatcherURL() {
        return FmPreferences.getInstance().getDispatcherEndPoint();
    }

    public static BiBusHeader initializeStub(Stub stub, String passport, String sLocale) {
        FmMDException.ASSERT(sLocale != null, "No locale specified");
        FmMDException.ASSERT(!"".equals(sLocale), "No locale specified");
        BiBusHeader header = new BiBusHeader();
        CAM cam = new CAM();
        CAMPassport campassport = new CAMPassport();
        if (passport != null && passport.length() > 0) {
            campassport.setId(passport);
        }
        cam.setCAMPassport(campassport);
        header.setCAM(cam);
        stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
        stub._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        stub.setTimeout(600000);
        UserPreferenceVar[] userPrefs = new UserPreferenceVar[2];
        userPrefs[0] = new UserPreferenceVar();
        userPrefs[0].setName("contentLocale");
        userPrefs[0].setValue(sLocale);
        userPrefs[1] = new UserPreferenceVar();
        userPrefs[1].setName("productLocale");
        userPrefs[1].setValue(sLocale);
        header.setUserPreferenceVars(userPrefs);
        return header;
    }

    public static RuntimeException handleRemoteException(RemoteException re) {
        AxisFault af;
        Element[] det;
        if (re instanceof AxisFault && (det = (af = (AxisFault)((Object)re)).getFaultDetails()) != null && det.length > 0) {
            org.dom4j.Element root = DomHelper.w3c2dom4j(det[0]);
            org.dom4j.Element msgStr = (org.dom4j.Element)root.selectSingleNode(".//*[local-name()='messageString']");
            if (msgStr != null) {
                ArrayList headers = af.getHeaders();
                if (headers.size() > 0) {
                    Object header = headers.get(0);
                    String headerStr = header.toString();
                    try {
                        Document document = DocumentHelper.parseText((String)headerStr);
                        Node camException = document.selectSingleNode("//*[local-name()='CAM']//*[local-name()='promptInfo']");
                        if (camException != null) {
                            return new CAMFaultException(msgStr.getTextTrim(), re, (org.dom4j.Element)camException);
                        }
                    }
                    catch (DocumentException e) {
                        e.printStackTrace();
                    }
                }
                if (msgStr.getTextTrim().equals("dataSourceConnectionNotFound")) {
                    return new FmMDException("BMT_MD_DATASOURCE_CONNECTION_NOT_FOUND", null, af);
                }
                if (msgStr.getTextTrim().equals("missingEncryptedSignonCredentials")) {
                    return new FmMDException("BMT_MD_MISSING_SIGNON_CRED", null, af);
                }
                if (msgStr.getTextTrim().equals("invalidCredentials")) {
                    return new FmMDException("BMT_MD_INVALID_CRED", null, af);
                }
                if (msgStr.getTextTrim().equals("commandNotFound") || msgStr.getTextTrim().equals("capabilityCheckFailed") || msgStr.getTextTrim().equals("invalidConnectionString") || msgStr.getTextTrim().equals("invalidDriverClass") || msgStr.getTextTrim().equals("insufficentCapabilities") || msgStr.getTextTrim().equals("invalidDataSourceType") || msgStr.getTextTrim().equals("jdbcDriverNotFound") || msgStr.getTextTrim().equals("sqlExecutionError") || msgStr.getTextTrim().equals("java.lang.NullPointerException") || msgStr.getTextTrim().equals("jdbcSQLException")) {
                    Object[] msgParams = new Object[]{msgStr.getTextTrim()};
                    return new FmMDException("BMT_MD_UNKNOWN_RELMD_ERROR", msgParams, af);
                }
                return new RuntimeException(msgStr.getTextTrim(), af);
            }
            Throwable cause = re.getCause();
            if (cause instanceof ConnectException) {
                return new FmMDException("BMT_MD_UNABLE_TO_CONNECT_TO_SERVER", null, re);
            }
        }
        return new RuntimeException(re.getMessage(), re);
    }
}

