/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility.soap;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEncoding;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.MetadataServiceLineageSpecification;
import com.cognos.developer.schemas.bibus._3.MetadataServiceStub;
import com.cognos.developer.schemas.bibus._3.MetadataService_PortType;
import com.cognos.developer.schemas.bibus._3.MetadataService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.mfw4j.utilities.QFException;
import com.ibm.cognos.fmeng.fmmd.helpers.DomHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.soap.CustomMetadataServiceStub;
import com.ibm.cognos.fmeng.utility.soap.FmEngSoapRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.zip.GZIPInputStream;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Stub;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetadataServiceRequest
extends FmEngSoapRequest {
    private MetadataService_PortType m_metadataService;
    private CustomMetadataServiceStub customStub;
    private static final String FMT_MDPROVIDER_REQUEST = "<mdprovider type='transientAction' action='execute'><transaction saved='false' seq='1'><action seq='1' type='%s'><inputparams><param seq='1' type='cclnode'><value><![CDATA[%s]]></value></param><param seq='2' type='integer'><value>%d</value></param><param seq='3' type='integer'><value>%d</value></param><param seq='4' type='integer'><value>%d</value></param></inputparams><domchanges/><result success='t'><outputparams><param seq='1' type='cclnode'><value><output/></value></param></outputparams></result></action></transaction></mdprovider>";

    public MetadataServiceRequest(String passport, String sLocale, String dispatcherGuid) {
        MetadataService_ServiceLocator serviceLocator = new MetadataService_ServiceLocator();
        try {
            this.m_metadataService = serviceLocator.getmetadataService(new URL(this.getDispatcherURL()));
            this.customStub = new CustomMetadataServiceStub(new URL(this.getDispatcherURL()), ((MetadataServiceStub)this.m_metadataService)._getService());
            BiBusHeader biBusHeader = MetadataServiceRequest.initializeStub((Stub)this.customStub, passport, sLocale);
            if (biBusHeader.getTracking() == null && dispatcherGuid != null && !dispatcherGuid.isEmpty()) {
                Tracking tracking = new Tracking();
                ConversationContext context = new ConversationContext();
                context.setNodeID(dispatcherGuid);
                tracking.setConversationContext(context);
                biBusHeader.setTracking(tracking);
            }
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue.getMessage(), mue);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public org.dom4j.Element sendQueryServicesRequest(String queryServicesV5Request, RequestOptions requestOptions) {
        return this.sendQueryServicesRequest(queryServicesV5Request, requestOptions, null);
    }

    public org.dom4j.Element sendQueryServicesRequest(String queryServicesV5Request, RequestOptions requestOptions, FMMDSession session) {
        int nAttempts = 1;
        do {
            try {
                AsynchDetail[] details;
                String strAction = String.format(FMT_MDPROVIDER_REQUEST, requestOptions.mValidateOnly ? "DoQueryServicesRequest4MFWA4J" : "DoQueryServicesRequest", queryServicesV5Request, requestOptions.mMaxRows, requestOptions.mValidateOnly ? 1 : 0, requestOptions.mUseBmeGateway ? 1 : 0);
                MetadataServiceLineageSpecification requestSpec = new MetadataServiceLineageSpecification();
                requestSpec.setValue(new Specification(strAction.toString()));
                ParameterValue[] parameterValues = new ParameterValue[]{};
                Option[] options = new Option[3];
                AsynchOptionInt primaryWait = new AsynchOptionInt();
                primaryWait.setName(AsynchOptionEnum.primaryWaitThreshold);
                primaryWait.setValue(requestOptions.mPrimaryWaitThreshold);
                options[0] = primaryWait;
                AsynchOptionInt secondaryWait = new AsynchOptionInt();
                secondaryWait.setName(AsynchOptionEnum.secondaryWaitThreshold);
                secondaryWait.setValue(requestOptions.mSecondaryWaitThreshold);
                options[1] = secondaryWait;
                AsynchOptionEncoding encoding = new AsynchOptionEncoding();
                encoding.setName(AsynchOptionEnum.attachmentEncoding);
                encoding.setValue(EncodingEnum.MIMECompressed);
                options[2] = encoding;
                AsynchReply reply = this.customStub.runSpecification((AsynchSpecification)requestSpec, parameterValues, options);
                while (reply.getStatus() != AsynchReplyStatusEnum.complete) {
                    if (session != null && session.getProgressCallbackHandler().isCancelRequested()) {
                        this.customStub.cancel(reply.getPrimaryRequest());
                        throw new FmMDException("BMT_MD_CANCELED");
                    }
                    this.customStub.clearHeaders();
                    BiBusHeader header = MFWBiBusHelper.getBiBusHeader((Stub)this.customStub);
                    this.customStub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", header);
                    reply = this.customStub.wait(reply.getPrimaryRequest(), parameterValues, options);
                }
                AsynchDetail[] asynchDetailArray = details = reply.getDetails();
                if (details.length == 0) continue;
                AsynchDetail detail = asynchDetailArray[0];
                InputStream res = this.getResultStream((Stub)this.customStub, detail);
                return this.extractResponse(res);
            }
            catch (AxisFault re) {
                boolean bTimeout;
                String msg = this.handleSoapFault(re.getFaultDetails());
                boolean bNullValueException = msg.contains("java.lang.NullPointerException") && msg.contains("com.cognos.pogo.http.ServerConnection.isConnectionClosed");
                boolean bl = bTimeout = msg.contains("java.lang.IllegalArgumentException") && msg.contains("timeout value is negative");
                if (bNullValueException || bTimeout) {
                    if (nAttempts < requestOptions.mMaxRetries) continue;
                    throw new RuntimeException(msg.toString(), re);
                }
                if ("Metadata Provider Error".equals(re.getFaultString()) || !msg.isEmpty()) {
                    throw new RuntimeException(msg, re);
                }
                throw new RuntimeException(re);
            }
            catch (RemoteException re) {
                throw new RuntimeException(re.getMessage(), re);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } while (nAttempts++ < requestOptions.mMaxRetries);
        return null;
    }

    private String handleSoapFault(Element[] elements) {
        String message = "";
        Element elmFault = elements[0];
        NodeList nodes = elmFault.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getNodeName().equals("ns1:message")) {
                NodeList children = nodes.item(i).getChildNodes();
                int c = 0;
                while (c < children.getLength()) {
                    if (children.item(c).getNodeName().equals("messageString")) {
                        message = children.item(c).getTextContent();
                        break;
                    }
                    ++c;
                }
            }
            if (!message.isEmpty()) break;
            ++i;
        }
        return message;
    }

    private void throwFault803(String datasourceName) {
        String domStr = "<Fault><faultcode>CQE-803</faultcode><dataSource><name value='";
        domStr = String.valueOf(domStr) + datasourceName;
        domStr = String.valueOf(domStr) + "'/></dataSource></Fault>";
        org.dom4j.Element faultElem = DomHelper.stringToDom4j(domStr);
        QFException qfException = new QFException(803);
        qfException.setDOM(faultElem);
        throw qfException;
    }

    private org.dom4j.Element extractResponse(InputStream is) {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(is);
            org.dom4j.Element root = document.getRootElement();
            org.dom4j.Element result = (org.dom4j.Element)root.elements().get(0);
            String bmeResponse = result.getText();
            Document bmeDoc = DocumentHelper.parseText((String)bmeResponse);
            org.dom4j.Element response = (org.dom4j.Element)bmeDoc.selectSingleNode("*[local-name()='response']/*[local-name()='outputparams']/*[local-name()='param']");
            return response;
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    private InputStream getResultStream(Stub port, AsynchDetail detail) {
        try {
            Object[] attachments = port.getAttachments();
            if (attachments.length > 0) {
                AttachmentPart attach = (AttachmentPart)attachments[0];
                InputStream is = attach.getDataHandler().getInputStream();
                String[] contentEncodingHeader = attach.getMimeHeader("Content-Encoding");
                if (contentEncodingHeader != null && contentEncodingHeader.length > 0 && contentEncodingHeader[0].equals("gzip")) {
                    return new GZIPInputStream(is);
                }
                return is;
            }
            String result = new String(((AsynchDetailMIMEAttachment)detail).getData(), "UTF8");
            return new ByteArrayInputStream(result.getBytes("UTF8"));
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        catch (SOAPException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
    }

    public static class RequestOptions {
        public int mMaxRows = 0;
        public boolean mValidateOnly = true;
        public boolean mUseBmeGateway = true;
        public int mPrimaryWaitThreshold = 60000;
        public int mSecondaryWaitThreshold = 60000;
        public int mMaxRetries = 1;
    }
}

