/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility.soap;

import com.cognos.developer.schemas.bibus._3.AsynchDetailReportMetadata;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportOutput;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OutputEncapsulationEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ReportServiceMetadataSpecification;
import com.cognos.developer.schemas.bibus._3.ReportServiceReportSpecification;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.ReportService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionOutputEncapsulation;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.soap.ContentManagerServiceRequest;
import com.ibm.cognos.fmeng.utility.soap.FmEngSoapRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.encoding.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.xml.sax.SAXException;

public abstract class ReportServerRequest2
extends FmEngSoapRequest {
    ReportService_PortType m_reportService = null;

    public ReportServerRequest2(Locale locale, String passport) {
        try {
            ReportService_ServiceLocator serviceLocator = new ReportService_ServiceLocator();
            this.m_reportService = serviceLocator.getreportService(new URL(this.getDispatcherURL()));
            ContentManagerServiceRequest cmRequester = new ContentManagerServiceRequest(locale, passport);
            BiBusHeader header = ReportServerRequest2.initializeStub((Stub)this.m_reportService, passport, locale.toString());
            header.setUserCapabilityCache(cmRequester.queryForUserCapabilityCache());
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue.getMessage(), mue);
        }
    }

    public void runMetadataSpecification(String xmlSpec) {
        ReportServiceMetadataSpecification requestSpec = new ReportServiceMetadataSpecification();
        requestSpec.setValue(new Specification(xmlSpec));
        ParameterValue[] parameterValues = new ParameterValue[]{};
        Option[] options = new Option[1];
        AsynchOptionInt ao = new AsynchOptionInt();
        ao.setName(AsynchOptionEnum.primaryWaitThreshold);
        ao.setValue(-1);
        options[0] = ao;
        Stub stub = (Stub)this.m_reportService;
        try {
            AsynchReply reply = this.m_reportService.runSpecification((AsynchSpecification)requestSpec, parameterValues, options);
            while (reply == null || reply.getStatus() == AsynchReplyStatusEnum.working || reply.getStatus() == AsynchReplyStatusEnum.stillWorking) {
                BiBusHeader header = MFWBiBusHelper.getBiBusHeader((Stub)stub);
                stub.clearHeaders();
                stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                reply = this.m_reportService.wait(reply.getPrimaryRequest(), parameterValues, options);
            }
            AsynchDetailReportMetadata reportMetadata = new AsynchDetailReportMetadata();
            int i = 0;
            while (i < reply.getDetails().length) {
                if (reply.getDetails()[i] instanceof AsynchDetailReportMetadata) {
                    reportMetadata = (AsynchDetailReportMetadata)reply.getDetails()[i];
                    String strResult = reportMetadata.getMetadata().toString();
                    this.extractResponse(strResult);
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (RemoteException e) {
            throw FmEngSoapRequest.handleRemoteException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String runReportSpecification(String xmlSpec) {
        ReportServiceReportSpecification requestSpec = new ReportServiceReportSpecification();
        requestSpec.setValue(new Specification(xmlSpec));
        ParameterValue[] parameterValues = new ParameterValue[]{};
        Option[] runOptions = new Option[5];
        RunOptionBoolean saveOutput = new RunOptionBoolean();
        saveOutput.setName(RunOptionEnum.saveOutput);
        saveOutput.setValue(false);
        runOptions[0] = saveOutput;
        RunOptionStringArray outputFormat = new RunOptionStringArray();
        outputFormat.setName(RunOptionEnum.outputFormat);
        outputFormat.setValue(new String[]{"XML"});
        runOptions[1] = outputFormat;
        RunOptionOutputEncapsulation outputEncapsulation = new RunOptionOutputEncapsulation();
        outputEncapsulation.setName(RunOptionEnum.outputEncapsulation);
        outputEncapsulation.setValue(OutputEncapsulationEnum.none);
        runOptions[2] = outputEncapsulation;
        AsynchOptionInt primaryWait = new AsynchOptionInt();
        primaryWait.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryWait.setValue(0);
        runOptions[3] = primaryWait;
        AsynchOptionInt secondaryWait = new AsynchOptionInt();
        secondaryWait.setName(AsynchOptionEnum.secondaryWaitThreshold);
        secondaryWait.setValue(0);
        runOptions[4] = secondaryWait;
        Stub stub = (Stub)this.m_reportService;
        try {
            AsynchReply reply = this.m_reportService.runSpecification((AsynchSpecification)requestSpec, parameterValues, runOptions);
            while (reply == null || reply.getStatus() == AsynchReplyStatusEnum.working || reply.getStatus() == AsynchReplyStatusEnum.stillWorking) {
                BiBusHeader header = MFWBiBusHelper.getBiBusHeader((Stub)stub);
                stub.clearHeaders();
                stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                reply = this.m_reportService.wait(reply.getPrimaryRequest(), parameterValues, runOptions);
            }
            AsynchDetailReportOutput reportOutput = null;
            int i = 0;
            while (i < reply.getDetails().length) {
                String[] pages;
                if (reply.getDetails()[i] instanceof AsynchDetailReportOutput && (pages = (reportOutput = (AsynchDetailReportOutput)reply.getDetails()[i]).getOutputPages()).length > 0) {
                    return pages[0];
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (RemoteException e) {
            throw FmEngSoapRequest.handleRemoteException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        return "";
    }

    public void runReportSpecificationSaveResultsToFile(FMMDSession session, String xmlSpec, String outFilePath) {
        ReportServiceReportSpecification requestSpec = new ReportServiceReportSpecification();
        requestSpec.setValue(new Specification(xmlSpec));
        ParameterValue[] parameterValues = new ParameterValue[]{};
        Option[] runOptions = new Option[5];
        RunOptionBoolean saveOutput = new RunOptionBoolean();
        saveOutput.setName(RunOptionEnum.saveOutput);
        saveOutput.setValue(false);
        runOptions[0] = saveOutput;
        RunOptionStringArray outputFormat = new RunOptionStringArray();
        outputFormat.setName(RunOptionEnum.outputFormat);
        outputFormat.setValue(new String[]{"CSV"});
        runOptions[1] = outputFormat;
        RunOptionOutputEncapsulation outputEncapsulation = new RunOptionOutputEncapsulation();
        outputEncapsulation.setName(RunOptionEnum.outputEncapsulation);
        outputEncapsulation.setValue(OutputEncapsulationEnum.none);
        runOptions[2] = outputEncapsulation;
        AsynchOptionInt primaryWait = new AsynchOptionInt();
        primaryWait.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryWait.setValue(0);
        runOptions[3] = primaryWait;
        AsynchOptionInt secondaryWait = new AsynchOptionInt();
        secondaryWait.setName(AsynchOptionEnum.secondaryWaitThreshold);
        secondaryWait.setValue(0);
        runOptions[4] = secondaryWait;
        Stub stub = (Stub)this.m_reportService;
        try {
            AsynchReply reply = this.m_reportService.runSpecification((AsynchSpecification)requestSpec, parameterValues, runOptions);
            while (reply == null || reply.getStatus() == AsynchReplyStatusEnum.working || reply.getStatus() == AsynchReplyStatusEnum.stillWorking) {
                BiBusHeader header = MFWBiBusHelper.getBiBusHeader((Stub)stub);
                stub.clearHeaders();
                stub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
                if (session.getProgressCallbackHandler().isCancelRequested()) {
                    this.m_reportService.cancel(reply.getPrimaryRequest());
                    throw new FmMDException("BMT_MD_CANCELED");
                }
                reply = this.m_reportService.wait(reply.getPrimaryRequest(), parameterValues, runOptions);
            }
            AsynchDetailReportOutput reportOutput = null;
            File outFile = new File(outFilePath);
            if (!outFile.exists()) {
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                outFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(outFile);
            int i = 0;
            while (i < reply.getDetails().length) {
                String[] pages;
                if (reply.getDetails()[i] instanceof AsynchDetailReportOutput && (pages = (reportOutput = (AsynchDetailReportOutput)reply.getDetails()[i]).getOutputPages()).length > 0) {
                    Base64.decode((String)pages[0], (OutputStream)fos);
                }
                ++i;
            }
            fos.flush();
            fos.close();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (RemoteException e) {
            throw FmEngSoapRequest.handleRemoteException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Document stringToDom(String xmlSource) {
        Document document;
        try {
            document = DocumentHelper.parseText((String)xmlSource);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return document;
    }

    public abstract void extractResponse(String var1);
}

