/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.utility.sort;

import com.ibm.cognos.fmeng.genmodel.NameType;
import com.ibm.cognos.fmeng.genmodel.ReportObjectType;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFObjectComparison
implements Comparator<FeatureMap.Entry> {
    private SortOrder sortOrder;
    private String locale;
    private Collator collator = null;

    public EMFObjectComparison(Locale locale, String order) {
        this.locale = locale.toString();
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(2);
        this.sortOrder = order != null && order.compareToIgnoreCase("DESC") == 0 ? SortOrder.DESC : SortOrder.ASC;
    }

    @Override
    public int compare(FeatureMap.Entry arg1, FeatureMap.Entry arg2) {
        ReportObjectType measure1 = (ReportObjectType)arg1.getValue();
        EList<NameType> names1 = measure1.getName();
        String value1 = null;
        for (NameType name : names1) {
            if (name.getLocale().compareToIgnoreCase(this.getLocale()) != 0) continue;
            value1 = name.getValue();
            break;
        }
        if (value1 == null) {
            value1 = "";
        }
        ReportObjectType measure2 = (ReportObjectType)arg2.getValue();
        EList<NameType> names2 = measure2.getName();
        String value2 = null;
        for (NameType name : names2) {
            if (name.getLocale().compareToIgnoreCase(this.getLocale()) != 0) continue;
            value2 = name.getValue();
            break;
        }
        if (value2 == null) {
            value2 = "";
        }
        if (this.getSortOrder() == SortOrder.DESC) {
            return this.collator.compare(value1, value2) * -1;
        }
        return this.collator.compare(value1, value2);
    }

    private String getLocale() {
        return this.locale;
    }

    private SortOrder getSortOrder() {
        return this.sortOrder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SortOrder {
        ASC,
        DESC;

    }
}

