/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.keystore;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMCskKs;
import javax.crypto.SecretKey;

public abstract class SecretKeyProvider {
    public abstract SecretKey defaultKey() throws CAMCryptoException;

    public abstract SecretKey key(byte[] var1) throws CAMCryptoException;

    public abstract byte[] keyAlias(SecretKey var1) throws CAMCryptoException;

    public static class CAMCskSecretKeyProvider
    extends SecretKeyProvider {
        @Override
        public SecretKey defaultKey() throws CAMCryptoException {
            return CAMCskKs.getInstance().getCSK();
        }

        @Override
        public SecretKey key(byte[] alias) throws CAMCryptoException {
            return CAMCskKs.getInstance().getCSK(alias);
        }

        @Override
        public byte[] keyAlias(SecretKey key) throws CAMCryptoException {
            return CAMCskKs.getInstance().getCSKAlias(key);
        }
    }
}

