/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.session;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.session.SPSCipher;
import com.ibm.bi.platform.commons.crypto.internal.session.SPSCipherAES;
import com.ibm.bi.platform.commons.crypto.internal.session.SPSCipherAESjava;
import com.ibm.bi.platform.commons.crypto.internal.session.SPSCipherDESwParity;
import com.ibm.bi.platform.commons.crypto.internal.session.Token;
import com.ibm.bi.platform.commons.crypto.internal.utils.IJVMEnvironment;
import com.ibm.bi.platform.commons.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyCryptoSession
extends Token {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemKeyCryptoSession.class);
    private static final int VERSION_1 = 1;
    private static final byte[] PREAMBLE = new byte[]{0, 0, 0, 0, 0, 0, 0};
    private int type;
    private byte[] data;

    private SystemKeyCryptoSession() {
        this.type = -1;
        this.data = null;
    }

    private SystemKeyCryptoSession(int theType, byte[] theData) {
        this.data = theData;
        this.type = theType;
    }

    public static byte[] decryptData(byte[] data, IJVMEnvironment jvmEnv) throws CAMCryptoException {
        SPSCipher spsCipher;
        data = Base64.decodeBase64((byte[])data);
        SystemKeyCryptoSession.outputCipherText(data);
        SystemKeyCryptoSession token = new SystemKeyCryptoSession();
        token.readToken(data);
        SystemKeyCryptoSession.outputKey(token.data);
        switch (token.type) {
            case 4: {
                spsCipher = new SPSCipherAESjava(jvmEnv);
                break;
            }
            case 3: {
                spsCipher = new SPSCipherAES(jvmEnv);
                break;
            }
            case 2: {
                spsCipher = new SPSCipherDESwParity(jvmEnv);
                break;
            }
            default: {
                throw new CAMCryptoException(new Message(CamCryptoMessageKeys.sys_prot_key_decrypt_failure));
            }
        }
        return spsCipher.decryptData(token.data);
    }

    private static void outputKey(byte[] key) {
        byte[] encodedString = Base64.encodeBase64((byte[])key);
        String identifier = new String("Java SystemProtectionSessionTokenV1.decryptData Base64 encoded Raw Key:" + Arrays.toString(encodedString));
        LOGGER.trace(identifier);
    }

    private static void outputCipherText(byte[] cipherText) {
        byte[] encodedString = Base64.encodeBase64((byte[])cipherText);
        String identifier = new String("Java SystemProtectionSessionTokenV1.GetRawKey Base64 encoded Cipher Text:" + Arrays.toString(encodedString));
        LOGGER.trace(identifier);
    }

    public static byte[] encryptData(byte[] data, SPSCipher spsCipher) throws CAMCryptoException {
        byte[] ciphertext = spsCipher.encryptData(data);
        SystemKeyCryptoSession token = new SystemKeyCryptoSession(spsCipher.getType(), ciphertext);
        return token.writeToken();
    }

    @Override
    public void readToken(ByteArrayInputStream in) throws CAMCryptoException {
        byte[] preamble = new byte[PREAMBLE.length];
        int len = in.read(preamble, 0, preamble.length);
        if (len != preamble.length || !Arrays.equals(PREAMBLE, preamble)) {
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.sys_prot_key_decrypt_failure));
        }
        int version = this.readVersion(in);
        if (version != 1) {
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.sys_prot_key_decrypt_failure));
        }
        this.type = this.readInt(in);
        this.data = this.readByteArray(in);
    }

    @Override
    public void writeToken(ByteArrayOutputStream out) throws CAMCryptoException {
        out.write(PREAMBLE, 0, PREAMBLE.length);
        this.writeVersion(out, 1);
        this.writeInt(out, this.type);
        this.writeByteArray(out, this.data);
    }
}

