/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.internal.utils.CAMJcaProvidersConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class JcaFactory {
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();
    public static JcaProvidersConfig jcaProvidersConfig = JcaProvidersConfig.defaultConfig;

    public static <T> T getInstance(Class<T> artifactClass, String algorithm) throws CouldNotGetInstanceException {
        JcaProvidersConfig.ProviderType providerType = jcaProvidersConfig.providerType(artifactClass, algorithm);
        try {
            switch (providerType) {
                case JRE_DEFAULT: {
                    Method getInstance = artifactClass.getDeclaredMethod("getInstance", String.class);
                    return (T)getInstance.invoke(null, algorithm);
                }
                case JRE_EXPLICIT: {
                    Method getInstance = artifactClass.getDeclaredMethod("getInstance", String.class, String.class);
                    return (T)getInstance.invoke(null, algorithm, providerType.jreRegisteredProviderName);
                }
                case BOUNCY_CASTLE: {
                    Method getInstance = artifactClass.getDeclaredMethod("getInstance", String.class, Provider.class);
                    return (T)getInstance.invoke(null, algorithm, BOUNCY_CASTLE_PROVIDER);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException("the given artifact class is not JCA style instantiable");
        }
        catch (InvocationTargetException e) {
            throw new CouldNotGetInstanceException(e.getTargetException());
        }
        throw new CouldNotGetInstanceException(null);
    }

    public static abstract class JcaProvidersConfig {
        public static JcaProvidersConfig defaultConfig = new CAMJcaProvidersConfig();
        private Map<Class, Map<String, ProviderType>> jcaClassToAlgorithmToProviderType = new HashMap<Class, Map<String, ProviderType>>();

        public JcaProvidersConfig() {
            this.config();
        }

        protected abstract void config();

        public ProviderType providerType(Class providerClass, String algorithm) {
            Map<String, ProviderType> algorithmToProviderType = this.jcaClassToAlgorithmToProviderType.get(providerClass);
            ProviderType providerType = null;
            if (algorithmToProviderType != null) {
                providerType = algorithmToProviderType.get(algorithm.toLowerCase());
            }
            if (providerType != null) {
                return providerType;
            }
            return ProviderType.JRE_DEFAULT;
        }

        protected void bind(Class jcaArtifact, String algorithm, ProviderType providerType) {
            Map<String, ProviderType> algorithmToProviderType = this.jcaClassToAlgorithmToProviderType.get(jcaArtifact);
            if (algorithmToProviderType == null) {
                algorithmToProviderType = new HashMap<String, ProviderType>();
            }
            algorithmToProviderType.put(algorithm.toLowerCase(), providerType);
            this.jcaClassToAlgorithmToProviderType.put(jcaArtifact, algorithmToProviderType);
        }

        public static enum ProviderType {
            JRE_DEFAULT,
            JRE_EXPLICIT,
            BOUNCY_CASTLE;

            public String jreRegisteredProviderName;

            public ProviderType withJreRegisteredProviderName(String jreRegisteredProviderName) {
                if (this == JRE_EXPLICIT) {
                    this.jreRegisteredProviderName = jreRegisteredProviderName;
                    return this;
                }
                throw new IllegalArgumentException("provider name can only be specified for JRE_EXPLICIT provider type ");
            }
        }
    }

    public static class CouldNotGetInstanceException
    extends Exception {
        public CouldNotGetInstanceException(Throwable cause) {
            super(cause);
        }
    }
}

