/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rs;

import com.ibm.bi.rs.GETEntityBuilder;
import com.ibm.bi.rs.POSTEntityBuilder;
import com.ibm.bi.rs.PUTEntityBuilder;
import java.io.Closeable;
import java.util.Date;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

public class ResponseBuilderFactory {
    public static Response.ResponseBuilder createGET(Request request, String tag, Date modifiedDate, CacheControl cacheControl, GETEntityBuilder entityBuilder) throws Exception {
        Response.ResponseBuilder builder;
        Date lastModified;
        CacheControl cc;
        EntityTag entityTag = entityBuilder.getEtagFromResource();
        if (entityTag == null && tag != null) {
            entityTag = new EntityTag(tag);
        }
        if ((cc = entityBuilder.getCacheControl()) == null) {
            cc = cacheControl;
        }
        if ((lastModified = entityBuilder.getLastModifiedFromResource()) == null) {
            lastModified = modifiedDate;
        }
        if ((builder = ResponseBuilderFactory.evaluatePreconditions(request, entityTag, lastModified, cc)) == null) {
            builder = Response.ok((Object)entityBuilder.build());
            if (entityTag != null) {
                builder.tag(entityTag);
            }
            if (lastModified != null) {
                builder.lastModified(lastModified);
            }
        } else {
            ResponseBuilderFactory.closeIfPossible(entityBuilder);
        }
        if (cc != null) {
            builder.cacheControl(cc);
        }
        return builder;
    }

    public static Response.ResponseBuilder createPUT(Request request, String tag, Date modifiedDate, PUTEntityBuilder entityBuilder) throws Exception {
        Response.ResponseBuilder builder;
        Date lastModified;
        EntityTag entityTag = entityBuilder.getEtagFromResource();
        if (entityTag == null && tag != null) {
            entityTag = new EntityTag(tag);
        }
        if ((lastModified = entityBuilder.getLastModifiedFromResource()) == null) {
            lastModified = modifiedDate;
        }
        if ((builder = ResponseBuilderFactory.evaluatePreconditions(request, entityTag, lastModified, null)) != null) {
            ResponseBuilderFactory.closeIfPossible(entityBuilder);
            return builder;
        }
        entityBuilder.updateResource();
        entityBuilder.updateEtag();
        entityBuilder.updateLastModified();
        return Response.noContent();
    }

    public static Response.ResponseBuilder createPOST(Request request, String eTag, POSTEntityBuilder entityBuilder) throws Exception {
        entityBuilder.createResource();
        entityBuilder.createEtag();
        entityBuilder.createLastModified();
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.CREATED);
        builder = entityBuilder.wrapResponse(builder);
        return builder;
    }

    public static Response.ResponseBuilder evaluatePreconditions(Request request, EntityTag etag, Date lastModified, CacheControl cc) {
        Response.ResponseBuilder builder = null;
        if (lastModified != null && etag != null) {
            builder = request.evaluatePreconditions(lastModified, etag);
        } else if (etag != null) {
            builder = request.evaluatePreconditions(etag);
        } else if (lastModified != null) {
            builder = request.evaluatePreconditions(lastModified);
        }
        if (builder != null && cc != null) {
            builder.cacheControl(cc);
        }
        return builder;
    }

    private static void closeIfPossible(GETEntityBuilder entityBuilder) {
        if (entityBuilder instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)entityBuilder)));
        }
    }

    private static void closeIfPossible(PUTEntityBuilder entityBuilder) {
        if (entityBuilder instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)entityBuilder)));
        }
    }
}

