/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons;

import java.lang.reflect.Array;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static byte[] concat(byte[] ... arrays) {
        int concatLength = 0;
        for (byte[] array : arrays) {
            concatLength += array.length;
        }
        byte[] concatenation = new byte[concatLength];
        int filledUntilPreviousArray = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, concatenation, filledUntilPreviousArray, array.length);
            filledUntilPreviousArray += array.length;
        }
        return concatenation;
    }

    @SafeVarargs
    public static <T> T[] concat(Class<T> tClass, T[] ... arrays) {
        int concatLength = 0;
        for (T[] array : arrays) {
            concatLength += array.length;
        }
        Object[] concatenation = (Object[])Array.newInstance(tClass, concatLength);
        int filledUntilPreviousArray = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, concatenation, filledUntilPreviousArray, array.length);
            filledUntilPreviousArray += array.length;
        }
        return concatenation;
    }
}

