/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons;

import com.ibm.bi.keymanager.commons.ErrorCode;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class Compression {
    private Compression() {
    }

    public static byte[] gzipCompress(byte[] data) {
        ByteArrayOutputStream compressedData = new ByteArrayOutputStream();
        try (GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)compressedData);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out);
        }
        catch (IOException e) {
            throw ErrorCode.COMPRESSION_ERROR.exception(e, new Object[0]);
        }
        return compressedData.toByteArray();
    }

    public static byte[] gzipDecompress(byte[] data) {
        ByteArrayOutputStream decompressedData = new ByteArrayOutputStream();
        try (GzipCompressorInputStream in = new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(data));){
            IOUtils.copy((InputStream)in, (OutputStream)decompressedData);
        }
        catch (IOException e) {
            throw ErrorCode.COMPRESSION_ERROR.exception(e, new Object[0]);
        }
        return decompressedData.toByteArray();
    }

    public static void zipDirectory(File directory, OutputStream compressionSink, int bufferSize) {
        try {
            List<File> subFiles = Compression.subFiles(directory);
            Compression.writeZipFile(directory, subFiles, compressionSink, bufferSize);
        }
        catch (IOException e) {
            throw ErrorCode.COMPRESSION_ERROR.exception(e, new Object[0]);
        }
    }

    public static void zipDirectory(File directory, OutputStream compressionSink) {
        Compression.zipDirectory(directory, compressionSink, 1000000);
    }

    public static void unzipToDirectory(InputStream decompressionSource, File directory) {
        boolean mkdirResult = false;
        try (ZipInputStream zipInputStream = new ZipInputStream(decompressionSource);){
            if (!directory.exists()) {
                directory.mkdir();
            }
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                String filePath = directory.getCanonicalPath() + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    Compression.extractFile(zipInputStream, filePath, new byte[1000000]);
                } else {
                    File dir = new File(filePath);
                    dir.mkdir();
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw ErrorCode.COMPRESSION_ERROR.exception(e, new Object[0]);
        }
    }

    private static List<File> subFiles(File directory) {
        ArrayList<File> allFiles = new ArrayList<File>();
        Compression.subFiles(directory, allFiles);
        return allFiles;
    }

    private static void subFiles(File dir, List<File> fileList) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                fileList.add(file);
                if (!file.isDirectory()) continue;
                Compression.subFiles(file, fileList);
            }
        }
    }

    private static void writeZipFile(File directoryToZip, List<File> fileList, OutputStream compressionSink, int bufferSize) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(compressionSink);){
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                Compression.addToZip(directoryToZip, file, zipOutputStream, new byte[bufferSize]);
            }
        }
    }

    private static void addToZip(File directoryToZip, File file, ZipOutputStream zipOutputStream, byte[] compressionBuffer) throws IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1);
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zipOutputStream.putNextEntry(zipEntry);
        while ((length = fis.read(compressionBuffer)) >= 0) {
            zipOutputStream.write(compressionBuffer, 0, length);
        }
        zipOutputStream.closeEntry();
        fis.close();
    }

    private static void extractFile(ZipInputStream zipInputStream, String filePath, byte[] buffer) throws IOException {
        File file = new File(filePath);
        file.getParentFile().mkdirs();
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            int read;
            while ((read = zipInputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, read);
            }
        }
    }
}

