/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons;

import com.ibm.bi.keymanager.commons.CommonsException;
import org.slf4j.helpers.MessageFormatter;

public enum ErrorCode {
    COULD_NOT_ENCRYPT_CONTENT(1, "encryption error", Type.INTERNAL_ERROR),
    COULD_NOT_DECRYPT_CONTENT(2, "decryption error", Type.INTERNAL_ERROR),
    HASH_GENERATION_ERROR(3, "hash generation error", Type.INTERNAL_ERROR),
    SECRET_KEY_GENERATION_ERROR(4, "Secret key generation error", Type.INTERNAL_ERROR),
    KEY_PAIR_GENERATION_ERROR(5, "key pair generation error", Type.INTERNAL_ERROR),
    PRIVATE_KEY_GENERATION_ERROR(6, "private key generation error", Type.INTERNAL_ERROR),
    CERTIFICATE_GENERATION_ERROR(7, "certificate generation error", Type.INTERNAL_ERROR),
    SERIALIZATION_ERROR(8, "serialization error", Type.INTERNAL_ERROR),
    RETRY_TIMEOUT_ERROR(9, "retrying timed out without successful outcome", Type.EXTERNAL),
    MAX_RETRY_ERROR(10, "retrying reached max without successful outcome", Type.EXTERNAL),
    COMPRESSION_ERROR(11, "could not compress or decompress data", Type.EXTERNAL),
    CERTIFICATE_SIGNATURE_ERROR(12, "could not sign certificate", Type.EXTERNAL),
    CSR_GENERATION_ERROR(13, "could not generate csr", Type.EXTERNAL),
    PEM_CERT_GENERATION_ERROR(14, "could not generating certificate pem", Type.EXTERNAL),
    COULD_NOT_GET_EXTRACT_COMMON_NAME(15, "could not extract common name from certificate", Type.EXTERNAL),
    COULD_NOT_JOIN_SECRET_PIECES(16, "could not join secret pieces", Type.EXTERNAL),
    COULD_NOT_JOIN_SECRET_PIECES_MIN_UNMET(17, "could not join secret pieces given that we don't have enough pieces", Type.EXTERNAL),
    COULD_NOT_SPLIT_SECRET_INTO_PIECES(18, "could not split secret into pieces", Type.EXTERNAL),
    COULD_NOT_JOIN_SECRET_PIECES_INCOHERENT_PIECES(19, "could not join secret pieces given that they are not derived from same secret", Type.EXTERNAL),
    COULD_NOT_JOIN_SECRET_PIECES_UNDECODABLE_PIECE(20, "could not join secret pieces given that we cannot decode piece {}", Type.EXTERNAL),
    COULD_NOT_MASK_STRING(21, "could not mask string", Type.EXTERNAL),
    COULD_NOT_DECOMPOSE_URI_QUERY(22, "could not decompose URI query into key value pairs", Type.EXTERNAL),
    COULD_NOT_READ_PKCS8_KEY(23, "could not read pkcs8 key", Type.EXTERNAL);

    public final int code;
    public final String msg;
    public final Type type;

    private ErrorCode(int code, String msg, Type type) {
        this.code = code;
        this.msg = msg;
        this.type = type;
    }

    public CommonsException exception(Object ... args) {
        return new CommonsException(this, MessageFormatter.arrayFormat((String)this.msg, (Object[])args).getMessage());
    }

    public CommonsException exception(Throwable cause, Object ... msgArgs) {
        return new CommonsException(this, MessageFormatter.arrayFormat((String)this.msg, (Object[])msgArgs).getMessage(), cause);
    }

    public static enum Type {
        USER_ERROR,
        INTERNAL_ERROR,
        INSUFFICIENT_RESOURCES,
        EXTERNAL;

    }
}

