/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons;

import com.ibm.bi.keymanager.commons.ErrorCode;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaultTolerance {
    private static final Logger LOG = LoggerFactory.getLogger(FaultTolerance.class);

    private FaultTolerance() {
    }

    public static <T> T retryUntilSuccessOrTimeout(Callable<T> supplier, int timeout, TimeUnit timeUnit) {
        try {
            return (T)Unreliables.retryUntilSuccess((int)timeout, (TimeUnit)timeUnit, supplier);
        }
        catch (TimeoutException e) {
            throw ErrorCode.RETRY_TIMEOUT_ERROR.exception(e, new Object[0]);
        }
    }

    public static <T> T retryUntilSuccessOrMaxRetries(Callable<T> supplier, int maxRetries) {
        for (int i = 0; i < maxRetries; ++i) {
            try {
                return supplier.call();
            }
            catch (Exception t) {
                LOG.info("Exception caught during try nb {} ran by thread {}. {}", new Object[]{i, Thread.currentThread().getName(), t});
                if (i != maxRetries - 1) continue;
                throw ErrorCode.MAX_RETRY_ERROR.exception(t, new Object[0]);
            }
        }
        throw ErrorCode.MAX_RETRY_ERROR.exception(new Object[0]);
    }
}

