/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class ImmutableCircleArray<T> {
    private final T[] elts;
    private final AtomicInteger readIndex = new AtomicInteger(-1);

    @SafeVarargs
    public ImmutableCircleArray(T ... elts) {
        this.elts = Arrays.copyOf(elts, elts.length);
    }

    public T next() {
        int i = this.readIndex.incrementAndGet();
        if (i >= this.elts.length) {
            int previous = i;
            this.readIndex.compareAndSet(previous, i %= this.elts.length);
        }
        return this.elts[i];
    }

    public int size() {
        return this.elts.length;
    }
}

