/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.bi.keymanager.commons.ErrorCode;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class SerializationUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Map<Class, Schema> schemas = new ConcurrentHashMap<Class, Schema>();
    private static final LinkedBuffer lb = LinkedBuffer.allocate();
    private static final Object serializeLb = new Object();

    private SerializationUtil() {
    }

    public static <T> byte[] serialize(Class<T> teeClass, T encryptedEntry) {
        Objects.requireNonNull(teeClass);
        Objects.requireNonNull(encryptedEntry);
        try {
            return ProtobufIOUtil.toByteArray(encryptedEntry, (Schema)SerializationUtil.memoizedSchema(teeClass), (LinkedBuffer)LinkedBuffer.allocate());
        }
        catch (Exception e) {
            throw ErrorCode.SERIALIZATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static <T> int serialize(Class<T> teeClass, T encryptedEntry, LinkedBuffer out) {
        Objects.requireNonNull(teeClass);
        Objects.requireNonNull(encryptedEntry);
        try {
            return ProtobufIOUtil.writeTo((LinkedBuffer)out, encryptedEntry, (Schema)SerializationUtil.memoizedSchema(teeClass));
        }
        catch (Exception e) {
            throw ErrorCode.SERIALIZATION_ERROR.exception(e, new Object[0]);
        }
    }

    private static Schema memoizedSchema(Class klass) {
        return schemas.computeIfAbsent(klass, aClass -> RuntimeSchema.getSchema((Class)klass));
    }

    public static <T> T deserialize(Class<T> teeClass, byte[] bytes) {
        Objects.requireNonNull(teeClass);
        Objects.requireNonNull(bytes);
        Schema schema = SerializationUtil.memoizedSchema(teeClass);
        Object tmp = schema.newMessage();
        ProtobufIOUtil.mergeFrom((byte[])bytes, (Object)tmp, (Schema)schema);
        return (T)tmp;
    }

    public static <T> T deserialize(Class<T> teeClass, byte[] bytes, int offset, int length) {
        Objects.requireNonNull(teeClass);
        Objects.requireNonNull(bytes);
        Schema schema = SerializationUtil.memoizedSchema(teeClass);
        Object tmp = schema.newMessage();
        ProtobufIOUtil.mergeFrom((byte[])bytes, (int)offset, (int)length, (Object)tmp, (Schema)schema);
        return (T)tmp;
    }

    public static byte[] serializeToJsonBytes(Object object) {
        try {
            return objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw ErrorCode.SERIALIZATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static <T> T deserializeFromJsonBytes(Class<T> teeClass, byte[] jsonBytes) {
        try {
            return (T)objectMapper.readValue(jsonBytes, teeClass);
        }
        catch (IOException e) {
            throw ErrorCode.SERIALIZATION_ERROR.exception(e, new Object[0]);
        }
    }
}

