/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto;

import com.ibm.bi.keymanager.commons.CommonsException;
import com.ibm.bi.keymanager.commons.ErrorCode;
import com.ibm.bouncycastle.asn1.ASN1Encodable;
import com.ibm.bouncycastle.asn1.ASN1EncodableVector;
import com.ibm.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.ibm.bouncycastle.asn1.DERSequence;
import com.ibm.bouncycastle.asn1.pkcs.Attribute;
import com.ibm.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.ibm.bouncycastle.asn1.x500.RDN;
import com.ibm.bouncycastle.asn1.x500.X500Name;
import com.ibm.bouncycastle.asn1.x500.style.BCStyle;
import com.ibm.bouncycastle.asn1.x500.style.IETFUtils;
import com.ibm.bouncycastle.asn1.x509.BasicConstraints;
import com.ibm.bouncycastle.asn1.x509.Extension;
import com.ibm.bouncycastle.asn1.x509.Extensions;
import com.ibm.bouncycastle.asn1.x509.GeneralName;
import com.ibm.bouncycastle.asn1.x509.GeneralNames;
import com.ibm.bouncycastle.asn1.x509.KeyPurposeId;
import com.ibm.bouncycastle.asn1.x509.KeyUsage;
import com.ibm.bouncycastle.cert.CertIOException;
import com.ibm.bouncycastle.cert.X509CertificateHolder;
import com.ibm.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.ibm.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import com.ibm.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import com.ibm.bouncycastle.jce.provider.BouncyCastleProvider;
import com.ibm.bouncycastle.operator.ContentSigner;
import com.ibm.bouncycastle.operator.OperatorCreationException;
import com.ibm.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.ibm.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.ibm.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import com.ibm.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import com.ibm.bouncycastle.util.io.pem.PemObject;
import com.ibm.bouncycastle.util.io.pem.PemReader;
import com.ibm.bouncycastle.util.io.pem.PemWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificates {
    public static final String PEM_CERTIFICATE_REQUEST_TYPE = "CERTIFICATE REQUEST";
    private static final String PEM_CERTIFICATE_TYPE = "CERTIFICATE";
    private static final Logger LOGGER = LoggerFactory.getLogger(Certificates.class);
    private static final Date certsGenerationDefaultStartDate = new Date();

    private Certificates() {
    }

    public static X509Certificate x509CertificateFromPem(InputStream inputStream) {
        try {
            Objects.requireNonNull(inputStream);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (Exception e) {
            throw ErrorCode.CERTIFICATE_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static X509Certificate[] x509CertificatesFromPem(InputStream inputStream) {
        try {
            Objects.requireNonNull(inputStream);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificates(inputStream).toArray(new X509Certificate[0]);
        }
        catch (Exception e) {
            throw ErrorCode.CERTIFICATE_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static X509Certificate signedCertificate(X509Certificate issuerCert, PrivateKey issuerPrivateKey, byte[] csrPkcs10PemEncoded, String signatureAlgorithm) {
        return Certificates.signedCertificate(issuerCert, issuerPrivateKey, csrPkcs10PemEncoded, signatureAlgorithm, certsGenerationDefaultStartDate);
    }

    public static X509Certificate signedCertificate(X509Certificate issuerCert, PrivateKey issuerPrivateKey, byte[] csrPkcs10PemEncoded, String signatureAlgorithm, Date startDate) {
        try {
            return Certificates.signedCertificate(issuerCert, issuerPrivateKey, csrPkcs10PemEncoded, signatureAlgorithm, startDate, 30, false);
        }
        catch (CommonsException e) {
            LOGGER.error("Exception occurred while generating a signed certificate", (Throwable)e);
            throw ErrorCode.CERTIFICATE_SIGNATURE_ERROR.exception(new Object[0]);
        }
    }

    public static X509Certificate signedCertificate(X509Certificate issuerCert, PrivateKey issuerPrivateKey, byte[] csrPkcs10PemEncoded, String signatureAlgorithm, Date startDate, int daysBeforeItExpires, boolean isSubjectCA) {
        try {
            PemObject pemObject = new PemReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(csrPkcs10PemEncoded), StandardCharsets.UTF_8)).readPemObject();
            JcaPKCS10CertificationRequest parsedCSR = new JcaPKCS10CertificationRequest(pemObject.getContent());
            parsedCSR.setProvider((Provider)new BouncyCastleProvider());
            X500Principal subjectPrincipal = new X500Principal(parsedCSR.getSubject().toASN1Primitive().getEncoded());
            PublicKey subjectPublicKey = parsedCSR.getPublicKey();
            Attribute[] csrExtensionRequest = parsedCSR.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
            X500Principal issuerPrincipal = issuerCert.getSubjectX500Principal();
            return Certificates.signedCertificate(issuerPrincipal, subjectPrincipal, issuerPrivateKey, subjectPublicKey, signatureAlgorithm, startDate, daysBeforeItExpires, isSubjectCA, csrExtensionRequest);
        }
        catch (OperatorCreationException | IOException | InvalidKeyException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.error("Exception occurred while generating a signed certificate", e);
            throw ErrorCode.CERTIFICATE_SIGNATURE_ERROR.exception(new Object[0]);
        }
    }

    public static X509Certificate signedCertificate(X500Principal issuerPrincipal, X500Principal subjectPrincipal, PrivateKey issuerPrivateKey, PublicKey subjectPublicKey, String signatureAlgorithm, Date startDate, int daysBeforeItExpires, boolean isSubjectCA, Attribute[] csrExtensionRequest) throws IOException, NoSuchAlgorithmException, CertificateException, OperatorCreationException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(5, daysBeforeItExpires);
        Date expiryDate = calendar.getTime();
        JcaX509v3CertificateBuilder x509V3CertificateBuilder = new JcaX509v3CertificateBuilder(issuerPrincipal, BigInteger.valueOf(ThreadLocalRandom.current().nextLong(Integer.MAX_VALUE)), startDate, expiryDate, subjectPrincipal, subjectPublicKey);
        x509V3CertificateBuilder = Certificates.withV3Extensions(x509V3CertificateBuilder, subjectPublicKey, isSubjectCA);
        if (csrExtensionRequest != null && csrExtensionRequest.length > 0) {
            x509V3CertificateBuilder = Certificates.withCsrExtensions(x509V3CertificateBuilder, csrExtensionRequest);
        }
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(issuerPrivateKey);
        X509CertificateHolder x509CertificateHolder = x509V3CertificateBuilder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
    }

    private static JcaX509v3CertificateBuilder withV3Extensions(JcaX509v3CertificateBuilder x509V3CertificateBuilder, PublicKey subjectPublicKey, boolean isSubjectCA) throws IOException, NoSuchAlgorithmException {
        x509V3CertificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isSubjectCA));
        x509V3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createSubjectKeyIdentifier(subjectPublicKey));
        KeyUsage usage = new KeyUsage(182);
        x509V3CertificateBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)usage);
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        x509V3CertificateBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
        return x509V3CertificateBuilder;
    }

    private static JcaX509v3CertificateBuilder withCsrExtensions(JcaX509v3CertificateBuilder x509V3CertificateBuilder, Attribute[] attributes) throws CertIOException {
        for (Attribute attribute : attributes) {
            for (ASN1Encodable value : attribute.getAttributeValues()) {
                Extensions extensions = Extensions.getInstance((Object)value);
                for (ASN1ObjectIdentifier extensionOID : extensions.getExtensionOIDs()) {
                    x509V3CertificateBuilder.addExtension(extensions.getExtension(extensionOID));
                }
            }
        }
        return x509V3CertificateBuilder;
    }

    public static byte[] certificateRequestPkcs10PemEncoded(X500Principal subject, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm) {
        return Certificates.certificateRequestPkcs10PemEncoded(subject, null, null, null, privateKey, publicKey, signatureAlgorithm);
    }

    public static byte[] certificateRequestPkcs10PemEncoded(X500Principal subject, String subjectAlternativeNameDnsNames, String subjectAlternativeNameIpAddresses, String subjectAlternativeNameEmailAddresses, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm) {
        try {
            JcaPKCS10CertificationRequestBuilder certificationRequestBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name(subject.getName()), publicKey);
            certificationRequestBuilder = Certificates.withSubjectAlternativeNameExtension(certificationRequestBuilder, subjectAlternativeNameDnsNames, subjectAlternativeNameIpAddresses, subjectAlternativeNameEmailAddresses);
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(privateKey);
            PKCS10CertificationRequest certificationRequest = certificationRequestBuilder.build(signer);
            PemObject pemObject = new PemObject(PEM_CERTIFICATE_REQUEST_TYPE, certificationRequest.getEncoded());
            ByteArrayOutputStream pemBytesSink = new ByteArrayOutputStream();
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)pemBytesSink, StandardCharsets.UTF_8));
            pemWriter.writeObject(() -> pemObject);
            pemWriter.close();
            return pemBytesSink.toByteArray();
        }
        catch (OperatorCreationException | IOException | IllegalArgumentException e) {
            LOGGER.error("Exception occurred while generating a certificate request", e);
            throw ErrorCode.CSR_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    private static JcaPKCS10CertificationRequestBuilder withSubjectAlternativeNameExtension(JcaPKCS10CertificationRequestBuilder certificationRequestBuilder, String subjectAlternativeNameDnsNames, String subjectAlternativeNameIpAddresses, String subjectAlternativeNameEmailAddresses) throws IOException {
        ArrayList sanExtensions = new ArrayList();
        if (subjectAlternativeNameIpAddresses != null) {
            Arrays.stream(subjectAlternativeNameIpAddresses.split(" ")).forEach(sanIpAddress -> {
                try {
                    sanExtensions.add(new GeneralName(7, sanIpAddress));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException((String)sanIpAddress, e);
                }
            });
        }
        if (subjectAlternativeNameDnsNames != null) {
            Arrays.stream(subjectAlternativeNameDnsNames.split(" ")).forEach(sanDnsName -> sanExtensions.add(new GeneralName(2, sanDnsName)));
        }
        if (subjectAlternativeNameEmailAddresses != null) {
            Arrays.stream(subjectAlternativeNameEmailAddresses.split(" ")).forEach(sanEmailAddress -> sanExtensions.add(new GeneralName(1, sanEmailAddress)));
        }
        if (sanExtensions.size() > 0) {
            Extension sanExtension = new Extension(Extension.subjectAlternativeName, false, new GeneralNames(sanExtensions.toArray(new GeneralName[0])).getEncoded());
            certificationRequestBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)new Extensions(sanExtension));
        }
        return certificationRequestBuilder;
    }

    public static byte[] pemEncodedCertificateContent(Certificate certificate) {
        try {
            PemObject pemObject = new PemObject(PEM_CERTIFICATE_TYPE, certificate.getEncoded());
            ByteArrayOutputStream pemBytesSink = new ByteArrayOutputStream();
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)pemBytesSink, StandardCharsets.UTF_8));
            pemWriter.writeObject(() -> pemObject);
            pemWriter.close();
            return pemBytesSink.toByteArray();
        }
        catch (IOException | CertificateEncodingException e) {
            LOGGER.error("Exception occurred while generating pem encoded certificate", (Throwable)e);
            throw ErrorCode.PEM_CERT_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static X509Certificate selfSignedCertificate(X500Principal principal, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm, int daysBeforeItExpires) {
        return Certificates.selfSignedCertificate(principal, privateKey, publicKey, signatureAlgorithm, certsGenerationDefaultStartDate, daysBeforeItExpires);
    }

    public static X509Certificate selfSignedCertificate(X500Principal principal, PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm, Date startDate, int daysBeforeItExpires) {
        try {
            return Certificates.signedCertificate(principal, principal, privateKey, publicKey, signatureAlgorithm, startDate, daysBeforeItExpires, true, null);
        }
        catch (OperatorCreationException | IOException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.error("Exception occurred while generating a self-signed certificate", e);
            throw ErrorCode.CERTIFICATE_SIGNATURE_ERROR.exception(e, new Object[0]);
        }
    }

    public static String commonNameFromCertificate(X509Certificate certificate) {
        RDN[] rdns = new X500Name(certificate.getIssuerDN().getName()).getRDNs(BCStyle.CN);
        if (rdns != null && rdns.length > 0) {
            return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
        }
        return null;
    }

    public static String[] sanDnsNames(X509Certificate certificate) {
        return Certificates.sanParameters(certificate, 2);
    }

    private static String[] sanParameters(X509Certificate certificate, int sanId) {
        try {
            return (String[])certificate.getSubjectAlternativeNames().stream().filter(sanEntry -> sanEntry != null && sanEntry.size() >= 2 && sanEntry.get(0).equals(sanId)).map(san -> san.get(1)).toArray(String[]::new);
        }
        catch (CertificateParsingException e) {
            return null;
        }
    }

    public static String[] sanIpAddresses(X509Certificate certificate) {
        return Certificates.sanParameters(certificate, 7);
    }

    public static boolean isIssuer(X509Certificate certificate, X509Certificate maybeIssuerCertificate) {
        boolean isSignedByIssuer = false;
        try {
            certificate.verify(maybeIssuerCertificate.getPublicKey());
            isSignedByIssuer = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return certificate.getIssuerDN().equals(maybeIssuerCertificate.getSubjectDN()) && isSignedByIssuer;
    }
}

