/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto;

import com.ibm.bi.keymanager.commons.ErrorCode;
import com.ibm.bi.keymanager.commons.crypto.Keys;
import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class Ciphers {
    private Ciphers() {
    }

    public static byte[] aesEncrypt(String password, byte[] data) {
        Objects.requireNonNull(password);
        Objects.requireNonNull(data);
        SecretKey aesSecret = Keys.aesSecretKeyFromPassword(password);
        byte[] encryptedData = Ciphers.aesEncrypt(aesSecret, data);
        Keys.maskSecretKey(aesSecret);
        return encryptedData;
    }

    public static byte[] aesEncrypt(SecretKey secretKey, byte[] data) {
        Objects.requireNonNull(secretKey);
        Objects.requireNonNull(data);
        try {
            int ivSize = 16;
            byte[] iv = new byte[ivSize];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            aesCipher.init(1, (Key)secretKey, ivParameterSpec);
            byte[] encrypted = aesCipher.doFinal(data);
            byte[] encryptedIvAndText = new byte[ivSize + encrypted.length];
            System.arraycopy(iv, 0, encryptedIvAndText, 0, ivSize);
            System.arraycopy(encrypted, 0, encryptedIvAndText, ivSize, encrypted.length);
            return encryptedIvAndText;
        }
        catch (Exception e) {
            throw ErrorCode.COULD_NOT_ENCRYPT_CONTENT.exception(e, new Object[0]);
        }
    }

    public static byte[] aesDecrypt(String password, byte[] data) {
        Objects.requireNonNull(password);
        Objects.requireNonNull(data);
        SecretKey aesSecret = Keys.aesSecretKeyFromPassword(password);
        return Ciphers.aesDecrypt(aesSecret, data);
    }

    public static byte[] aesDecrypt(SecretKey secretKey, byte[] encryptedData) {
        Objects.requireNonNull(secretKey);
        Objects.requireNonNull(encryptedData);
        try {
            int ivSize = 16;
            byte[] iv = new byte[ivSize];
            System.arraycopy(encryptedData, 0, iv, 0, iv.length);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            int encryptedSize = encryptedData.length - ivSize;
            byte[] encryptedBytes = new byte[encryptedSize];
            System.arraycopy(encryptedData, ivSize, encryptedBytes, 0, encryptedSize);
            Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipherDecrypt.init(2, (Key)secretKey, ivParameterSpec);
            return cipherDecrypt.doFinal(encryptedBytes);
        }
        catch (Exception e) {
            throw ErrorCode.COULD_NOT_DECRYPT_CONTENT.exception(e, new Object[0]);
        }
    }

    public static byte[] asymmetricDecrypt(String keyPairAlgorithm, KeyPair keyPair, byte[] encryptedData) {
        Objects.requireNonNull(keyPairAlgorithm);
        Objects.requireNonNull(keyPair);
        Objects.requireNonNull(encryptedData);
        try {
            Cipher asymmetricCipher = Cipher.getInstance(Ciphers.cipher(keyPairAlgorithm));
            asymmetricCipher.init(2, keyPair.getPrivate());
            return asymmetricCipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            throw ErrorCode.COULD_NOT_DECRYPT_CONTENT.exception(e, new Object[0]);
        }
    }

    public static byte[] asymmetricEncrypt(String keyPairAlgorithm, KeyPair keyPair, byte[] data) {
        Objects.requireNonNull(keyPairAlgorithm);
        Objects.requireNonNull(keyPair);
        Objects.requireNonNull(data);
        try {
            Cipher asymmetricCipher = Cipher.getInstance(Ciphers.cipher(keyPairAlgorithm));
            asymmetricCipher.init(1, keyPair.getPublic());
            return asymmetricCipher.doFinal(data);
        }
        catch (Exception e) {
            throw ErrorCode.COULD_NOT_ENCRYPT_CONTENT.exception(e, new Object[0]);
        }
    }

    private static String cipher(String keyPairAlgorithm) {
        if (keyPairAlgorithm.equals("EC")) {
            return "ECIES";
        }
        return keyPairAlgorithm;
    }
}

