/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto;

import com.ibm.bi.keymanager.commons.ErrorCode;
import com.ibm.bouncycastle.crypto.generators.OpenBSDBCrypt;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Objects;

public class Hashes {
    private Hashes() {
    }

    public static byte[] sha256(byte[] data) {
        Objects.requireNonNull(data);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return messageDigest.digest(data);
        }
        catch (Exception e) {
            throw ErrorCode.HASH_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static String generateBcrypt(char[] password) {
        Objects.requireNonNull(password);
        return OpenBSDBCrypt.generate((char[])password, (byte[])new SecureRandom().generateSeed(16), (int)4);
    }

    public static boolean verifyBcrypt(String bcryptString, char[] password) {
        Objects.requireNonNull(bcryptString);
        Objects.requireNonNull(password);
        return OpenBSDBCrypt.checkPassword((String)bcryptString, (char[])password);
    }
}

