/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto;

import com.google.common.collect.ImmutableMap;
import com.ibm.bi.keymanager.commons.crypto.CryptoParams;
import java.util.Map;
import java.util.Objects;

public class NISTCryptoParams
extends CryptoParams {
    private static final Map<String, String> cryptoAlgorithmToSignatureAlgorithm = ImmutableMap.builder().put((Object)"RSA", (Object)"SHA256withRSA").put((Object)"EC", (Object)"SHA256withECDSA").build();
    private static final Map<String, Integer> cryptoAlgorithmToMinKeyLength = ImmutableMap.builder().put((Object)"RSA", (Object)2048).put((Object)"EC", (Object)224).build();
    private static final Map<String, Integer> cryptoAlgorithmToKeyLength = ImmutableMap.builder().put((Object)"RSA", (Object)2048).put((Object)"EC", (Object)256).build();

    @Override
    public String signatureAlgorithm(String cryptoAlgorithm) {
        String signatureAlgorithm = cryptoAlgorithmToSignatureAlgorithm.get(cryptoAlgorithm.toUpperCase());
        Objects.requireNonNull(signatureAlgorithm, "signature algorithm not found for crypto algorithm");
        return signatureAlgorithm;
    }

    @Override
    public int minKeyLength(String cryptoAlgorithm) {
        Integer minKeyLength = cryptoAlgorithmToMinKeyLength.get(cryptoAlgorithm.toUpperCase());
        Objects.requireNonNull(minKeyLength, "min key length not found for crypto algorithm");
        return minKeyLength;
    }

    @Override
    public int keyLength(String cryptoAlgorithm) {
        Integer keyLength = cryptoAlgorithmToKeyLength.get(cryptoAlgorithm.toUpperCase());
        Objects.requireNonNull(keyLength, "key length not found for crypto algorithm");
        return keyLength;
    }
}

