/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto;

import com.ibm.bi.keymanager.commons.crypto.Hashes;
import com.ibm.bi.keymanager.commons.crypto.Keys;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;

public class SecretKeysCache {
    private static final Map<byte[], Entry> cache = new ConcurrentHashMap<byte[], Entry>();

    private SecretKeysCache() {
    }

    public static byte[] cache(SecretKey secretKey, int cachetimeout, TimeUnit unit) {
        byte[] keyId = Hashes.sha256(secretKey.getEncoded());
        cache.put(keyId, new Entry(secretKey, System.currentTimeMillis() + unit.toMillis(cachetimeout)));
        return keyId;
    }

    public static SecretKey get(byte[] secretKeyId) {
        Entry entry = cache.get(secretKeyId);
        if (entry != null && !entry.expired) {
            return entry.secretKey;
        }
        return null;
    }

    static {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable passwordsCacheCleaner = () -> cache.forEach((key, skEntry) -> {
            if (!skEntry.expired && System.currentTimeMillis() >= skEntry.expiresAtMillis) {
                skEntry.expired = true;
                Keys.maskSecretKey(skEntry.secretKey);
            }
        });
        scheduler.scheduleAtFixedRate(passwordsCacheCleaner, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private static class Entry {
        public final SecretKey secretKey;
        public volatile long expiresAtMillis;
        public volatile boolean expired;

        private Entry(SecretKey secretKey, long expiresAtMillis) {
            this.secretKey = secretKey;
            this.expiresAtMillis = expiresAtMillis;
        }
    }
}

