/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto;

import com.codahale.shamir.Scheme;
import com.ibm.bi.keymanager.commons.ErrorCode;
import com.ibm.bi.keymanager.commons.crypto.Hashes;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SecretSharing {
    private final Scheme scheme;
    private final int minJoinPieces;

    public SecretSharing(int totalPieces, int minJoinPieces) {
        this.minJoinPieces = minJoinPieces;
        this.scheme = new Scheme(new SecureRandom(), totalPieces, minJoinPieces);
    }

    public String[] splitSecretUsingShamir(String secret) {
        try {
            byte[] secretBytes = secret.getBytes(StandardCharsets.UTF_8);
            String integrity = Base64.getEncoder().encodeToString(Hashes.sha256(secretBytes)).substring(0, 32);
            Map pieces = this.scheme.split(secretBytes);
            return (String[])pieces.entrySet().stream().map(entry -> this.encodeShamirPiece(integrity, (Integer)entry.getKey(), (byte[])entry.getValue())).toArray(String[]::new);
        }
        catch (Exception t) {
            throw ErrorCode.COULD_NOT_SPLIT_SECRET_INTO_PIECES.exception(t, new Object[0]);
        }
    }

    private String encodeShamirPiece(String integrityToken, Integer rank, byte[] value) {
        return integrityToken + "#" + rank + "#" + Base64.getEncoder().encodeToString(value);
    }

    public String joinSecretUsingShamir(String[] pieces) {
        List distinctPieces = Arrays.stream(pieces).distinct().collect(Collectors.toList());
        if (distinctPieces.size() >= this.minJoinPieces) {
            try {
                HashMap<Integer, byte[]> pieceRankToValue = new HashMap<Integer, byte[]>();
                String lastIntegrityToken = null;
                for (String currentPiece : distinctPieces) {
                    String[] pieceParts = currentPiece.split("#");
                    if (pieceParts.length != 3) {
                        throw ErrorCode.COULD_NOT_JOIN_SECRET_PIECES_UNDECODABLE_PIECE.exception(currentPiece);
                    }
                    String integrityToken = pieceParts[0];
                    if (lastIntegrityToken != null && !integrityToken.equals(lastIntegrityToken)) {
                        throw ErrorCode.COULD_NOT_JOIN_SECRET_PIECES_INCOHERENT_PIECES.exception(new Object[0]);
                    }
                    lastIntegrityToken = integrityToken;
                    pieceRankToValue.put(Integer.parseInt(pieceParts[1]), Base64.getDecoder().decode(pieceParts[2]));
                }
                if (pieceRankToValue.size() >= this.minJoinPieces) {
                    return new String(this.scheme.join(pieceRankToValue), StandardCharsets.UTF_8);
                }
                throw ErrorCode.COULD_NOT_JOIN_SECRET_PIECES_MIN_UNMET.exception(new Object[0]);
            }
            catch (Exception t) {
                throw ErrorCode.COULD_NOT_JOIN_SECRET_PIECES.exception(t, new Object[0]);
            }
        }
        throw ErrorCode.COULD_NOT_JOIN_SECRET_PIECES_MIN_UNMET.exception(new Object[0]);
    }
}

