/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto.passwords;

import com.ibm.bi.keymanager.commons.BinaryUtil;
import com.ibm.bi.keymanager.commons.crypto.passwords.PasswordBasedSealingEngine;
import com.ibm.bi.keymanager.commons.crypto.passwords.Util;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Supplier;

public class MaskedPasswordSealingEngine
extends PasswordBasedSealingEngine {
    public static final byte MASK = -11;
    private final Supplier<String> maskedPasswordSupplier;
    private volatile boolean isEngineUsed;

    public MaskedPasswordSealingEngine(String maskedPassword) {
        this(() -> maskedPassword);
    }

    public MaskedPasswordSealingEngine(Supplier<String> maskedPasswordSupplier) {
        this(maskedPasswordSupplier, null);
    }

    public MaskedPasswordSealingEngine(Supplier<String> maskedPasswordSupplier, String verificationBcrypt) {
        super(verificationBcrypt);
        this.maskedPasswordSupplier = maskedPasswordSupplier;
    }

    public static String unmaskSealingPassword(String maskedPassword) {
        return new String(BinaryUtil.xor(Base64.getDecoder().decode(maskedPassword), (byte)-11), StandardCharsets.UTF_8);
    }

    public static String maskSealingPassword(String unmaskedPassword) {
        return Base64.getEncoder().encodeToString(BinaryUtil.xor(unmaskedPassword.getBytes(StandardCharsets.UTF_8), (byte)-11));
    }

    @Override
    public String unseal(String sealedString) {
        if (!this.isEngineUsed) {
            String clearPassword = MaskedPasswordSealingEngine.unmaskSealingPassword(this.maskedPasswordSupplier.get());
            if (this.verificationBcrypt != null) {
                this.verifySecretIntegrity(clearPassword);
            }
            String unsealedStr = new String(this.decrypt(clearPassword, Base64.getDecoder().decode(sealedString)), StandardCharsets.UTF_8);
            Util.maskStringContent(clearPassword);
            Util.maskStringContent(this.maskedPasswordSupplier.get());
            this.isEngineUsed = true;
            return unsealedStr;
        }
        throw new UnsupportedOperationException("Engine has already been used, create a new instance to perform your operation");
    }

    @Override
    public String seal(String unsealedString) {
        if (!this.isEngineUsed) {
            String clearPassword = MaskedPasswordSealingEngine.unmaskSealingPassword(this.maskedPasswordSupplier.get());
            if (this.verificationBcrypt != null) {
                this.verifySecretIntegrity(clearPassword);
            }
            String sealedStr = Base64.getEncoder().encodeToString(this.encrypt(clearPassword, unsealedString.getBytes(StandardCharsets.UTF_8)));
            Util.maskStringContent(clearPassword);
            Util.maskStringContent(this.maskedPasswordSupplier.get());
            this.isEngineUsed = true;
            return sealedStr;
        }
        throw new UnsupportedOperationException("Engine has already been used, create a new instance to perform your operation");
    }
}

