/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto.passwords;

import com.google.common.base.Preconditions;
import com.ibm.bi.keymanager.commons.crypto.Ciphers;
import com.ibm.bi.keymanager.commons.crypto.Hashes;
import com.ibm.bi.keymanager.commons.crypto.passwords.SealingEngine;
import com.ibm.bi.keymanager.commons.crypto.passwords.Util;

public abstract class PasswordBasedSealingEngine
implements SealingEngine {
    protected final String verificationBcrypt;

    public PasswordBasedSealingEngine(String verificationBcrypt) {
        this.verificationBcrypt = verificationBcrypt;
    }

    protected byte[] decrypt(String password, byte[] encryptedData) {
        return Ciphers.aesDecrypt(password, encryptedData);
    }

    protected byte[] encrypt(String password, byte[] clearData) {
        return Ciphers.aesEncrypt(password, clearData);
    }

    protected void verifySecretIntegrity(String secret) {
        char[] secretAsChars = secret.toCharArray();
        try {
            Preconditions.checkState((boolean)Hashes.verifyBcrypt(this.verificationBcrypt, secretAsChars), (Object)"Recovered master password doesn't correspond to the provided verification bcrypt hash");
        }
        finally {
            Util.maskCharArrayContent(secretAsChars);
        }
    }
}

