/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto.passwords;

import com.ibm.bi.keymanager.commons.crypto.passwords.PasswordResource;
import com.ibm.bi.keymanager.commons.crypto.passwords.SealingEngine;
import com.ibm.bi.keymanager.commons.crypto.passwords.Util;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PasswordsSealing {
    private static final Map<String, PasswordCache> cache = new ConcurrentHashMap<String, PasswordCache>();

    private PasswordsSealing() {
    }

    public static String seal(String unsealedPassword, SealingEngine sealingEngine) {
        Objects.requireNonNull(unsealedPassword);
        Objects.requireNonNull(sealingEngine);
        return sealingEngine.seal(unsealedPassword);
    }

    public static String unseal(String sealedPassword, int cacheLifetime, TimeUnit unit, SealingEngine sealingEngine) {
        try {
            return PasswordsSealing.passwordCache(sealedPassword, cacheLifetime, unit, sealingEngine).password();
        }
        catch (IllegalStateException e) {
            return PasswordsSealing.passwordCache(sealedPassword, cacheLifetime, unit, sealingEngine).password();
        }
    }

    public static PasswordResource unsealToPasswordResource(String sealedPassword, int cacheLifetime, TimeUnit unit, SealingEngine sealingEngine) {
        try {
            return new PasswordResource(PasswordsSealing.passwordCache(sealedPassword, cacheLifetime, unit, sealingEngine).password());
        }
        catch (IllegalStateException e) {
            return new PasswordResource(PasswordsSealing.passwordCache(sealedPassword, cacheLifetime, unit, sealingEngine).password());
        }
    }

    private static PasswordCache passwordCache(String sealedPassword, int cacheLifetime, TimeUnit unit, SealingEngine sealingEngine) {
        Objects.requireNonNull(sealedPassword);
        Objects.requireNonNull(unit);
        Objects.requireNonNull(sealingEngine);
        PasswordCache passwordCache = cache.get(sealedPassword);
        if (passwordCache == null || passwordCache.expired()) {
            String unsealed = sealingEngine.unseal(sealedPassword);
            passwordCache = new PasswordCache(unsealed, System.currentTimeMillis() + unit.toMillis(cacheLifetime));
            cache.put(sealedPassword, passwordCache);
        }
        return passwordCache;
    }

    public static char[] unsealToCharArray(String sealedPassword, int cacheLifetime, TimeUnit unit, SealingEngine sealingEngine) {
        try {
            return PasswordsSealing.passwordCache(sealedPassword, cacheLifetime, unit, sealingEngine).passwordAsCharArray();
        }
        catch (IllegalStateException e) {
            return PasswordsSealing.passwordCache(sealedPassword, cacheLifetime, unit, sealingEngine).passwordAsCharArray();
        }
    }

    static {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable passwordsCacheCleaner = () -> cache.forEach((key, passwordCache) -> passwordCache.tryToCheckExpiration());
        scheduler.scheduleAtFixedRate(passwordsCacheCleaner, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    static class PasswordCache {
        final String password;
        private final long expiresAtMillis;
        private final Lock passwordReadLock = new ReentrantLock();
        private volatile boolean expired;

        private PasswordCache(String password, long expiresAtMillis) {
            this.password = password;
            this.expiresAtMillis = expiresAtMillis;
        }

        public boolean expired() {
            this.passwordReadLock.lock();
            try {
                if (!this.expired && System.currentTimeMillis() >= this.expiresAtMillis) {
                    Util.maskStringContent(this.password);
                    this.expired = true;
                }
                boolean bl = this.expired;
                return bl;
            }
            finally {
                this.passwordReadLock.unlock();
            }
        }

        public void tryToCheckExpiration() {
            if (this.passwordReadLock.tryLock()) {
                try {
                    if (!this.expired && System.currentTimeMillis() >= this.expiresAtMillis) {
                        Util.maskStringContent(this.password);
                        this.expired = true;
                    }
                }
                finally {
                    this.passwordReadLock.unlock();
                }
            }
        }

        public String password() {
            this.passwordReadLock.lock();
            try {
                if (!this.expired) {
                    String string = new String(this.password.toCharArray());
                    return string;
                }
                throw new IllegalStateException("password expired right before copying");
            }
            finally {
                this.passwordReadLock.unlock();
            }
        }

        public char[] passwordAsCharArray() {
            this.passwordReadLock.lock();
            try {
                if (!this.expired) {
                    char[] cArray = this.password.toCharArray();
                    return cArray;
                }
                throw new IllegalStateException("password expired right before copying");
            }
            finally {
                this.passwordReadLock.unlock();
            }
        }
    }
}

