/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto.passwords;

import com.google.common.base.Preconditions;
import com.ibm.bi.keymanager.commons.crypto.Ciphers;
import com.ibm.bi.keymanager.commons.crypto.Hashes;
import com.ibm.bi.keymanager.commons.crypto.SecretSharing;
import com.ibm.bi.keymanager.commons.crypto.passwords.MaskedPasswordSealingEngine;
import com.ibm.bi.keymanager.commons.crypto.passwords.PasswordsToolCli;
import com.ibm.bi.keymanager.commons.crypto.passwords.Util;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class PasswordsTool {
    public static final String PASSWORDS_MISMATCH_ERROR_MSG = "The password and its confirmation are different";

    public static void main(String[] args) {
        try {
            PasswordsToolCli.Command command = PasswordsToolCli.Command.fromArgs(args);
            switch (command) {
                case SPLIT_PASSWORD: {
                    PasswordsTool.executeSplitPassword(command);
                    break;
                }
                case MASK_PASSWORD: {
                    PasswordsTool.executeMaskPassword(command);
                    break;
                }
                case SEAL_PASSWORD: {
                    PasswordsTool.executeSealPassword(command);
                    break;
                }
                case BCRYPT_PASSWORD: {
                    PasswordsTool.executeBcryptPassword(command);
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("parse")) {
                PasswordsToolCli.printHelp();
            }
            PasswordsToolCli.printlnInfo("error: " + e.getMessage());
        }
    }

    private static void executeBcryptPassword(PasswordsToolCli.Command command) throws Exception {
        String passwordToBcryptConfirmation;
        String outFile = command.optionValue(PasswordsToolCli.CmdOption.OUT_RESULT_FILE);
        String passwordToBcrypt = PasswordsToolCli.askForSecretInfo("Enter the password to hash using BCrypt");
        if (!passwordToBcrypt.equals(passwordToBcryptConfirmation = PasswordsToolCli.askForSecretInfo("Confirm the password to hash"))) {
            throw new RuntimeException(PASSWORDS_MISMATCH_ERROR_MSG);
        }
        Objects.requireNonNull(outFile, "Output file should be given");
        Objects.requireNonNull(passwordToBcrypt, "Password to bcrypt should be given");
        char[] password = passwordToBcrypt.toCharArray();
        String hashedPassword = Hashes.generateBcrypt(password);
        Util.maskStringContent(passwordToBcrypt);
        Util.maskStringContent(passwordToBcryptConfirmation);
        Util.maskCharArrayContent(password);
        FileUtils.writeStringToFile((File)new File(outFile), (String)hashedPassword, (Charset)StandardCharsets.UTF_8);
    }

    private static void executeMaskPassword(PasswordsToolCli.Command command) throws Exception {
        String passwordToMaskConfirmation;
        String outFile = command.optionValue(PasswordsToolCli.CmdOption.OUT_RESULT_FILE);
        String passwordToMask = PasswordsToolCli.askForSecretInfo("Enter the password to mask");
        if (!passwordToMask.equals(passwordToMaskConfirmation = PasswordsToolCli.askForSecretInfo("Confirm the password to mask"))) {
            throw new RuntimeException(PASSWORDS_MISMATCH_ERROR_MSG);
        }
        Objects.requireNonNull(outFile);
        Objects.requireNonNull(passwordToMask);
        String maskedPassword = MaskedPasswordSealingEngine.maskSealingPassword(passwordToMaskConfirmation);
        Util.maskStringContent(passwordToMask);
        Util.maskStringContent(passwordToMaskConfirmation);
        FileUtils.writeStringToFile((File)new File(outFile), (String)maskedPassword, (Charset)StandardCharsets.UTF_8);
    }

    private static void executeSealPassword(PasswordsToolCli.Command command) throws Exception {
        String sealingPasswordConfirmation;
        String passwordToSealConfirmation;
        String outFile = command.optionValue(PasswordsToolCli.CmdOption.OUT_RESULT_FILE);
        String passwordToSeal = PasswordsToolCli.askForSecretInfo("Enter the password to seal");
        if (!passwordToSeal.equals(passwordToSealConfirmation = PasswordsToolCli.askForSecretInfo("Confirm the password to seal"))) {
            throw new RuntimeException(PASSWORDS_MISMATCH_ERROR_MSG);
        }
        String sealingPassword = PasswordsToolCli.askForSecretInfo("Enter the sealing password");
        if (!sealingPassword.equals(sealingPasswordConfirmation = PasswordsToolCli.askForSecretInfo("Confirm the sealing password"))) {
            throw new RuntimeException(PASSWORDS_MISMATCH_ERROR_MSG);
        }
        Objects.requireNonNull(outFile, "output file should be given");
        Objects.requireNonNull(sealingPassword, "password to seal should be given");
        String sealedPassword = PasswordsTool.sealPassword(passwordToSeal, sealingPassword);
        Util.maskStringContent(passwordToSeal);
        Util.maskStringContent(passwordToSealConfirmation);
        Util.maskStringContent(sealingPassword);
        Util.maskStringContent(sealingPasswordConfirmation);
        FileUtils.writeStringToFile((File)new File(outFile), (String)sealedPassword, (Charset)StandardCharsets.UTF_8);
    }

    private static String sealPassword(String passwordToSeal, String sealingPassword) {
        return Base64.getEncoder().encodeToString(Ciphers.aesEncrypt(sealingPassword, passwordToSeal.getBytes(StandardCharsets.UTF_8)));
    }

    private static void executeSplitPassword(PasswordsToolCli.Command command) throws Exception {
        String passwordToSplitConfirmation;
        int totalPieces = Integer.parseInt(command.optionValue(PasswordsToolCli.CmdOption.SPLIT_TOTAL));
        int requiredPieces = Integer.parseInt(command.optionValue(PasswordsToolCli.CmdOption.SPLIT_REQUIRED));
        String outFile = command.optionValue(PasswordsToolCli.CmdOption.OUT_RESULT_FILE);
        String passwordToSplit = PasswordsToolCli.askForSecretInfo("Enter the password to split");
        if (!passwordToSplit.equals(passwordToSplitConfirmation = PasswordsToolCli.askForSecretInfo("Confirm the password to split"))) {
            throw new RuntimeException(PASSWORDS_MISMATCH_ERROR_MSG);
        }
        Objects.requireNonNull(outFile);
        Objects.requireNonNull(passwordToSplit);
        Preconditions.checkArgument((totalPieces > 0 ? 1 : 0) != 0, (Object)"Total pieces should be a strictly positive number");
        Preconditions.checkArgument((requiredPieces > 0 ? 1 : 0) != 0, (Object)"Required pieces should be a strictly positive number");
        Preconditions.checkArgument((totalPieces > requiredPieces ? 1 : 0) != 0, (Object)"Total pieces should be bigger than required pieces");
        CharSequence[] shamirPieces = new SecretSharing(totalPieces, requiredPieces).splitSecretUsingShamir(passwordToSplit);
        Util.maskStringContent(passwordToSplit);
        Util.maskStringContent(passwordToSplitConfirmation);
        FileUtils.writeStringToFile((File)new File(outFile), (String)String.join((CharSequence)"\n", shamirPieces), (Charset)StandardCharsets.UTF_8);
    }
}

