/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto.passwords;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class PasswordsToolCli {
    private static final HelpFormatter FORMATTER = new HelpFormatter();
    public static PrintStream cliOut = System.out;
    public static InputStream cliIn = System.in;
    private static String helpText;

    private PasswordsToolCli() {
    }

    private static CmdOption[] cmdOptionsOfGroup(CmdOptionGroup group) {
        return (CmdOption[])Arrays.stream(CmdOption.values()).filter(cmdOption -> cmdOption.group.equals((Object)group)).toArray(CmdOption[]::new);
    }

    private static Map<Option, Integer> buildOptionsGroupRank() {
        HashMap<Option, Integer> map = new HashMap<Option, Integer>();
        for (CmdOption cmdOption : CmdOption.values()) {
            map.put(cmdOption.option, cmdOption.group.rank);
        }
        return map;
    }

    private static String optionsGroupText(String header, Options options) {
        StringBuilder stringBuilder = new StringBuilder().append(header).append("\n");
        StringWriter stringWriter = new StringWriter();
        FORMATTER.printOptions(new PrintWriter(stringWriter), 74, options, 1, 3);
        stringBuilder.append(stringWriter.toString());
        return stringBuilder.toString();
    }

    private static Options toApacheOptions(CmdOption ... cmdOptions) {
        Options options = new Options();
        for (CmdOption cmdOption : cmdOptions) {
            options.addOption(cmdOption.option);
        }
        return options;
    }

    private static String commandUsageText(String header, Options options) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(header).append("\n");
        StringWriter stringWriter = new StringWriter();
        FORMATTER.printUsage(new PrintWriter(stringWriter), 74, "PasswordsTool.(bat|sh)", options);
        stringBuilder.append(stringWriter.toString());
        return stringBuilder.toString();
    }

    public static String askForSecretInfo(String question) {
        cliOut.println(question);
        String secret = "";
        ConsoleEraser consoleEraser = new ConsoleEraser();
        BufferedReader in = new BufferedReader(new InputStreamReader(cliIn, StandardCharsets.UTF_8));
        consoleEraser.start();
        try {
            secret = in.readLine();
        }
        catch (IOException e) {
            cliOut.println("Error trying to read your secret!");
            System.exit(1);
        }
        consoleEraser.halt();
        cliOut.print("\b");
        return secret;
    }

    public static void printlnInfo(String info) {
        cliOut.println(info);
    }

    public static void printHelp() {
        cliOut.print(helpText);
    }

    static {
        CmdOption[] operationsOptsGroup = PasswordsToolCli.cmdOptionsOfGroup(CmdOptionGroup.OPERATION);
        CmdOption[] infoFlagsOptsGroup = PasswordsToolCli.cmdOptionsOfGroup(CmdOptionGroup.INFO_FLAG);
        Map<Option, Integer> optionGroupRank = PasswordsToolCli.buildOptionsGroupRank();
        FORMATTER.setOptionComparator(Comparator.comparingInt(o -> (Integer)optionGroupRank.get(o)));
        StringBuilder helpTextBuilder = new StringBuilder();
        helpTextBuilder.append("PASSWORDS TOOL HELP");
        helpTextBuilder.append("\n\n");
        helpTextBuilder.append(PasswordsToolCli.optionsGroupText("OPERATIONS", PasswordsToolCli.toApacheOptions(operationsOptsGroup)));
        helpTextBuilder.append("\n");
        helpTextBuilder.append(PasswordsToolCli.optionsGroupText("OPTIONS", PasswordsToolCli.toApacheOptions(infoFlagsOptsGroup)));
        helpTextBuilder.append("\n");
        helpTextBuilder.append("USAGE");
        helpTextBuilder.append("\n\n");
        String commandsUsageText = Arrays.stream(Command.values()).map(command -> PasswordsToolCli.commandUsageText(((Command)command).description, ((Command)command).options)).collect(Collectors.joining("\n"));
        helpTextBuilder.append(commandsUsageText);
        helpText = helpTextBuilder.toString();
    }

    private static class ConsoleEraser
    extends Thread {
        private boolean running = true;

        private ConsoleEraser() {
        }

        @Override
        public void run() {
            while (this.running) {
                cliOut.print("\b");
                try {
                    ConsoleEraser.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public synchronized void halt() {
            this.running = false;
        }
    }

    public static enum Command {
        SPLIT_PASSWORD("Split a password into pieces using the Shamir algorithm", CmdOption.SPLIT.asRequired(), CmdOption.SPLIT_TOTAL.asRequired(), CmdOption.SPLIT_REQUIRED.asRequired(), CmdOption.OUT_RESULT_FILE.asRequired()),
        MASK_PASSWORD("Mask a password", CmdOption.MASK.asRequired(), CmdOption.OUT_RESULT_FILE.asRequired()),
        SEAL_PASSWORD("Seal a password using another password", CmdOption.SEAL.asRequired(), CmdOption.OUT_RESULT_FILE.asRequired()),
        BCRYPT_PASSWORD("Generate a password hash according to the BCrypt algorithm", CmdOption.BCRYPT.asRequired(), CmdOption.OUT_RESULT_FILE.asRequired());

        private final Options options;
        private final String description;
        private CommandLine commandLine;

        private Command(String description, CmdOption ... partialOptions) {
            this.description = description;
            this.options = new Options();
            for (CmdOption cmdOption : partialOptions) {
                this.options.addOption(cmdOption.option);
            }
        }

        public static Command fromArgs(String[] args) {
            BasicParser commandLineParser = new BasicParser();
            return Arrays.stream(Command.values()).map(arg_0 -> Command.lambda$fromArgs$0((CommandLineParser)commandLineParser, args, arg_0)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException("Could not parse command"));
        }

        public String optionValue(CmdOption cmdOption) {
            return this.commandLine.getOptionValue(cmdOption.option.getOpt());
        }

        private static /* synthetic */ Command lambda$fromArgs$0(CommandLineParser commandLineParser, String[] args, Command command) {
            try {
                command.commandLine = commandLineParser.parse(command.options, args);
                return command;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    public static enum CmdOption {
        SPLIT("split", "split a password into pieces using the Shamir algorithm", CmdOptionGroup.OPERATION),
        MASK("mask", "mask a password", CmdOptionGroup.OPERATION),
        SEAL("seal", "seal a password", CmdOptionGroup.OPERATION),
        BCRYPT("bcrypt", "generate password bcrypt hash", CmdOptionGroup.OPERATION),
        OUT_RESULT_FILE("out", "path/to/out/file", "The out file where the command result is going to be written", CmdOptionGroup.INFO_FLAG),
        SPLIT_TOTAL("t", "totalNumberOfShamirPieces", "Total number of pieces generated by the Shamir split", CmdOptionGroup.INFO_FLAG),
        SPLIT_REQUIRED("r", "requiredNumberOfShamirPieces", "Number of Shamir pieces required to recover a split password", CmdOptionGroup.INFO_FLAG);

        public final Option option;
        public final CmdOptionGroup group;

        private CmdOption(String shortName, String description, CmdOptionGroup group) {
            this.option = new Option(shortName, false, description);
            this.group = group;
        }

        private CmdOption(String shortName, String argName, String description, CmdOptionGroup group) {
            this.option = new Option(shortName, true, description);
            this.option.setArgName(argName);
            this.group = group;
        }

        public CmdOption asRequired() {
            this.option.setRequired(true);
            return this;
        }

        public CmdOption asNotRequired() {
            this.option.setRequired(false);
            return this;
        }
    }

    public static enum CmdOptionGroup {
        OPERATION(1),
        INFO_FLAG(2);

        public final int rank;

        private CmdOptionGroup(int rank) {
            this.rank = rank;
        }
    }
}

