/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.keymanager.commons.crypto.passwords;

import com.ibm.bi.keymanager.commons.crypto.SecretSharing;
import com.ibm.bi.keymanager.commons.crypto.passwords.PasswordBasedSealingEngine;
import com.ibm.bi.keymanager.commons.crypto.passwords.Util;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Supplier;

public class ShamirSealingEngine
extends PasswordBasedSealingEngine {
    private final Supplier<String[]> piecesSupplier;
    private final SecretSharing secretSharing;
    private volatile boolean isEngineUsed;

    public ShamirSealingEngine(int totalPieces, int minJoinPieces, String ... pieces) {
        this(totalPieces, minJoinPieces, () -> pieces);
    }

    public ShamirSealingEngine(int totalPieces, int minJoinPieces, Supplier<String[]> piecesSupplier) {
        this(totalPieces, minJoinPieces, piecesSupplier, null);
    }

    public ShamirSealingEngine(int totalPieces, int minJoinPieces, Supplier<String[]> piecesSupplier, String verificationBcrypt) {
        super(verificationBcrypt);
        this.piecesSupplier = piecesSupplier;
        this.secretSharing = new SecretSharing(totalPieces, minJoinPieces);
    }

    @Override
    public String unseal(String sealedString) {
        if (!this.isEngineUsed) {
            String secret = this.secretSharing.joinSecretUsingShamir(this.piecesSupplier.get());
            if (this.verificationBcrypt != null) {
                this.verifySecretIntegrity(secret);
            }
            String unsealed = new String(this.decrypt(secret, Base64.getDecoder().decode(sealedString)), StandardCharsets.UTF_8);
            Util.maskStringContent(secret);
            this.maskPieces();
            this.isEngineUsed = true;
            return unsealed;
        }
        throw new UnsupportedOperationException("Engine has already been used, create a new instance to perform your operation");
    }

    private void maskPieces() {
        for (String piece : this.piecesSupplier.get()) {
            Util.maskStringContent(piece);
        }
    }

    @Override
    public String seal(String unsealedString) {
        if (!this.isEngineUsed) {
            String secret = this.secretSharing.joinSecretUsingShamir(this.piecesSupplier.get());
            if (this.verificationBcrypt != null) {
                this.verifySecretIntegrity(secret);
            }
            String sealed = Base64.getEncoder().encodeToString(this.encrypt(secret, unsealedString.getBytes(StandardCharsets.UTF_8)));
            Util.maskStringContent(secret);
            this.maskPieces();
            this.isEngineUsed = true;
            return sealed;
        }
        throw new UnsupportedOperationException("Engine has already been used, create a new instance to perform your operation");
    }
}

