/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CopyOnWriteArrayList
implements List,
Cloneable,
Serializable {
    protected transient Object[] array_;

    protected synchronized Object[] array() {
        return this.array_;
    }

    public CopyOnWriteArrayList() {
        this.array_ = new Object[0];
    }

    public CopyOnWriteArrayList(Collection collection) {
        this.array_ = new Object[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.array_[n++] = iterator.next();
        }
    }

    public CopyOnWriteArrayList(Object[] objectArray) {
        this.copyIn(objectArray, 0, objectArray.length);
    }

    public synchronized void copyIn(Object[] objectArray, int n, int n2) {
        this.array_ = new Object[n2];
        System.arraycopy(objectArray, n, this.array_, 0, n2);
    }

    @Override
    public int size() {
        return this.array().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        int n;
        Object[] objectArray = this.array();
        return CopyOnWriteArrayList.indexOf(object, objectArray, n = objectArray.length) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n);
    }

    protected static int indexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(Object object, int n) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n);
    }

    protected static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n - 1; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object, int n) {
        Object[] objectArray = this.array();
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] objectArray = this.array();
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.array_ = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, copyOnWriteArrayList.array_, 0, objectArray.length);
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = this.array();
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = this.array();
        if (objectArray.length < objectArray2.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray2.length);
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        if (objectArray.length > objectArray2.length) {
            objectArray[objectArray2.length] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        Object[] objectArray = this.array();
        this.rangeCheck(n, objectArray.length);
        return objectArray[n];
    }

    public synchronized Object set(int n, Object object) {
        boolean bl;
        int n2 = this.array_.length;
        this.rangeCheck(n, n2);
        Object object2 = this.array_[n];
        boolean bl2 = bl = object2 == object || object != null && object.equals(object2);
        if (!bl) {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.array_, 0, objectArray, 0, n2);
            objectArray[n] = object;
            this.array_ = objectArray;
        }
        return object2;
    }

    @Override
    public synchronized boolean add(Object object) {
        int n = this.array_.length;
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        objectArray[n] = object;
        this.array_ = objectArray;
        return true;
    }

    public synchronized void add(int n, Object object) {
        int n2 = this.array_.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        objectArray[n] = object;
        System.arraycopy(this.array_, n, objectArray, n + 1, n2 - n);
        this.array_ = objectArray;
    }

    public synchronized Object remove(int n) {
        int n2 = this.array_.length;
        this.rangeCheck(n, n2);
        Object object = this.array_[n];
        Object[] objectArray = new Object[n2 - 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        int n3 = n2 - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.array_, n + 1, objectArray, n, n3);
        }
        this.array_ = objectArray;
        return object;
    }

    @Override
    public synchronized boolean remove(Object object) {
        int n = this.array_.length;
        if (n == 0) {
            return false;
        }
        int n2 = n - 1;
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            if (object == this.array_[i] || object != null && object.equals(this.array_[i])) {
                for (int j = i + 1; j < n; ++j) {
                    objectArray[j - 1] = this.array_[j];
                }
                this.array_ = objectArray;
                return true;
            }
            objectArray[i] = this.array_[i];
        }
        if (object == this.array_[n2] || object != null && object.equals(this.array_[n2])) {
            this.array_ = objectArray;
            return true;
        }
        return false;
    }

    public synchronized void removeRange(int n, int n2) {
        int n3 = this.array_.length;
        if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        int n5 = n3 - (n2 - n);
        Object[] objectArray = new Object[n5];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        System.arraycopy(this.array_, n2, objectArray, n, n4);
        this.array_ = objectArray;
    }

    public synchronized boolean addIfAbsent(Object object) {
        int n = this.array_.length;
        Object[] objectArray = new Object[n + 1];
        for (int i = 0; i < n; ++i) {
            if (object == this.array_[i] || object != null && object.equals(this.array_[i])) {
                return false;
            }
            objectArray[i] = this.array_[i];
        }
        objectArray[n] = object;
        this.array_ = objectArray;
        return true;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(iterator.next(), objectArray, n) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection collection) {
        Object[] objectArray = this.array_;
        int n = objectArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (collection.contains(object)) continue;
            objectArray2[n2++] = object;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray3 = new Object[n2];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
        this.array_ = objectArray3;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection collection) {
        Object[] objectArray = this.array_;
        int n = objectArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (!collection.contains(object)) continue;
            objectArray2[n2++] = object;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray3 = new Object[n2];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
        this.array_ = objectArray3;
        return true;
    }

    public synchronized int addAllAbsent(Collection collection) {
        Object object2;
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        Object[] objectArray = this.array_;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n];
        int n3 = 0;
        for (Object object2 : collection) {
            if (CopyOnWriteArrayList.indexOf(object2, objectArray, n2) >= 0 || CopyOnWriteArrayList.indexOf(object2, objectArray2, n3) >= 0) continue;
            objectArray2[n3++] = object2;
        }
        if (n3 == 0) {
            return 0;
        }
        object2 = new Object[n2 + n3];
        System.arraycopy(objectArray, 0, object2, 0, n2);
        System.arraycopy(objectArray2, 0, object2, n2, n3);
        this.array_ = object2;
        return n3;
    }

    @Override
    public synchronized void clear() {
        this.array_ = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        int n2 = this.array_.length;
        Object[] objectArray = new Object[n2 + n];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[n2++] = iterator.next();
        }
        this.array_ = objectArray;
        return true;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        int n2 = this.array_.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n2 + n3];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        int n4 = n2 - n;
        if (n4 > 0) {
            System.arraycopy(this.array_, n, objectArray, n + n3, n4);
        }
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n3; ++i) {
            objectArray[n++] = iterator.next();
        }
        this.array_ = objectArray;
        return true;
    }

    protected void rangeCheck(int n, int n2) {
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.array();
        objectOutputStream.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            objectOutputStream.writeObject(objectArray[i]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        this.array_ = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("[");
        int n = this.size() - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e != null ? e.equals(e2) : e2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    @Override
    public Iterator iterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator(int n) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(this.array(), n);
    }

    public synchronized List subList(int n, int n2) {
        int n3 = this.array_.length;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n, n2);
    }

    protected static class COWSubList
    extends AbstractList {
        protected final CopyOnWriteArrayList l;
        protected final int offset;
        protected int size;
        protected Object[] expectedArray;

        protected COWSubList(CopyOnWriteArrayList copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.array();
            this.offset = n;
            this.size = n2 - n;
        }

        protected void checkForComodification() {
            if (this.l.array_ != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        protected void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object set(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object2 = this.l.set(n + this.offset, object);
                this.expectedArray = this.l.array_;
                return object2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                return this.l.get(n + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, object);
                this.expectedArray = this.l.array_;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object remove(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object = this.l.remove(n + this.offset);
                this.expectedArray = this.l.array_;
                --this.size;
                return object;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator listIterator(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                return new COWSubListIterator(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List subList(int n, int n2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, n + this.offset, n2 + this.offset);
            }
        }

        protected class COWSubListIterator
        implements ListIterator {
            protected final ListIterator i;
            protected final int index;

            protected COWSubListIterator(int n) {
                this.index = n;
                this.i = COWSubList.this.l.listIterator(n + COWSubList.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < COWSubList.this.size;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - COWSubList.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - COWSubList.this.offset;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class COWIterator
    implements ListIterator {
        protected final Object[] array;
        protected int cursor;

        protected COWIterator(Object[] objectArray, int n) {
            this.array = objectArray;
            this.cursor = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

