/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.auth;

import com.cognos.CAM_AAA.authentication.INamespaceTrustedSignonProvider;
import com.cognos.CAM_AAA.authentication.ITrustedSignonRequest;
import com.cognos.CAM_AAA.authentication.SystemRecoverableException;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.CAM_AAA.authentication.UserRecoverableException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cps.bseries.auth.Namespace;
import com.cognos.cps.bseries.common.logging.ServiceLoggerImpl;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.common.utils.HmacSHA;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CPSTrustedSignon
extends Namespace
implements INamespaceTrustedSignonProvider {
    private static final org.dom4j.Namespace CRN_NAMESPACE = new org.dom4j.Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    private static final String CPS_CONFIG = "CPS";
    private static final String REMOTE_USER = "REMOTE_USER";
    private static final String AUTH_TYPE = "AUTH_TYPE";
    private static final String NTLM_TYPE = "NTLM";
    private static final String AAA_CONFIG = "AAA";
    private static final String PROPERTY_AUTH_COOKIE_NAME = "auth_cookie_name";
    private static final String DEFAULT_AUTH_COOKIE_NAME = "cps_auth_user";
    private static final String PROPERTY_MAX_SECONDS_APART = "max_seconds_apart";
    private static final String DEFAULT_SECONDS_APART = "3600";
    private static final String PROPERTY_NAMESPACE_ID = "namespace_id";
    private static final String PROPERTY_SECRET = "cps_auth_secret";
    private String m_namespaceId;
    private String m_authCookieName;
    private String m_secret;
    private int m_maxSecondsApart;
    private boolean m_bIsNTLM = true;
    ServiceLogger logger;

    public CPSTrustedSignon() {
        this.initialize();
    }

    private void initialize() {
        block30: {
            this.logger = new ServiceLoggerImpl(this.getClass());
            try {
                block29: {
                    ICCLConfiguration cfg;
                    block28: {
                        cfg = CCLConfigurationFactory.getInstance();
                        try {
                            cfg.init();
                        }
                        catch (CCLConfigurationException e) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error("initialization error", (Throwable)e);
                            }
                            return;
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Loading Config - " + new Date());
                        }
                        try {
                            String xml = cfg.getValue(CPS_CONFIG, true);
                            if (xml != null) {
                                Document document = null;
                                SAXReader reader = new SAXReader();
                                StringReader r1 = new StringReader(xml);
                                document = reader.read((Reader)new BufferedReader(r1));
                                Element rootElem = document.getRootElement();
                                rootElem.add(CRN_NAMESPACE);
                                this.m_namespaceId = rootElem.valueOf("./crn:parameter[@name='cps_namespaceID']/crn:value");
                                this.m_secret = rootElem.valueOf("./crn:parameter[@name='cps_sharedSecret']/crn:value");
                            }
                        }
                        catch (CCLConfigurationException e1) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error("initialization error", (Throwable)e1);
                            }
                        }
                        catch (DocumentException e) {
                            if (!this.logger.isErrorEnabled()) break block28;
                            this.logger.error("initialization error", (Throwable)e);
                        }
                    }
                    this.m_authCookieName = DEFAULT_AUTH_COOKIE_NAME;
                    this.m_maxSecondsApart = Integer.parseInt(DEFAULT_SECONDS_APART);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Config [" + this.m_namespaceId + ", " + this.m_authCookieName + ", " + (this.m_secret != null && this.m_secret.length() > 0 ? "*********" : this.m_secret) + ", " + this.m_maxSecondsApart + "]");
                    }
                    try {
                        InputStream in = CPSTrustedSignon.class.getClassLoader().getResourceAsStream("cps_trustedsignon.properties");
                        if (in != null) {
                            String propSecret;
                            String propNnamespaceId;
                            String propMaxSecondsApart;
                            Properties properties = new Properties();
                            properties.load(in);
                            String propAuthCookieName = properties.getProperty(PROPERTY_AUTH_COOKIE_NAME, "");
                            if (propAuthCookieName.length() > 0) {
                                this.m_authCookieName = propAuthCookieName;
                            }
                            if ((propMaxSecondsApart = properties.getProperty(PROPERTY_MAX_SECONDS_APART, "")).length() > 0) {
                                this.m_maxSecondsApart = Integer.parseInt(propMaxSecondsApart);
                            }
                            if ((propNnamespaceId = properties.getProperty(PROPERTY_NAMESPACE_ID, "")).length() > 0) {
                                this.m_namespaceId = propNnamespaceId;
                            }
                            if ((propSecret = properties.getProperty(PROPERTY_SECRET, "")).length() > 0) {
                                this.m_secret = propSecret;
                            }
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("cps_trustedsignon.properties file exists - overriding config settings");
                                this.logger.debug("Config [" + this.m_namespaceId + ", " + this.m_authCookieName + ", " + (this.m_secret != null && this.m_secret.length() > 0 ? "*********" : this.m_secret) + ", " + this.m_maxSecondsApart + "]");
                            }
                        }
                    }
                    catch (IOException e) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("initialization error", (Throwable)e);
                        }
                        return;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Checking for NTLM namespace");
                    }
                    try {
                        String aaa_xml = cfg.getValue(AAA_CONFIG, true);
                        Document document2 = null;
                        SAXReader reader2 = new SAXReader();
                        StringReader r2 = new StringReader(aaa_xml);
                        document2 = reader2.read((Reader)new BufferedReader(r2));
                        Element rootElem2 = document2.getRootElement();
                        rootElem2.add(CRN_NAMESPACE);
                        String authType = rootElem2.valueOf("./crn:instances[@name='authProvider']/crn:instance[./crn:parameter[@name='id']/crn:value='" + this.m_namespaceId + "']/@class");
                        if (authType == null) {
                            authType = NTLM_TYPE;
                        }
                        this.m_bIsNTLM = NTLM_TYPE.equals(authType);
                    }
                    catch (CCLConfigurationException e1) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("initialization error", (Throwable)e1);
                        }
                    }
                    catch (DocumentException e) {
                        if (!this.logger.isErrorEnabled()) break block29;
                        this.logger.error("initialization error", (Throwable)e);
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("isNTLM = " + this.m_bIsNTLM);
                }
            }
            catch (Throwable t) {
                if (!this.logger.isErrorEnabled()) break block30;
                this.logger.error("initialization error", t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processLogonRequest(ITrustedSignonRequest theRequest) throws UserRecoverableException, SystemRecoverableException, UnrecoverableException {
        String cookieValue;
        block18: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Starting Request - " + new Date());
            }
            if (this.m_namespaceId == null || this.m_namespaceId.length() == 0) {
                if (!this.logger.isErrorEnabled()) throw new UnrecoverableException(MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.configerror.caption"), MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.configerror.error"));
                this.logger.error("null namespace config error");
                throw new UnrecoverableException(MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.configerror.caption"), MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.configerror.error"));
            }
            String[] cookieArray = theRequest.getCookieValue(this.m_authCookieName);
            cookieValue = null;
            if (cookieArray != null && cookieArray.length > 0) {
                cookieValue = cookieArray[0];
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("value for cookie '" + this.m_authCookieName + "' is: " + cookieValue);
            }
            if (cookieValue == null) throw new UserRecoverableException(MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.missingcredential.caption"), MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.missingcredential.error"));
            try {
                cookieValue = EncodingUtils.urlDecode((String)cookieValue, (String)"UTF-8");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Decoded value for cookie '" + this.m_authCookieName + "' is: " + cookieValue);
                }
            }
            catch (NullPointerException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Error while decoding the value '" + cookieValue + "' for cookie '" + this.m_authCookieName + "'", (Throwable)e);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!this.logger.isErrorEnabled()) break block18;
                this.logger.error("Error while decoding the value '" + cookieValue + "' for cookie '" + this.m_authCookieName + "'", (Throwable)e);
            }
        }
        theRequest.setNamespaceID(this.m_namespaceId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Namespace is set to: " + this.m_namespaceId);
        }
        if (this.m_secret == null || this.m_secret.length() == 0) {
            if (cookieValue.length() == 0) return;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("shared secret is not set.");
            }
            this.setRemoteUser(cookieValue, theRequest);
            return;
        } else {
            StringTokenizer tokens;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("shared secret is set.");
            }
            if ((tokens = new StringTokenizer(cookieValue, " ")).countTokens() <= 2) throw new UnrecoverableException(MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.failed.caption"), MessagesManager.getInstance().getMessage(theRequest.getProductLocale(), "cps.sso.failed.error"));
            StringBuffer userBuf = new StringBuffer(tokens.nextToken());
            while (tokens.countTokens() > 2) {
                userBuf.append(" ").append(tokens.nextToken());
            }
            String auth_user = userBuf.toString();
            String time_stamp = tokens.nextToken();
            String hmac = tokens.nextToken();
            String hmac_text = new StringBuffer(auth_user).append(" ").append(time_stamp).toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Tokens:" + auth_user + ", " + time_stamp + ", " + hmac + ", " + hmac_text);
            }
            if (this.isHMACValid(hmac_text, hmac) && this.isTimeStampValid(time_stamp)) {
                this.setRemoteUser(auth_user, theRequest);
                return;
            } else {
                if (!this.logger.isDebugEnabled()) return;
                this.logger.debug("Remote user was not set. Invalid timestamp or HMAC");
            }
        }
    }

    private void setRemoteUser(String auth_user, ITrustedSignonRequest theRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Enter : setRemoteUser(), user=" + auth_user);
        }
        theRequest.removeTrustedEnvVar(REMOTE_USER);
        theRequest.addTrustedEnvVar(REMOTE_USER, auth_user);
        theRequest.removeEnvVar(REMOTE_USER);
        theRequest.addEnvVar(REMOTE_USER, auth_user);
        if (this.m_bIsNTLM) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("target namespace is NTLM");
            }
            theRequest.removeEnvVar(AUTH_TYPE);
            theRequest.addEnvVar(AUTH_TYPE, NTLM_TYPE);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Exit : setRemoteUser()");
        }
    }

    private boolean isTimeStampValid(String time_stamp) {
        long now;
        long ts = Long.parseLong(time_stamp);
        return Math.abs(ts - (now = new Date().getTime())) <= (long)(this.m_maxSecondsApart * 1000);
    }

    private boolean isHMACValid(String hmac_text, String hmac) {
        try {
            String validHmac = HmacSHA.create((String)hmac_text, (String)this.m_secret);
            return validHmac.equals(hmac);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return false;
    }
}

