/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.auth;

import com.cognos.CAM_AAA.authentication.INamespaceTrustedSignonProvider;
import com.cognos.CAM_AAA.authentication.ITrustedSignonRequest;
import com.cognos.CAM_AAA.authentication.SystemRecoverableException;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.CAM_AAA.authentication.UserRecoverableException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cps.bseries.auth.Namespace;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CPSTrustedSignon_up
extends Namespace
implements INamespaceTrustedSignonProvider {
    private static final org.dom4j.Namespace CRN_NAMESPACE = new org.dom4j.Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    private static final String CPS_CONFIG = "CPS";
    private static final String USER_PRINCIPAL = "USER_PRINCIPAL";
    private static final String REMOTE_USER = "REMOTE_USER";
    private static final String AUTH_TYPE = "AUTH_TYPE";
    private static final String NTLM_TYPE = "NTLM";
    private static final String AAA_CONFIG = "AAA";
    private String m_namespaceId;
    private boolean m_bIsNTLM = true;

    public CPSTrustedSignon_up() {
        this.initialize();
    }

    private void initialize() {
        PrintStream pw = System.err;
        try {
            ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
            try {
                cfg.init();
            }
            catch (CCLConfigurationException e) {
                e.printStackTrace(pw);
                return;
            }
            try {
                String xml = cfg.getValue(CPS_CONFIG, true);
                if (xml != null) {
                    Document document = null;
                    SAXReader reader = new SAXReader();
                    StringReader r1 = new StringReader(xml);
                    document = reader.read((Reader)new BufferedReader(r1));
                    Element rootElem = document.getRootElement();
                    rootElem.add(CRN_NAMESPACE);
                    this.m_namespaceId = rootElem.valueOf("./crn:parameter[@name='cps_namespaceID']/crn:value");
                }
            }
            catch (CCLConfigurationException e1) {
                e1.printStackTrace(pw);
            }
            catch (DocumentException e) {
                e.printStackTrace(pw);
            }
            try {
                String aaa_xml = cfg.getValue(AAA_CONFIG, true);
                Document document2 = null;
                SAXReader reader2 = new SAXReader();
                StringReader r2 = new StringReader(aaa_xml);
                document2 = reader2.read((Reader)new BufferedReader(r2));
                Element rootElem2 = document2.getRootElement();
                rootElem2.add(CRN_NAMESPACE);
                String authType = rootElem2.valueOf("./crn:instances[@name='authProvider']/crn:instance[./crn:parameter[@name='id']/crn:value='" + this.m_namespaceId + "']/@class");
                if (authType == null) {
                    authType = NTLM_TYPE;
                }
                this.m_bIsNTLM = NTLM_TYPE.equals(authType);
            }
            catch (CCLConfigurationException e1) {
                e1.printStackTrace(pw);
            }
            catch (DocumentException e) {
                e.printStackTrace(pw);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(pw);
        }
    }

    public void processLogonRequest(ITrustedSignonRequest theRequest) throws UserRecoverableException, SystemRecoverableException, UnrecoverableException {
        if (this.m_namespaceId == null || this.m_namespaceId.length() == 0) {
            throw new UnrecoverableException("Configuration error", "The trusted signon namespace id is not configured. Please contact your administrator");
        }
        theRequest.setNamespaceID(this.m_namespaceId);
        String[] userPrincipalValues = theRequest.getTrustedEnvVarValue(USER_PRINCIPAL);
        if (userPrincipalValues == null || userPrincipalValues.length == 0) {
            SystemRecoverableException e = new SystemRecoverableException("Required credential", USER_PRINCIPAL);
            throw e;
        }
        String userPrincipalValue = userPrincipalValues[0];
        if (userPrincipalValue != null && userPrincipalValue.length() > 0) {
            theRequest.removeTrustedEnvVar(REMOTE_USER);
            theRequest.addTrustedEnvVar(REMOTE_USER, userPrincipalValue);
            theRequest.removeEnvVar(REMOTE_USER);
            theRequest.addEnvVar(REMOTE_USER, userPrincipalValue);
            if (this.m_bIsNTLM) {
                theRequest.removeEnvVar(AUTH_TYPE);
                theRequest.addEnvVar(AUTH_TYPE, NTLM_TYPE);
            }
        }
    }
}

