/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.auth;

import com.cognos.CAM_AAA.authentication.INamespace;
import com.cognos.CAM_AAA.authentication.INamespaceConfiguration;
import com.cognos.CAM_AAA.authentication.ISearchFilter;
import com.cognos.CAM_AAA.authentication.ISearchFilterConditionalExpression;
import com.cognos.CAM_AAA.authentication.ISearchFilterFunctionCall;
import com.cognos.CAM_AAA.authentication.ISearchFilterRelationExpression;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.cps.bseries.auth.UiClass;
import java.util.Locale;

public class Namespace
extends UiClass
implements INamespace {
    private String[] capabilities = new String[6];
    private String namespaceFormat;

    public Namespace() {
        super(null);
        this.capabilities[0] = "caseSensitive";
        this.capabilities[1] = "contains";
        this.capabilities[2] = "equals";
        this.capabilities[3] = "sort";
        this.capabilities[4] = "startsWith";
        this.capabilities[5] = "endsWith";
        this.namespaceFormat = "http://developer.cognos.com/schemas/CAM/AAANamespaceFormat/2/";
    }

    public Namespace(String theObjectID) {
        super(theObjectID);
        this.capabilities[0] = "caseSensitive";
        this.capabilities[1] = "contains";
        this.capabilities[2] = "equals";
        this.capabilities[3] = "sort";
        this.capabilities[4] = "startsWith";
        this.capabilities[5] = "endsWith";
        this.namespaceFormat = "http://developer.cognos.com/schemas/CAM/AAANamespaceFormat/2/";
    }

    public void init(INamespaceConfiguration theNamespaceConfiguration) throws UnrecoverableException {
        this.setObjectID(theNamespaceConfiguration.getID());
        this.addName(theNamespaceConfiguration.getServerLocale(), theNamespaceConfiguration.getDisplayName());
    }

    public void destroy() {
    }

    public String getNamespaceFormat() {
        return this.namespaceFormat;
    }

    public void setNamespaceFormat(String theNamespaceFormat) {
        this.namespaceFormat = theNamespaceFormat;
    }

    public String[] getCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean getHasChildren() {
        return true;
    }

    public boolean matchesFilter(ISearchFilter theFilter) {
        if (theFilter == null) {
            return true;
        }
        switch (theFilter.getSearchFilterType()) {
            case 3: {
                ISearchFilterConditionalExpression item = (ISearchFilterConditionalExpression)theFilter;
                String operator = item.getOperator();
                ISearchFilter[] filters = item.getFilters();
                if (filters.length <= 0) break;
                boolean retval = false;
                for (int i = 1; i < filters.length; ++i) {
                    retval = this.matchesFilter(filters[i]);
                    if (operator.equals("and")) {
                        if (retval) continue;
                        return false;
                    }
                    if (operator.equals("or")) {
                        if (!retval) continue;
                        return true;
                    }
                    return false;
                }
                break;
            }
            case 2: {
                ISearchFilterFunctionCall item = (ISearchFilterFunctionCall)theFilter;
                String functionName = item.getFunctionName();
                if (functionName.equals("contains")) {
                    Locale[] locales;
                    String[] parameter = item.getParameters();
                    String propertyName = parameter[0];
                    String value = parameter[1];
                    if (propertyName.compareTo("@objectClass") == 0) {
                        return "namespace".indexOf(value) > 0;
                    }
                    if ((propertyName.equals("@defaultName") || propertyName.equals("@name")) && (locales = this.getAvailableNameLocales()) != null) {
                        for (int i = 0; i < locales.length; ++i) {
                            if (this.getName(locales[i]).indexOf(value) == -1) continue;
                            return true;
                        }
                    }
                    return false;
                }
                if (functionName.compareTo("starts-with") == 0) {
                    Locale[] locales;
                    String[] parameter = item.getParameters();
                    String propertyName = parameter[0];
                    String value = parameter[1];
                    if (propertyName.compareTo("@objectClass") == 0) {
                        return "namespace".startsWith(value);
                    }
                    if ((propertyName.compareTo("@defaultName") == 0 || propertyName.compareTo("@name") == 0) && (locales = this.getAvailableNameLocales()) != null) {
                        for (int i = 0; i < locales.length; ++i) {
                            if (!this.getName(locales[i]).startsWith(value)) continue;
                            return true;
                        }
                    }
                    return false;
                }
                if (functionName.compareTo("ends-with") == 0) {
                    Locale[] locales;
                    String[] parameter = item.getParameters();
                    String propertyName = parameter[0];
                    String value = parameter[1];
                    if (propertyName.compareTo("@objectClass") == 0) {
                        return "namespace".endsWith(value);
                    }
                    if ((propertyName.compareTo("@defaultName") == 0 || propertyName.compareTo("@name") == 0) && (locales = this.getAvailableNameLocales()) != null) {
                        for (int i = 0; i < locales.length; ++i) {
                            if (!this.getName(locales[i]).endsWith(value)) continue;
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }
            case 1: {
                ISearchFilterRelationExpression item = (ISearchFilterRelationExpression)theFilter;
                String propertyName = item.getPropertyName();
                String constraint = item.getConstraint();
                String operator = item.getOperator();
                if (propertyName.equals("@objectClass")) {
                    if (constraint.equals("namespace")) {
                        return operator.equals("=");
                    }
                    return false;
                }
                if (!propertyName.equals("@defaultName") && !propertyName.equals("@name")) break;
                if (operator.equals("=")) {
                    Locale[] locales = this.getAvailableNameLocales();
                    if (locales != null) {
                        for (int i = 0; i < locales.length; ++i) {
                            if (this.getName(locales[i]).compareTo(constraint) != 0) continue;
                            return true;
                        }
                    }
                    return false;
                }
                if (!operator.equals("!=")) break;
                Locale[] locales = this.getAvailableNameLocales();
                if (locales != null) {
                    for (int i = 0; i < locales.length; ++i) {
                        if (this.getName(locales[i]).compareTo(constraint) == 0) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }
}

