/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.pogo;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.IOException;
import java.util.List;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ModifyCAMActionHandler
extends BasicHandler {
    static final String BUS_NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ModifyCAMActionHandler.class.getName());
    private String m_request_root_name = null;
    private String m_cam_action = null;

    public ModifyCAMActionHandler() {
        super(cat);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.m_request_root_name = this.getRequiredAttribute(null, "request_root_name");
        this.m_cam_action = this.getRequiredAttribute(null, "cam_action");
        if (this.m_cam_action == null || this.m_cam_action.length() == 0) {
            this.m_cam_action = "logonAs";
        }
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        Element actionElem;
        Element camElem;
        List passportItemList;
        BIBusEnvelope soapEnvelope = (BIBusEnvelope)mc.getProperty(this.m_request_root_name + ".envelope");
        if (cat.isDebugEnabled()) {
            cat.debug("Input envelope: ");
            try {
                cat.debug(soapEnvelope.getAsString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((passportItemList = soapEnvelope.getEnvelope().selectNodes("//item[name = 'cam_passport']")).size() > 0) {
            if (cat.isDebugEnabled()) {
                cat.debug("Passport is already in request, no need to add/modify logon action.");
            }
            return;
        }
        Element biBusHeaderElem = soapEnvelope.getBIBusHeader();
        if (biBusHeaderElem == null) {
            Element soapHeaderElem = soapEnvelope.getHeader();
            if (soapHeaderElem == null) {
                soapHeaderElem = DocumentHelper.createElement((QName)new QName("Header", new Namespace("SOAP-ENV", soapEnvelope.getEnvelope().getNamespaceURI()), "SOAP-ENV:Header"));
                soapEnvelope.getEnvelope().add(soapHeaderElem);
            }
            biBusHeaderElem = DocumentHelper.createElement((QName)new QName("biBusHeader", new Namespace("bus", BUS_NAMESPACE), "bus:biBusHeader"));
            soapHeaderElem.add(biBusHeaderElem);
        }
        if ((camElem = biBusHeaderElem.element("CAM")) == null) {
            camElem = DocumentHelper.createElement((QName)new QName("CAM", new Namespace("bus", BUS_NAMESPACE), "bus:CAM"));
            biBusHeaderElem.add(camElem);
        }
        if ((actionElem = camElem.element("action")) == null) {
            actionElem = DocumentHelper.createElement((String)"action");
            camElem.add(actionElem);
        }
        actionElem.setText(this.m_cam_action);
        if (cat.isDebugEnabled()) {
            cat.debug("Envelope after modifying CAM action: ");
            try {
                cat.debug(soapEnvelope.getAsString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        mc.setProperty(this.m_request_root_name + ".envelope", (Object)soapEnvelope);
    }
}

