/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.pogo;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.portal.utils.CCLLocaleUtils;
import java.io.IOException;
import java.util.Locale;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class ModifyLocaleHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ModifyLocaleHandler.class.getName());
    private String m_request_root_name = null;
    private String m_locale_prop_name = null;

    public ModifyLocaleHandler() {
        super(cat);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.m_request_root_name = this.getRequiredAttribute(cat, "request_root_name");
        this.m_locale_prop_name = this.getRequiredAttribute(cat, "request_locale");
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope soapEnvelope = (BIBusEnvelope)mc.getProperty(this.m_request_root_name + ".envelope");
        if (cat.isDebugEnabled()) {
            cat.debug("Input envelope: ");
            try {
                cat.debug(soapEnvelope.getAsString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean updateLocale = false;
        Element body = soapEnvelope.getBody();
        Element markupOrActionElem = (Element)body.selectSingleNode("*[local-name()='getMarkup' or local-name()='performBlockingInteraction']");
        Element markupParams = null;
        if (markupOrActionElem != null) {
            markupParams = (Element)markupOrActionElem.selectSingleNode("*[local-name()='markupParams']");
        }
        String wsrpLocale = null;
        if (markupOrActionElem != null) {
            String portalAgent = null;
            if (markupParams != null) {
                portalAgent = markupParams.valueOf("*[local-name()='extensions']/*[local-name()='portalContext']/*[local-name()='portalAgent']");
            }
            if (portalAgent == null || !portalAgent.equals("cognos")) {
                if (markupParams != null) {
                    wsrpLocale = markupParams.valueOf("*[local-name()='locales']");
                }
                updateLocale = true;
            }
        } else {
            String crnCookie = soapEnvelope.getBIBusHeader().valueOf("*[local-name()='hdrSession']/*[local-name()='cookieVars']/*[local-name()='item'][name='CRN']/*[local-name()='value']");
            if (crnCookie == null || crnCookie.length() == 0) {
                updateLocale = true;
            }
        }
        if (updateLocale) {
            Object locale;
            if ((wsrpLocale == null || wsrpLocale.length() == 0) && (locale = mc.getProperty(this.m_locale_prop_name)) != null && locale instanceof Locale) {
                wsrpLocale = locale.toString();
            }
            if (wsrpLocale != null && wsrpLocale.length() > 0) {
                soapEnvelope.setUserPreference("productLocale", CCLLocaleUtils.getValidProductLocale((String)wsrpLocale, (String)"en"));
                soapEnvelope.setUserPreference("contentLocale", CCLLocaleUtils.getValidContentLocale((String)wsrpLocale, (String)"en"));
            }
        }
        mc.setProperty(this.m_request_root_name + ".envelope", (Object)soapEnvelope);
    }
}

