/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.pogo;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.common.sax.IObjectDescriptor;
import com.cognos.cps.bseries.xts.common.sax.IObjectFactory;
import com.cognos.cps.bseries.xts.pagelet.storage.CMRequest;
import com.cognos.cps.bseries.xts.pagelet.storage.helpers.CMRequestHelper;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.pagelet.storage.common.AsmTypeHelper;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.objects.v1.types.Fault;
import com.cognos.cps.services.pagelet.objects.v1.types.Portlet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.objects.v1.types.ResourceList;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducer;
import com.cognos.cps.services.wsrp.v1.types.PortletDescription;
import com.cognos.cps.services.wsrp.v1.types.ServiceDescription;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoEngineContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.portal.common.logging.LogRecorder;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.autoregistration.Fragment;
import com.cognos.portal.fragment.autoregistration.FragmentProducer;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.DebugHelper;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.localization.ResourceValue;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.request.XTSBusHelper;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.LocaleUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class ProducerRegistrationHandler
extends BasicHandler {
    private static final String TRUE = "true";
    private static final String CPS_PROPERTIES_PATH = "../webapps/p2pd/WEB-INF/cps.properties";
    private static final int MAX_RECONFIGURE_TRIALS = 10;
    private static Locale LOCALE;
    private static ObjectFactory factory;
    private static ObjectDescriptor descriptor;
    private static final String CPS_PORTLETS = "/cps4/portlets";
    private static final String WSRP_MORPHLET = "/cps4/services/registration/register.xts";
    private static final String DEFAULT_VERSION = "1";
    private String CALLER_ID = "CRN";
    private CMRequest cmRequest;
    private ServiceLogger logger = new ServiceLoggerImpl(ProducerRegistrationHandler.class);
    private PogoEngineContext pogoContext;
    private IContext context;
    private boolean isSuccessful;
    private int reconfigureCount;
    private Boolean enabled = null;
    private boolean isStarted = false;

    public ProducerRegistrationHandler() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document callXTS(String morphlet, List extraElements) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Calling xts");
        }
        BIBusEnvelope soapEnvelope = new BIBusEnvelope();
        soapEnvelope.setFormField("m", morphlet);
        XTSBusHelper busHelper = null;
        try {
            String pathInfo = "";
            busHelper = new XTSBusHelper(soapEnvelope, pathInfo);
        }
        catch (XTSException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("An unexpected error occurred  while transforming bus request to xts request", (Throwable)e);
            }
            return null;
        }
        XTSEnvironment env = busHelper.generateEnv(this.CALLER_ID);
        try {
            Document inputDoc = busHelper.getInputDoc();
            if (extraElements != null) {
                for (Element e : extraElements) {
                    e.detach();
                    inputDoc.getRootElement().add(e);
                }
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Input document before executing : \n" + inputDoc.asXML());
                }
                XTSProcessor.getInstance((String)this.CALLER_ID).execute(morphlet, inputDoc, env);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Input document after executing : \n" + inputDoc.asXML());
                }
            }
            catch (XTSException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("An error occurred while executing the xts morphlet", (Throwable)e);
                }
                Document document = null;
                env.cleanup();
                return document;
            }
            Document document = inputDoc;
            return document;
        }
        finally {
            env.cleanup();
        }
    }

    private boolean checkMorphletErrors(Document inputDoc) {
        List errors = inputDoc.selectNodes(".//*[local-name()='error']");
        if (errors != null && errors.size() > 0) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Errors were detected in the input document.");
                for (Element error : errors) {
                    StringBuffer tmp = new StringBuffer();
                    Element parent = error.getParent();
                    if (parent != null) {
                        tmp.append(parent.getName());
                        Element grandParent = parent.getParent();
                        if (grandParent != null) {
                            String producerName = grandParent.valueOf("name");
                            tmp.append("/");
                            tmp.append(grandParent.getName());
                            tmp.append("[name='");
                            tmp.append(producerName);
                            tmp.append("']");
                        }
                    }
                    this.logger.error("Error in element: " + tmp.toString());
                    this.logger.error(error.valueOf("."));
                }
            }
            return true;
        }
        return false;
    }

    private List createInputDocumentElements(List newProducersList, List updatedProducersList) {
        Element producerElem;
        ArrayList<Element> elements = new ArrayList<Element>();
        if (updatedProducersList.size() > 0) {
            Element updatedProducers = DocumentHelper.createElement((String)"updated_producers");
            elements.add(updatedProducers);
            for (Producer producer : updatedProducersList) {
                String registration;
                block11: {
                    producerElem = updatedProducers.addElement("producer");
                    producerElem.addElement("name").setText(producer.name);
                    registration = producer.cmProducer.getParameter("registration", null);
                    String serviceDescription = producer.cmProducer.getParameter("serviceDescription", null);
                    if (serviceDescription != null) {
                        try {
                            Element serviceDescriptionElement = DocumentHelper.parseText((String)serviceDescription).getRootElement();
                            List offeredPortletHandles = serviceDescriptionElement.selectNodes("/*[local-name()='serviceDescription']/*[local-name()='offeredPortlets']/*[local-name()='portletHandle']");
                            if (offeredPortletHandles != null && offeredPortletHandles.size() > 0) {
                                Element offeredPortletElem = producerElem.addElement("currentPortlets");
                                for (Element e : offeredPortletHandles) {
                                    offeredPortletElem.addElement("handle").setText(e.getText());
                                }
                            }
                        }
                        catch (DocumentException e) {
                            if (!this.logger.isErrorEnabled()) break block11;
                            this.logger.error("An error occurred while initializing while parsing the producer registration that is saved in CM", (Throwable)e);
                        }
                    }
                }
                if (registration == null) continue;
                try {
                    Document registrationDoc = DocumentHelper.parseText((String)registration);
                    Element registrationElement = registrationDoc.getRootElement();
                    registrationElement.detach();
                    producerElem.add(registrationElement);
                }
                catch (DocumentException e) {
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("An error occurred while initializing while parsing the producer registration that is saved in CM", (Throwable)e);
                }
            }
        }
        if (newProducersList.size() > 0) {
            Element newProducers = DocumentHelper.createElement((String)"new_producers");
            elements.add(newProducers);
            for (Producer producer : newProducersList) {
                producerElem = newProducers.addElement("producer");
                producerElem.addElement("name").setText(producer.name);
            }
        }
        return elements;
    }

    private void doInit() {
        block2: {
            this.cmRequest = new CMRequest(this.logger);
            this.context = this.createContext();
            try {
                this.cmRequest.initialize(this.context);
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("An error occurred while initializing", e);
            }
        }
    }

    private List getProducersFromCM() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getting producers from CM");
        }
        try {
            String request = this.getCMQueryProducersRequest();
            this.cmRequest.setObjectFactory(factory);
            return this.cmRequest.send(this.context, request, 1, false);
        }
        catch (Fault e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("An error occurred while getting the producers list from CM. " + e.getLocalizedMsgString(LOCALE), (Throwable)e);
            }
            return Collections.EMPTY_LIST;
        }
    }

    private List getProducerPortletsFromCM(String producerSearchPath) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getting producers from CM");
        }
        try {
            String request = this.getCMQueryProducerPortletsRequest(producerSearchPath);
            this.cmRequest.setObjectFactory(factory);
            return this.cmRequest.send(this.context, request, 1, false);
        }
        catch (OperationFailedFault e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("An error occurred while getting the portlets list from CM for the producer '" + producerSearchPath + "'. " + e.getLocalizedMsgString(LOCALE), (Throwable)e);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return Collections.EMPTY_LIST;
    }

    private List getProducersFromDisk() {
        ArrayList<Producer> results;
        block12: {
            results = new ArrayList<Producer>();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("getting producers list installed on disk");
            }
            try {
                DirEnt templateRoot = XTSResourceManager.getInstance().getTemplateRoot();
                DirEnt portletRoot = templateRoot.getChild(CPS_PORTLETS);
                List producers = portletRoot.getChildren();
                for (DirEnt producer : producers) {
                    InputStream implementationInputStream;
                    block11: {
                        String implementationPath = "/cps4/portlets/" + producer.getName() + "/" + "implementation.xml";
                        implementationInputStream = null;
                        try {
                            implementationInputStream = XTSResourceManager.getInstance().getResource(implementationPath);
                        }
                        catch (XTSException e) {
                            if (!this.logger.isErrorEnabled()) break block11;
                            this.logger.error("An error occurred while reading the implementaion file of the producer: " + producer.getName(), (Throwable)e);
                        }
                    }
                    if (implementationInputStream == null) continue;
                    SAXReader reader = new SAXReader();
                    try {
                        String visible;
                        Document doc = reader.read(implementationInputStream);
                        Element implementationElement = doc.getRootElement();
                        if (implementationElement == null || (visible = implementationElement.attributeValue("visible")) != null && visible.equals("false")) continue;
                        String version = implementationElement.attributeValue("version");
                        if (version == null || version.length() == 0) {
                            version = DEFAULT_VERSION;
                        }
                        results.add(new Producer(producer.getName(), version));
                    }
                    catch (DocumentException e) {
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.error("An error occurred while parsing the implementaion file of the producer: " + producer.getName(), (Throwable)e);
                    }
                }
            }
            catch (XTSException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("An error occurred while getting installed producers list: ", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block12;
                this.logger.error("An IO exception occurred while getting installed producers list: ", (Throwable)e);
            }
        }
        return results;
    }

    private List getFragmentProducersFromDisk() {
        ArrayList producers;
        block3: {
            producers = new ArrayList();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("getting fragment producers list installed on disk");
            }
            try {
                Set producersPath = this.pogoContext.getResourcePaths("/WEB-INF/fragments/producers/");
                this.scanDirectoryForFragmentProducerXML(producersPath, producers);
            }
            catch (NoSuchMethodException e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("An No Such Method Exception occurred while getting installed fragment producers list: ", (Throwable)e);
            }
        }
        return producers;
    }

    private void scanDirectoryForFragmentProducerXML(Set producersPath, List producers) throws NoSuchMethodException {
        if (producersPath != null) {
            for (String path : producersPath) {
                if (!path.endsWith("/")) continue;
                String producerXMLPath = path + "producer.xml";
                InputStream inputStream = this.pogoContext.getResourceAsStream(producerXMLPath);
                if (inputStream != null) {
                    FragmentProducer fragmentProducer = new FragmentProducer(this.pogoContext, path, this.logger);
                    if (!fragmentProducer.isError()) {
                        producers.add(fragmentProducer);
                        continue;
                    }
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("Error while reading producer. Skipping registration for producer : " + path);
                    this.logger.error("Error is: " + fragmentProducer.getError());
                    continue;
                }
                this.scanDirectoryForFragmentProducerXML(this.pogoContext.getResourcePaths(path), producers);
            }
        }
    }

    private void getUpdatedAndNewProducers(List cmProducers, List installedProducers, List updatedProducersList, List newProducersList) {
        for (Producer producer : installedProducers) {
            boolean foundProducerInCM = this.isProducerInCM(producer, cmProducers);
            if (foundProducerInCM) {
                boolean needsUpdating = this.isProducerUptodate(producer.version, producer.cmProducer);
                if (!needsUpdating) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found producer that needs updating: " + producer.name);
                }
                updatedProducersList.add(producer);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("found producer that needs registration: " + producer.name);
            }
            newProducersList.add(producer);
        }
    }

    private String getCMQueryProducersRequest() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[]\"><item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">/portal/portalPackage/portletFolder[@name='Portlets']/*</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">searchPath</item><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">binding</item><item xsi:type=\"cm:propEnum\">registration</item><item xsi:type=\"cm:propEnum\">serviceDescription</item><item xsi:type=\"cm:propEnum\">version</item></properties></item></requests></cm:query>");
        return buffer.toString();
    }

    private String getCMQueryProducerPortletsRequest(String producerSearchPath) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[]\"><item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">");
        buffer.append(producerSearchPath);
        buffer.append("/*[@objectClass='portlet']</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">searchPath</item><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">handle</item></properties></item></requests></cm:query>");
        return buffer.toString();
    }

    private String getCMUpdateRequest(Producer producer, String serviceDescriptionString) {
        StringBuffer buffer;
        block8: {
            buffer = new StringBuffer();
            buffer.append("<cm:update xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"><objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[]\"><item xsi:type=\"cm:portletProducer\"><searchPath xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\">");
            String searchPath = producer.cmProducer.getParameter("searchPath", "");
            String updateVersion = producer.cmProducer.getParameter("version", null);
            if (updateVersion != null) {
                searchPath = searchPath + "[@version='" + updateVersion + "']";
            }
            EncodingUtils.xmlEncode((String)searchPath, (StringBuffer)buffer);
            buffer.append("</value></searchPath><serviceDescription xsi:type=\"cm:xmlEncodedXMLProp\"><value xsi:type=\"cm:xmlEncodedXML\">");
            EncodingUtils.xmlEncode((String)serviceDescriptionString, (StringBuffer)buffer);
            buffer.append("</value></serviceDescription>");
            String registration = producer.cmProducer.getParameter("registration", null);
            if (registration != null) {
                try {
                    Element registrationElement = DocumentHelper.parseText((String)registration).getRootElement();
                    Element version = (Element)registrationElement.selectSingleNode("/*[local-name()='registration']/*[local-name()='RegistrationContext']/*[local-name()='extensions']/*[local-name()='version']");
                    if (version == null) {
                        Element registrationContext;
                        Element extensions = (Element)registrationElement.selectSingleNode("/*[local-name()='registration']/*[local-name()='RegistrationContext']/*[local-name()='extensions']");
                        if (extensions == null && (registrationContext = (Element)registrationElement.selectSingleNode("/*[local-name()='registration']/*[local-name()='RegistrationContext']")) != null) {
                            extensions = registrationContext.addElement(new QName("extensions", new Namespace("wsrp", "urn:oasis:names:tc:wsrp:v1:types")));
                        }
                        if (extensions != null) {
                            version = extensions.addElement(new QName("version", new Namespace("cpsext", "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/")));
                        }
                    }
                    if (version != null) {
                        version.setText(producer.version);
                    }
                    buffer.append("<registration xsi:type=\"cm:xmlEncodedXMLProp\"><value xsi:type=\"cm:xmlEncodedXML\">");
                    EncodingUtils.xmlEncode((String)registrationElement.asXML(), (StringBuffer)buffer);
                    buffer.append("</value></registration>");
                }
                catch (DocumentException e) {
                    if (!this.logger.isErrorEnabled()) break block8;
                    this.logger.error("A Document exception occurred while parsing the registration saved in CM ", (Throwable)e);
                }
            }
        }
        buffer.append("</item></objects></cm:update>");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        ProducerRegistrationHandler producerRegistrationHandler = this;
        synchronized (producerRegistrationHandler) {
            String result;
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            if (DebugHelper.getInstance().isRemoteDebugEnabled(requestEnvelope)) {
                String mode = requestEnvelope.getFormValue("mode");
                int level = "debug".equals(mode) ? 3 : 2;
                ServiceLogger tmp = this.logger;
                this.logger = new LogRecorder(tmp, level);
                this.logger.info("CPS producer auto registration service \n");
                String pathInfo = (String)mc.getProperty("path_info");
                if (pathInfo != null && pathInfo.startsWith("/cpsproducers/register")) {
                    this.logger.info("========== Starting auto registration request ==========\n");
                    this.registerProducers();
                    this.logger.info("========== Finished auto registration request ==========\n");
                }
                result = ((LogRecorder)this.logger).getContent();
                this.logger = tmp;
            } else {
                result = "CPS producer auto registration service: Request not allowed.";
            }
            mc.setResponseName("response");
            mc.setProperty("response.envelope", (Object)new BIBusEnvelope());
            mc.setProperty("response.status_code", (Object)"200");
            String header = "Content-Type: text/plain\r\n\r\n" + result;
            ArrayList<ByteArrayInputStream> attachments = new ArrayList<ByteArrayInputStream>();
            try {
                attachments.add(new ByteArrayInputStream(header.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                attachments.add(new ByteArrayInputStream(header.getBytes()));
            }
            mc.setProperty("response.attachments", attachments.iterator());
            mc.setProperty("response.boundary", (Object)"---=_MIME_BOUNDARY_Q739K9UU82UDLK73");
        }
    }

    private boolean isProducerCompatible(Producer producer, ServiceDescription serviceDescription) {
        boolean incompatible = false;
        List installedPortlet = this.getProducerPortletsFromCM(producer.cmProducer.getParameter("searchPath", ""));
        PortletDescription[] portlets = serviceDescription.getOfferedPortlets();
        for (GenericCMObject portlet : installedPortlet) {
            String portletHandleInCM = portlet.getParameter("handle", "");
            boolean foundPortlet = false;
            for (int j = 0; j < portlets.length; ++j) {
                PortletDescription portletDescription = portlets[j];
                String portletHandle = portletDescription.getPortletHandle();
                if (!portletHandle.equals(portletHandleInCM)) continue;
                foundPortlet = true;
                break;
            }
            if (foundPortlet) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("portlet with handle '" + portletHandleInCM + "' was not found in the new service description");
            }
            incompatible = true;
            break;
        }
        return !incompatible;
    }

    private boolean isProducerInCM(Producer producer, List cmProducers) {
        boolean foundProducerInCM = false;
        for (GenericCMObject obj : cmProducers) {
            String binding = obj.getParameter("binding", "");
            if (binding.indexOf("cps4/portlets/" + producer.name) == -1) continue;
            foundProducerInCM = true;
            producer.cmProducer = obj;
            break;
        }
        return foundProducerInCM;
    }

    private boolean isProducerUptodate(String version, GenericCMObject cmProducer) {
        double versionInCMAsDouble;
        String versionInCM;
        double versionAsDouble;
        block8: {
            try {
                versionAsDouble = Double.parseDouble(version);
            }
            catch (Exception e) {
                versionAsDouble = 0.0;
            }
            String registration = cmProducer.getParameter("registration", null);
            versionInCM = null;
            if (registration != null) {
                try {
                    Element registrationElement = DocumentHelper.parseText((String)registration).getRootElement();
                    versionInCM = registrationElement.valueOf("/*[local-name()='registration']/*[local-name()='RegistrationContext']/*[local-name()='extensions']/*[local-name()='version']");
                }
                catch (DocumentException e) {
                    if (!this.logger.isErrorEnabled()) break block8;
                    this.logger.error("A Document exception occurred while parsing the registration saved in CM ", (Throwable)e);
                }
            }
        }
        if (versionInCM == null || versionInCM.length() == 0) {
            versionInCM = "-1";
        }
        try {
            versionInCMAsDouble = Double.parseDouble(versionInCM);
        }
        catch (Exception e) {
            versionInCMAsDouble = -1.0;
        }
        return versionAsDouble > versionInCMAsDouble;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProducerRegistrationHandler producerRegistrationHandler = this;
        synchronized (producerRegistrationHandler) {
            this.doInit();
            this.isStarted = true;
            if (this.isEnabled()) {
                this.logger.info("Starting Producer Registration Service");
                this.isSuccessful = this.registerProducers();
            }
        }
    }

    private boolean isEnabled() {
        if (this.enabled == null) {
            this.setEnabled();
        }
        return this.enabled;
    }

    private void setEnabled() {
        Properties props = new Properties();
        try {
            FileInputStream stream = new FileInputStream(CPS_PROPERTIES_PATH);
            if (stream != null) {
                props.load(stream);
            }
        }
        catch (IOException e) {
            this.logger.error("Unable to load cps.properties.", (Throwable)e);
        }
        String autoRegistration = props.getProperty("cps4.fragment.autoregistration", TRUE);
        if (TRUE.equals(autoRegistration)) {
            this.logger.error("Auto Registration is enabled.");
            this.enabled = Boolean.TRUE;
        } else {
            this.logger.error("Auto Registration is skipped.");
            this.enabled = Boolean.FALSE;
        }
    }

    private boolean registerProducers() {
        boolean success = true;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Producers auto registration is started");
        }
        List cmProducers = this.getProducersFromCM();
        ArrayList cmWSRPProducers = new ArrayList();
        ArrayList cmFragmentProducers = new ArrayList();
        this.splitFragmentsAndWSRPProducers(cmProducers, cmWSRPProducers, cmFragmentProducers);
        List installedProducers = this.getProducersFromDisk();
        ArrayList updatedProducersList = new ArrayList();
        ArrayList newProducersList = new ArrayList();
        this.getUpdatedAndNewProducers(cmWSRPProducers, installedProducers, updatedProducersList, newProducersList);
        if (updatedProducersList.size() > 0 || newProducersList.size() > 0) {
            List extraElements = this.createInputDocumentElements(newProducersList, updatedProducersList);
            Document inputDoc = this.callXTS(WSRP_MORPHLET, extraElements);
            if (inputDoc == null || this.checkMorphletErrors(inputDoc)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Error detected while executing morphlet. Retrying one more time.A re-configure could have occured while executing the morphlet.Will retry on next re-configure.");
                }
                success = false;
            }
            this.updateAndRegisterProducers(inputDoc, updatedProducersList);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Producers auto registration is finished");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fragments auto registration is started");
        }
        List installedFragmentProducers = this.getFragmentProducersFromDisk();
        for (FragmentProducer producer : installedFragmentProducers) {
            GenericCMObject cmFragmentProducer = this.getFragmentProducerInCm(cmFragmentProducers, producer);
            if (cmFragmentProducer != null) {
                this.updateFragmentProducer(cmFragmentProducer, producer);
                continue;
            }
            this.registerFragmentProducer(producer);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Fragments auto registration is finished");
        }
        return success;
    }

    private GenericCMObject getFragmentProducerInCm(List cmFragmentProducers, FragmentProducer producer) {
        for (GenericCMObject cmObj : cmFragmentProducers) {
            String fragmentEndpoint = cmObj.getParameter("fragmentIdentifier", "");
            if (!fragmentEndpoint.equals(producer.getIdentifier())) continue;
            return cmObj;
        }
        return null;
    }

    private void splitFragmentsAndWSRPProducers(List cmProducers, List wsrpProducers, List fragmentProducers) {
        for (GenericCMObject cmObj : cmProducers) {
            String registration = cmObj.getParameter("registration", null);
            String identifier = this.getFragmentIdentifierFromRegistration(registration);
            if (identifier != null) {
                cmObj.setParameter("fragmentIdentifier", identifier);
                fragmentProducers.add(cmObj);
                continue;
            }
            wsrpProducers.add(cmObj);
        }
    }

    private String getFragmentIdentifierFromRegistration(String registration) {
        block8: {
            try {
                if (registration != null && registration.length() > 0) {
                    String id = null;
                    XMLStreamReader registrationReader = XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(registration));
                    if (StaxUtils.moveToElement((String)"extensions", (XMLStreamReader)registrationReader)) {
                        while (registrationReader.hasNext()) {
                            int event = registrationReader.next();
                            switch (event) {
                                case 1: {
                                    String localName = registrationReader.getLocalName();
                                    String namespaceURI = registrationReader.getNamespaceURI();
                                    if (!"identifier".equals(localName) || !"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/".equals(namespaceURI) || (id = registrationReader.getElementText()) == null) break;
                                    id = id.trim();
                                }
                            }
                        }
                    }
                    return id;
                }
            }
            catch (XMLStreamException e) {
                if (!this.logger.isErrorEnabled()) break block8;
                this.logger.info("Error is 'isFragmentRegistration()' while parsing the registration string: " + registration);
            }
        }
        return null;
    }

    private void registerFragmentProducer(FragmentProducer producer) {
        String name = null;
        List resourceList = producer.getTitleResourceValueList();
        if (resourceList != null && resourceList.size() > 0) {
            ResourceValue rv = (ResourceValue)resourceList.get(0);
            name = rv.getValue();
        }
        if (name == null) {
            name = producer.getDefaultTitle();
        }
        String searchPath = this.createEncodedProducerSearchPath(producer.getPortalPackage(), name);
        this.addAndRegisterFragmentProducer(searchPath, producer);
        producer.executePlugins(false);
    }

    protected String createEncodedProducerSearchPath(String packageName, String name) {
        StringBuffer searchPath = new StringBuffer();
        searchPath.append("/portal/portalPackage[@name = &apos;");
        searchPath.append(packageName);
        searchPath.append("&apos;]/portletFolder/portletProducer[@name = &apos;");
        com.cognos.cps.common.utils.EncodingUtils.escapeString((String)name, (String)"'", (char)'\'', (StringBuffer)searchPath);
        searchPath.append("&apos;]");
        return searchPath.toString();
    }

    private void updateFragmentProducer(GenericCMObject cmProducer, FragmentProducer producer) {
        List cmFragments;
        boolean isUpdated;
        String searchPath = cmProducer.getParameter("searchPath", null);
        if (searchPath != null && (isUpdated = this.updateAndRegisterFragmentProducer(cmProducer, searchPath, producer, cmFragments = this.getProducerPortletsFromCM(searchPath)))) {
            producer.executePlugins(true);
        }
    }

    private boolean updateAndRegisterFragmentProducer(GenericCMObject cmProducer, String searchPath, FragmentProducer producer, List cmFragments) {
        boolean isRegisteringNewFragments;
        boolean isUpdatingProducer = this.isProducerUptodate(producer.getVersion(), cmProducer);
        List installedFragments = producer.getFragments();
        StringBuffer newFragments = new StringBuffer();
        this.appendNewFragments(searchPath, cmFragments, installedFragments, newFragments);
        boolean bl = isRegisteringNewFragments = newFragments.length() > 0;
        if (isUpdatingProducer || isRegisteringNewFragments) {
            block11: {
                StringBuffer request = new StringBuffer();
                request.append("<cm:update xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"><objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[]\">");
                request.append("<item xsi:type=\"cm:portletProducer\"><searchPath xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\">" + searchPath + "</value>" + "</searchPath>");
                this.appendBinding(producer, request);
                this.appendRegistration(producer, request);
                this.appendServiceDescription(producer, request);
                request.append("</item>");
                request.append("</objects></cm:update>");
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Updating producer '" + producer.getDefaultTitle() + "' with CM searchPath '" + searchPath + "'");
                }
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Fragment producer update request:");
                        this.logger.debug(request.toString());
                    }
                    this.cmRequest.send(this.context, request.toString(), 1);
                }
                catch (Fault e1) {
                    if (!this.logger.isErrorEnabled()) break block11;
                    this.logger.error("An error occurred while updating producer '" + producer.getDefaultTitle() + "' with CM searchPath '" + searchPath + "'", (Throwable)e1);
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The producer '" + producer.getDefaultTitle() + "' is successfully updated ");
            }
            if (isRegisteringNewFragments) {
                block12: {
                    StringBuffer addFragments = new StringBuffer();
                    addFragments.append("<cm:add xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"><objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[]\">");
                    addFragments.append(newFragments);
                    addFragments.append("</objects><options xsi:type=\"cm:addOptions\"><updateAction xsi:type=\"cm:updateActionEnum\">update</updateAction></options></cm:add>");
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Adding new fragments for producer '" + producer.getDefaultTitle() + "' with CM searchPath '" + searchPath + "'");
                    }
                    try {
                        this.cmRequest.send(this.context, addFragments.toString(), 1);
                    }
                    catch (Fault e1) {
                        if (!this.logger.isErrorEnabled()) break block12;
                        this.logger.error("An error occurred while adding new fragment for producer '" + producer.getDefaultTitle() + "' with CM searchPath '" + searchPath + "'", (Throwable)e1);
                    }
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("New fragment were added successfully for producer '" + producer.getDefaultTitle() + "' is successfully updated ");
                }
            }
        }
        return isUpdatingProducer || isRegisteringNewFragments;
    }

    private void addAndRegisterFragmentProducer(String searchPath, FragmentProducer producer) {
        List installedFragments = producer.getFragments();
        StringBuffer newFragments = new StringBuffer();
        this.appendNewFragments(searchPath, null, installedFragments, newFragments);
        if (newFragments.length() > 0) {
            block6: {
                StringBuffer request = new StringBuffer();
                request.append("<cm:add xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"><objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[]\">");
                request.append("<item xsi:type=\"cm:portletProducer\"><searchPath xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\">/portal/portalPackage[@name = &apos;" + producer.getPortalPackage() + "&apos;]/portletFolder</value>" + "</searchPath>");
                this.appendMultilingualName("name", request, producer.getTitleResourceValueList(), producer.getDefaultTitle());
                request.append("<defaultDescription xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\"/></defaultDescription><defaultScreenTip xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\"/></defaultScreenTip>");
                this.appendBinding(producer, request);
                this.appendRegistration(producer, request);
                this.appendServiceDescription(producer, request);
                request.append("</item>");
                request.append(newFragments);
                request.append("</objects><options xsi:type=\"cm:addOptions\"><updateAction xsi:type=\"cm:updateActionEnum\">update</updateAction></options></cm:add>");
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registering producer '" + producer.getDefaultTitle() + "' in package '" + producer.getPortalPackage() + "'");
                }
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Fragment producer registration request:");
                        this.logger.debug(request.toString());
                    }
                    this.cmRequest.send(this.context, request.toString(), 1);
                }
                catch (Fault e1) {
                    if (!this.logger.isErrorEnabled()) break block6;
                    this.logger.error("An error occurred while registering the producer '" + producer.getDefaultTitle() + "'. " + e1.getLocalizedMsgString(LOCALE), (Throwable)e1);
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The producer '" + producer.getDefaultTitle() + "' is successfully registered ");
            }
        }
    }

    private IContext createContext() {
        ContextImpl portalContext;
        com.cognos.cps.services.helpers.ContextImpl context;
        block4: {
            context = new com.cognos.cps.services.helpers.ContextImpl();
            context.setProperty("XTS_ENV", (Object)this.createXTSEnv());
            context.setProperty("XTS_IDENTIFIER", (Object)"CPSPRODUCERS");
            portalContext = new ContextImpl();
            try {
                portalContext.setProperty("cmPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("contentManager", true)).getFile());
                portalContext.setProperty("dispatcherPath", (Object)new URL(CCLConfigurationFactory.getInstance().getValue("internalDispatcher", true)).getFile());
            }
            catch (MalformedURLException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("URL malformed while creating context.");
                }
            }
            catch (CCLConfigurationException e) {
                if (!this.logger.isInfoEnabled()) break block4;
                this.logger.info("Problem getting configuration while creating context.");
            }
        }
        context.setProperty("SoapConnectionFactory", (Object)new SOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext));
        context.setProperty("trustedSoapConnectionFactory", (Object)new TrustedSOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext, "CPS"));
        context.setProperty("consumerTrustedSoapConnectionFactory", (Object)new TrustedSOAPConnectionFactoryImpl((com.cognos.portal.utils.IContext)portalContext, "CPSConsumer"));
        return context;
    }

    private void appendNewFragments(String searchPath, List cmFragments, List installedFragments, StringBuffer newFragments) {
        for (Fragment fragment : installedFragments) {
            if (this.isFragmentInCM(fragment, cmFragments)) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Found new fragment that is not in CM for producer '" + searchPath + "' : " + fragment.getDefaultTitle());
            }
            newFragments.append("<item xsi:type=\"cm:portlet\"><searchPath xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\">" + searchPath + "</value>" + "</searchPath>");
            this.appendMultilingualName("name", newFragments, fragment.getTitleResourceValueList(), fragment.getDefaultTitle());
            this.appendMultilingualName("description", newFragments, fragment.getDescriptionResourceValueList(), fragment.getDefaultDescription());
            newFragments.append("<handle xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\">");
            EncodingUtils.xmlEncode((String)fragment.getHandle(), (StringBuffer)newFragments);
            newFragments.append("</value></handle>");
            if (fragment.getCustomizationString() != null) {
                newFragments.append("<context xsi:type=\"cm:xmlEncodedXMLProp\"><value xsi:type=\"cm:xmlEncodedXML\">");
                StringBuffer context = new StringBuffer();
                context.append("<wsrp:portletContext xmlns:wsrp=\"urn:oasis:names:tc:wsrp:v1:types\"><wsrp:portletHandle>");
                EncodingUtils.xmlEncode((String)fragment.getHandle(), (StringBuffer)context);
                context.append("</wsrp:portletHandle><wsrp:portletState>" + fragment.getCustomizationString() + "</wsrp:portletState></wsrp:portletContext>");
                EncodingUtils.xmlEncode((String)context.toString(), (StringBuffer)newFragments);
                newFragments.append("</value></context>");
            }
            newFragments.append("</item>");
        }
    }

    private void appendBinding(FragmentProducer producer, StringBuffer request) {
        block2: {
            request.append("<binding xsi:type=\"cm:xmlEncodedXMLProp\"><value xsi:type=\"cm:xmlEncodedXML\">");
            try {
                StringWriter routing = new StringWriter();
                XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter((Writer)routing);
                producer.writeRouting(xsw);
                xsw.close();
                EncodingUtils.xmlEncode((String)("<cps:binding xmlns:cps=\"http://developer.cognos.com/schemas/cps/asm/objects/1/\" xmlns:wsrp=\"urn:oasis:names:tc:wsrp:v1:types\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"><cps:service name=\"WSRPService\">" + routing.getBuffer().toString() + "<wsdl:port xmlns:ns1=\"urn:oasis:names:tc:wsrp:v1:bind\" name=\"WSRPBaseService\" binding=\"ns1:WSRP_v1_Markup_Binding_SOAP\">" + "<wsdlsoap:address xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" location=\"" + producer.getWSRPMarkupEndpoint() + "\"/>" + "</wsdl:port>" + "<wsdl:port xmlns:ns2=\"urn:oasis:names:tc:wsrp:v1:bind\" name=\"WSRPServiceDescriptionService\" binding=\"ns2:WSRP_v1_ServiceDescription_Binding_SOAP\">" + "<wsdlsoap:address xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" location=\"" + producer.getWSRPDescriptionEndpoint() + "\"/>" + "</wsdl:port>" + "<wsdl:port xmlns:ns3=\"urn:oasis:names:tc:wsrp:v1:bind\" name=\"WSRPRegistrationService\" binding=\"ns3:WSRP_v1_Registration_Binding_SOAP\">" + "<wsdlsoap:address xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" location=\"" + producer.getWSRPRegistrationEndpoint() + "\"/>" + "</wsdl:port>" + "<wsdl:port xmlns:ns4=\"urn:oasis:names:tc:wsrp:v1:bind\" name=\"WSRPPortletManagementService\" binding=\"ns4:WSRP_v1_PortletManagement_Binding_SOAP\">" + "<wsdlsoap:address xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" location=\"" + producer.getWSRPManagementEndpoint() + "\"/>" + "</wsdl:port></cps:service></cps:binding>"), (StringBuffer)request);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("An error occurred while generation binding information for the producer 'Cognos Fragments'. ", (Throwable)e);
            }
        }
        request.append("</value></binding>");
    }

    private void appendRegistration(FragmentProducer producer, StringBuffer request) {
        request.append("<registration xsi:type=\"cm:xmlEncodedXMLProp\"><value xsi:type=\"cm:xmlEncodedXML\">");
        StringBuffer endpoint = new StringBuffer();
        if (producer.getEndpoint() != null) {
            EncodingUtils.xmlEncode((String)producer.getEndpoint(), (StringBuffer)endpoint);
        }
        StringBuffer identifier = new StringBuffer();
        EncodingUtils.xmlEncode((String)producer.getIdentifier(), (StringBuffer)identifier);
        StringBuffer version = new StringBuffer();
        EncodingUtils.xmlEncode((String)producer.getVersion(), (StringBuffer)version);
        EncodingUtils.xmlEncode((String)("<cps:registration xmlns:cps=\"http://developer.cognos.com/schemas/cps/asm/objects/1/\" xmlns:wsrp=\"urn:oasis:names:tc:wsrp:v1:types\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\">\r\n   <wsrp:RegistrationContext>\r\n       <wsrp:registrationHandle>AUTOREGISTERFRAGMENT</wsrp:registrationHandle>\r\n       <wsrp:registrationState>H4sIAAAAAAAAALMpSCxKzFXIS8xNtVVKzs8rLs1NLXJMT80rUbJLzk/Pyy+20QcrsQMANXTtYyoAAAA=</wsrp:registrationState>\r\n       <wsrp:extensions>\r\n           <cpsext:info xmlns:cpsext=\"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/\">\r\n             <cpsext:identifier xmlns:cpsext=\"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/\">" + identifier.toString() + "</cpsext:identifier>\r\n" + "           </cpsext:info>" + "       </wsrp:extensions>\r\n" + "       <wsrp:extensions>\r\n" + "             <cpsext:version xmlns:cpsext=\"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/\">" + version.toString() + "</cpsext:version>\r\n" + "       </wsrp:extensions>\r\n" + "   </wsrp:RegistrationContext>\r\n" + "</cps:registration>"), (StringBuffer)request);
        request.append("</value></registration>");
    }

    private void appendServiceDescription(FragmentProducer producer, StringBuffer request) {
        block2: {
            request.append("<serviceDescription xsi:type=\"cm:xmlEncodedXMLProp\"><value xsi:type=\"cm:xmlEncodedXML\">");
            try {
                StringWriter serviceDescription = new StringWriter();
                XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter((Writer)serviceDescription);
                producer.writeServiceDescription(xsw);
                xsw.close();
                EncodingUtils.xmlEncode((String)serviceDescription.getBuffer().toString(), (StringBuffer)request);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("An error occurred while generation the service description for the producer 'Cognos Fragments'. ", (Throwable)e);
            }
        }
        request.append("</value></serviceDescription>");
    }

    private void appendMultilingualName(String propertyName, StringBuffer buffer, List resourceValueList, String defaultValue) {
        buffer.append("<" + propertyName + " ").append("xsi:type=\"cm:multilingualToken\"><value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:multilingualToken[]\">");
        if (resourceValueList != null && resourceValueList.size() > 0) {
            for (ResourceValue resourceValue : resourceValueList) {
                buffer.append("<item xsi:type=\"cm:multilingualToken\"><locale xsi:type=\"xsd:string\">" + resourceValue.getLocaleName() + "</locale>" + "<value xsi:type=\"xsd:string\">" + resourceValue.getValue() + "</value>" + "</item>");
            }
        } else if (defaultValue != null) {
            buffer.append("<item xsi:type=\"cm:multilingualToken\"><locale xsi:type=\"xsd:string\">en</locale><value xsi:type=\"xsd:string\">" + defaultValue + "</value>" + "</item>");
        }
        buffer.append("</value></" + propertyName + ">");
    }

    private boolean isFragmentInCM(Fragment fragment, List cmFragments) {
        boolean foundFragementInCM = false;
        if (cmFragments != null) {
            for (GenericCMObject obj : cmFragments) {
                String handle = obj.getParameter("handle", "");
                if (!handle.equals(fragment.getHandle())) continue;
                foundFragementInCM = true;
                break;
            }
        }
        return foundFragementInCM;
    }

    private void updateAndRegisterProducers(Document inputDoc, List updatedProducersList) {
        if (inputDoc != null) {
            List saveProducerElements = inputDoc.selectNodes("/root/new_producers/producer/create/*[local-name()='savePortletProducer']");
            for (Element e : saveProducerElements) {
                try {
                    Object object = AsmTypeHelper.deserializeStorage(new StringReader(e.asXML()), "savePortletProducer");
                    if (object == null || !(object instanceof SavePortletProducer)) continue;
                    PortletProducer portletProducer = ((SavePortletProducer)object).getPortletProducer();
                    String request = CMRequestHelper.getSaveProducerRequest(portletProducer);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Registering producer: " + portletProducer.getName().getContent());
                    }
                    this.cmRequest.send(this.context, request, 1);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("The producer '" + portletProducer.getName().getContent() + "' is successfully registered ");
                }
                catch (Fault e1) {
                    if (!this.logger.isErrorEnabled()) continue;
                    String name = e.valueOf("/*[local-name()='portletProducer']/*[local-name()='name']");
                    this.logger.error("An error occurred while registering a producer '" + name + "'. " + e1.getLocalizedMsgString(LOCALE), (Throwable)e1);
                }
            }
            for (Producer producer : updatedProducersList) {
                try {
                    StringBuffer xpath = new StringBuffer();
                    xpath.append("/root/updated_producers/producer[name='");
                    EncodingUtils.xmlEncode((String)producer.name, (StringBuffer)xpath);
                    xpath.append("']/description/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='getServiceDescriptionResponse']");
                    Element serviceDescriptionElement = (Element)inputDoc.selectSingleNode(xpath.toString());
                    if (serviceDescriptionElement == null) {
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.info("Could not find serviceDescription response while trying to update producer " + producer.name);
                        continue;
                    }
                    Object object = AsmTypeHelper.deserializeWsrp(new StringReader(serviceDescriptionElement.asXML()), "getServiceDescriptionResponse");
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Updating producer: " + producer.name);
                    }
                    if (object == null || !(object instanceof ServiceDescription)) continue;
                    ServiceDescription serviceDescription = (ServiceDescription)object;
                    if (this.isProducerCompatible(producer, serviceDescription)) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Updating service description of producer: " + producer.name);
                        }
                        String serviceDescriptionString = AsmTypeHelper.serializeWsrp(serviceDescription, "serviceDescription");
                        String updateRequest = this.getCMUpdateRequest(producer, serviceDescriptionString);
                        this.cmRequest.send(this.context, updateRequest, 1);
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("The producer '" + producer.name + "' service description is successfully updated");
                        }
                        xpath = new StringBuffer();
                        xpath.append("/root/updated_producers/producer[name='");
                        EncodingUtils.xmlEncode((String)producer.name, (StringBuffer)xpath);
                        xpath.append("']/newPortlets/*[local-name()='portlet']");
                        List newPortletsElements = inputDoc.selectNodes(xpath.toString());
                        ArrayList<Object> newPortlets = new ArrayList<Object>();
                        if (newPortletsElements != null && newPortletsElements.size() > 0) {
                            for (Element e : newPortletsElements) {
                                object = AsmTypeHelper.deserializeAsmObj(new StringReader(e.asXML()), "portlet");
                                if (object == null || !(object instanceof Portlet)) continue;
                                newPortlets.add(object);
                            }
                        }
                        xpath = new StringBuffer();
                        xpath.append("/root/updated_producers/producer[name='");
                        EncodingUtils.xmlEncode((String)producer.name, (StringBuffer)xpath);
                        xpath.append("']/newPortlets/*[local-name()='resourceList']");
                        Element resourceListElem = (Element)inputDoc.selectSingleNode(xpath.toString());
                        ResourceList resourceList = null;
                        if (resourceListElem != null && (object = AsmTypeHelper.deserializeAsmObj(new StringReader(resourceListElem.asXML()), "resourceList")) != null && object instanceof ResourceList) {
                            resourceList = (ResourceList)object;
                        }
                        if (newPortlets.size() <= 0) continue;
                        Portlet[] portlets = newPortlets.toArray(new Portlet[newPortlets.size()]);
                        String searchPath = producer.cmProducer.getParameter("searchPath", null);
                        if (searchPath == null) continue;
                        if (this.logger.isInfoEnabled()) {
                            StringBuffer portletNames = new StringBuffer();
                            Iterator it2 = newPortlets.iterator();
                            while (it2.hasNext()) {
                                Portlet portlet = (Portlet)it2.next();
                                portletNames.append(portlet.getName().getContent());
                                if (!it2.hasNext()) continue;
                                portletNames.append(", ");
                            }
                            this.logger.info("Adding new portlets to producer '" + producer.name + "': " + portletNames);
                        }
                        String newPortletsRequest = CMRequestHelper.getSavePortletRequest(searchPath, portlets, resourceList);
                        this.cmRequest.send(this.context, newPortletsRequest, 1);
                        if (!this.logger.isInfoEnabled()) continue;
                        this.logger.info("New portlet in the Producer '" + producer.name + "' are successfully created.");
                        continue;
                    }
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Incompatible service description. Skipping update for producer: " + producer.name);
                }
                catch (Fault e) {
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("An error occurred while updating producer '" + producer.name + ". " + e.getLocalizedMsgString(LOCALE), (Throwable)e);
                }
            }
        }
    }

    private XTSEnvironment createXTSEnv() {
        XTSEnvironment env = new XTSEnvironment(this.CALLER_ID);
        Locale locale = Locale.ENGLISH;
        env.setLocale(locale);
        env.setLookupList(LocaleUtils.createLookupList((Locale)locale, (boolean)false));
        env.setRequestContext("");
        env.setSessionContext("");
        env.setStepContext("");
        env.setSubRequestContext("");
        return env;
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoContext = engine.getContext();
        super.compose_impl(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(Configuration configuration) {
        ProducerRegistrationHandler producerRegistrationHandler = this;
        synchronized (producerRegistrationHandler) {
            if (this.isStarted && !this.isSuccessful && this.reconfigureCount < 10 && this.isEnabled()) {
                ++this.reconfigureCount;
                this.isSuccessful = this.registerProducers();
            }
        }
    }

    static {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("cpsconsumermsgs");
        msgFileList.add("cpsservicemsgs");
        msgFileList.add("cpssoapmsgs");
        msgFileList.add("cpsstringsmsgs");
        MessagesManager.getInstance().initialize(msgFileList);
        LOCALE = Locale.ENGLISH;
        factory = new ObjectFactory();
        descriptor = new ObjectDescriptor();
    }

    class Producer {
        GenericCMObject cmProducer;
        String name;
        String version;

        public Producer(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }

    static class ObjectFactory
    implements IObjectFactory {
        ObjectFactory() {
        }

        @Override
        public GenericCMObject createObject(String type) {
            return new GenericCMObject(type);
        }

        @Override
        public IObjectDescriptor getObjectDescriptor() {
            return descriptor;
        }
    }

    static class ObjectDescriptor
    implements IObjectDescriptor {
        ObjectDescriptor() {
        }

        @Override
        public boolean supportsObject(String att) {
            return false;
        }

        @Override
        public boolean supportsArray(String att) {
            return true;
        }

        @Override
        public boolean supportsMap(String att) {
            return true;
        }

        @Override
        public boolean supportsDate(String att) {
            return true;
        }

        @Override
        public boolean supportsNumeric(String att) {
            return true;
        }

        @Override
        public boolean supportsParameter(String att) {
            return true;
        }

        @Override
        public IXMLSerializable getHandler(String name) {
            return null;
        }

        @Override
        public boolean hasHandler(String name) {
            return false;
        }
    }
}

