/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.pogo;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.IOException;
import java.util.Iterator;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class WsrpFaultResponseHandler
extends BasicHandler {
    private static final String WSRP_NAMESPACE_URI = "urn:oasis:names:tc:wsrp:v1:types";
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(WsrpFaultResponseHandler.class.getName());
    private String cn_response = null;

    public WsrpFaultResponseHandler() {
        super(cat);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.cn_response = this.getRequiredAttribute(cat, "cn_response");
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        Element exceptionElem;
        Element camElem;
        Element soapHeaderElem;
        Element biBusHeaderElem;
        String busErrorCode;
        Element faultDetailElem;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        Fault fault = mc.getFault();
        if (fault == null) {
            if (cat.isDebugEnabled()) {
                cat.debug("No fault, so do nothing.");
            }
            return;
        }
        SOAPEnvelope soapEnv = fault.generateEnvelope(requestEnvelope);
        if (cat.isDebugEnabled()) {
            cat.debug("Fault found in MessageContext, fault before conversion to WSRP fault: ");
            try {
                cat.debug(soapEnv.getAsString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.isWsrpFault(soapEnv.getFault())) {
            if (cat.isDebugEnabled()) {
                cat.debug("Fault is already a WSRP fault, no need for conversion.");
                try {
                    cat.debug(soapEnv.getAsString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            mc.setFault(null);
            mc.setProperty(this.cn_response + ".status_code", (Object)"200");
            mc.setProperty(this.cn_response + ".envelope", (Object)soapEnv);
            mc.setProperty(this.cn_response + ".headers", (Object)new InternetHeaders());
            return;
        }
        String faultCodeText = soapEnv.getFaultCode();
        if (faultCodeText.equalsIgnoreCase("client") && (faultDetailElem = soapEnv.getFaultDetail()) != null && (busErrorCode = faultDetailElem.valueOf(".//errorCode[1]")).equals("cmHeaderFault") && (biBusHeaderElem = (soapHeaderElem = soapEnv.getHeader()).element("biBusHeader")) != null && (camElem = biBusHeaderElem.element("CAM")) != null && (exceptionElem = camElem.element("exception")) != null) {
            String errorCodeString = exceptionElem.valueOf("errorCodeString");
            boolean isAuthSystemRecoverable = false;
            if (errorCodeString != null && (errorCodeString.equals("camAuthUserRecoverable") || errorCodeString.equals("camAuthSystemRecoverable"))) {
                isAuthSystemRecoverable = errorCodeString.equals("camAuthSystemRecoverable");
                errorCodeString = "AccessDenied";
            } else {
                errorCodeString = "OperationFailed";
            }
            StringBuffer messagesBuf = new StringBuffer();
            Element messagesElem = exceptionElem.element("messages");
            if (messagesElem != null) {
                Element itemElem = null;
                Element messageStringElem = null;
                Iterator it = messagesElem.elementIterator("item");
                while (it.hasNext()) {
                    itemElem = (Element)it.next();
                    messageStringElem = itemElem.element("messageString");
                    if (messageStringElem == null) continue;
                    messagesBuf.append(messageStringElem.getTextTrim());
                    messagesBuf.append(" ");
                }
            }
            this.convertToWsrpFault(soapEnv.getFault(), errorCodeString, messagesBuf.toString(), soapEnv.getEnvelope().createCopy());
            if (!isAuthSystemRecoverable) {
                soapEnv.getHeader().detach();
                mc.setFault(null);
                mc.setProperty(this.cn_response + ".status_code", (Object)"200");
                mc.setProperty(this.cn_response + ".envelope", (Object)soapEnv);
                mc.setProperty(this.cn_response + ".headers", (Object)new InternetHeaders());
                if (cat.isDebugEnabled()) {
                    cat.debug("Fault after WSRP conversion: ");
                    try {
                        cat.debug(soapEnv.getAsString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        this.convertToWsrpFault(soapEnv.getFault(), "OperationFailed", null, soapEnv.getEnvelope().createCopy());
        soapEnv.getHeader().detach();
        mc.setFault(null);
        mc.setProperty(this.cn_response + ".status_code", (Object)"200");
        mc.setProperty(this.cn_response + ".envelope", (Object)soapEnv);
        mc.setProperty(this.cn_response + ".headers", (Object)new InternetHeaders());
        if (cat.isDebugEnabled()) {
            cat.debug("Fault after WSRP conversion: ");
            try {
                cat.debug(soapEnv.getAsString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isWsrpFault(Element faultElem) {
        Element faultCodeElem = faultElem.element("faultcode");
        String faultCode = faultCodeElem.getTextTrim();
        int faultCodeNSPrefixPos = faultCode.indexOf(58);
        if (faultCodeNSPrefixPos == -1) {
            return false;
        }
        String faultCodeNSPrefix = faultCode.substring(0, faultCodeNSPrefixPos);
        Namespace faultCodeNS = faultCodeElem.getNamespaceForPrefix(faultCodeNSPrefix);
        if (faultCodeNS == null) {
            return false;
        }
        return faultCodeNS.getStringValue().equals(WSRP_NAMESPACE_URI);
    }

    private void convertToWsrpFault(Element soapFaultElem, String faultCode, String faultString, Element faultDetail) {
        Element faultCodeElem = soapFaultElem.element("faultcode");
        if (faultCodeElem == null) {
            faultCodeElem = DocumentHelper.createElement((String)"faultCode");
            soapFaultElem.add(faultCodeElem);
        }
        faultCodeElem.add(new Namespace("m", WSRP_NAMESPACE_URI));
        faultCodeElem.setText("m:" + faultCode);
        faultCodeElem.addAttribute(new QName("hack", new Namespace("m", WSRP_NAMESPACE_URI), "m:hack"), "");
        if (faultString != null) {
            Element faultStringElem = soapFaultElem.element("faultstring");
            if (faultStringElem == null) {
                faultStringElem = DocumentHelper.createElement((String)"faultstring");
                soapFaultElem.add(faultStringElem);
            }
            faultStringElem.setText(faultString);
        }
        if (faultDetail != null) {
            Element faultDetailElem = soapFaultElem.element("detail");
            if (faultDetailElem != null) {
                faultDetailElem.detach();
                faultDetailElem = null;
            }
            faultDetailElem = DocumentHelper.createElement((String)"detail");
            soapFaultElem.add(faultDetailElem);
            faultDetailElem.add(faultDetail);
        }
    }
}

