/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts;

import com.cognos.cps.wsrp.consumer.CSSClassSubstituter;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionException;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import com.cognos.cps.wsrp.consumer.URLRewriter;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.ext.XTSExt;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformResult;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.CharArrayReaderWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CCPSWSRPMarkupResponseTransform
extends AXTSInstruction
implements IXTSTransformInstruction,
CSSClassSubstitutionHandler {
    private static final String ELEM_NM_CSSCLASSNAMEMAPPINGS = "cssClassNameMappings";
    private static final String ELEM_NM_MAPPING = "mapping";
    private static final String ATT_NM_NAME = "name";
    private static final String ATT_VL_BASEURL = "baseURL";
    private static final String ATT_VL_RESOURCEURL = "resourceURL";
    private static final String ATT_VL_NAMESPACEPREFIX = "namespacePrefix";
    private static final String ATT_VL_ENCODEDPAGEURL = "encodedPageURL";
    private static final String ATT_VL_ENCODEDCSSURL = "encodedCSSURL";
    private static final String ATT_VL_PORTLETINSTANCEKEY = "portletInstanceKey";
    private static final String ATT_VL_RESOURCEINSTANCE = "resourceInstance";
    String m_sIdentifier = null;
    private Map m_wsrpCSSNameMap = null;

    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        String systemId = UXTSInstructionUtils.getParameter((String)"systemId", (Map)instParams);
        if (systemId != null) {
            this.m_wsrpCSSNameMap = new HashMap();
            try {
                InputStream input = XTSResourceManager.getInstance().getResource(systemId);
                Element cssClassNameMappingsElem = null;
                try {
                    SAXReader reader = new SAXReader();
                    cssClassNameMappingsElem = reader.read(input).getRootElement();
                }
                catch (DocumentException e) {
                    Object[] args = new String[]{this.m_sIdentifier, systemId};
                    throw new XTSInstructionException("cps.transform.parsefilefailed", args, (Throwable)e);
                }
                if (!cssClassNameMappingsElem.getName().equals(ELEM_NM_CSSCLASSNAMEMAPPINGS)) {
                    Object[] args = new String[]{this.m_sIdentifier, systemId, ELEM_NM_CSSCLASSNAMEMAPPINGS, cssClassNameMappingsElem.getName()};
                    throw new XTSInstructionException("cps.transform.invalidfilerootelement", args);
                }
                Element mappingsElem = null;
                String name = null;
                Iterator mappingsElemIt = cssClassNameMappingsElem.elementIterator(ELEM_NM_MAPPING);
                while (mappingsElemIt.hasNext()) {
                    mappingsElem = (Element)mappingsElemIt.next();
                    name = mappingsElem.attributeValue(ATT_NM_NAME);
                    this.m_wsrpCSSNameMap.put(name, mappingsElem.getText());
                }
            }
            catch (XTSException e1) {
                Object[] args = new String[]{this.m_sIdentifier, systemId};
                throw new XTSInstructionException("cps.transform.openfilefailed", args);
            }
        }
        if (this.m_wsrpCSSNameMap != null) {
            this.m_wsrpCSSNameMap.clear();
        }
        this.m_wsrpCSSNameMap = null;
    }

    public void terminate() {
        this.m_sIdentifier = null;
        if (this.m_wsrpCSSNameMap != null) {
            this.m_wsrpCSSNameMap.clear();
        }
        this.m_wsrpCSSNameMap = null;
    }

    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String baseURL = UXTSInstructionUtils.getParameter((String)ATT_VL_BASEURL, (Map)instParams);
        if (baseURL == null) {
            Object[] args = new String[]{this.m_sIdentifier, ATT_VL_BASEURL};
            throw new XTSInstructionException("cps.transform.missingparam", args);
        }
        String resourceURL = UXTSInstructionUtils.getParameter((String)ATT_VL_RESOURCEURL, (Map)instParams);
        String namespacePrefix = UXTSInstructionUtils.getParameter((String)ATT_VL_NAMESPACEPREFIX, (Map)instParams);
        String encodedPageURL = UXTSInstructionUtils.getParameter((String)ATT_VL_ENCODEDPAGEURL, (Map)instParams);
        String encodedCssURL = UXTSInstructionUtils.getParameter((String)ATT_VL_ENCODEDCSSURL, (Map)instParams);
        CharArrayReaderWriter data = new CharArrayReaderWriter();
        try {
            char[] ch = new char[4096];
            int read = body.read(ch, 0, 4096);
            while (read > 0) {
                data.write(ch, 0, read);
                read = body.read(ch, 0, 4096);
            }
        }
        catch (IOException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("cps.transform.bodyreadioerror", args);
        }
        CharArrayReaderWriter rewriteResult = new CharArrayReaderWriter();
        URLRewriter rewriter = new URLRewriter((URLRewriteHandler)new CCPSConsumerURLHandler(baseURL, resourceURL, namespacePrefix, encodedPageURL, encodedCssURL), null);
        try {
            rewriter.rewrite(data.getBuf(), 0, data.getBufSize(), (Writer)rewriteResult);
        }
        catch (URLRewriteException e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("cps.transform.urlrewritefailed", args, (Throwable)e);
        }
        if (this.m_wsrpCSSNameMap != null) {
            CharArrayReaderWriter substitutionResult = new CharArrayReaderWriter();
            CSSClassSubstituter substituter = new CSSClassSubstituter((CSSClassSubstitutionHandler)this, null);
            try {
                substituter.substitute(rewriteResult.getBuf(), 0, rewriteResult.getBufSize(), (Writer)substitutionResult);
            }
            catch (CSSClassSubstitutionException e) {
                Object[] args = new String[]{this.m_sIdentifier};
                throw new XTSInstructionException("cps.transform.classsubstitutionfailed", args, (Throwable)e);
            }
            return new XTSTransformResult((IXTSTransformInstruction)this, (Reader)substitutionResult.convert());
        }
        return new XTSTransformResult((IXTSTransformInstruction)this, (Reader)rewriteResult.convert());
    }

    public String substituteClass(String className) throws CSSClassSubstitutionException {
        String newName = (String)this.m_wsrpCSSNameMap.get(className);
        if (newName == null) {
            newName = className;
        }
        return newName;
    }

    private class CCPSConsumerURLHandler
    implements URLRewriteHandler {
        private String m_baseURL = null;
        private String m_resourceURL = null;
        private String m_namespacePrefix = null;
        private String m_encodedPageURL = null;
        private String m_encodedCssURL = null;
        private static final String URL_TYPE = "wsrp-urlType";

        private CCPSConsumerURLHandler() {
        }

        public CCPSConsumerURLHandler(String baseURL, String resourceURL, String namespacePrefix, String encodedPageURL, String encodedCssURL) {
            this.m_baseURL = baseURL;
            this.m_resourceURL = resourceURL;
            this.m_namespacePrefix = namespacePrefix;
            this.m_encodedPageURL = encodedPageURL;
            this.m_encodedCssURL = encodedCssURL;
        }

        public void generateURL(Map urlParams, Writer result, String rewriteFlags) throws URLRewriteException {
            try {
                StringBuffer url;
                String urlType = (String)urlParams.get(URL_TYPE);
                if (urlType == null) {
                    urlType = (String)urlParams.get("amp;wsrp-urlType");
                }
                if (urlType != null && urlType.equals("resource")) {
                    if (this.m_resourceURL == null || this.m_resourceURL.length() == 0) {
                        Object[] args = new String[]{CCPSWSRPMarkupResponseTransform.this.m_sIdentifier, CCPSWSRPMarkupResponseTransform.ATT_VL_RESOURCEURL};
                        throw new URLRewriteException("cps.transform.missingparam", args);
                    }
                    url = new StringBuffer(this.m_resourceURL);
                } else {
                    url = new StringBuffer(this.m_baseURL);
                }
                if (this.m_encodedPageURL != null && this.m_encodedPageURL.length() > 0) {
                    if (url.toString().indexOf(63) == -1) {
                        url.append('?');
                    } else if (url.charAt(url.length() - 1) != '&') {
                        url.append('&');
                    }
                    url.append("cps-page").append("=").append(this.m_encodedPageURL);
                }
                if (this.m_encodedCssURL != null && this.m_encodedCssURL.length() > 0) {
                    if (url.toString().indexOf(63) == -1) {
                        url.append('?');
                    } else if (url.charAt(url.length() - 1) != '&') {
                        url.append('&');
                    }
                    url.append("cps-style").append("=").append(this.m_encodedCssURL);
                }
                StringBuffer urlBuf = new StringBuffer(XTSExt.xmlencode((String)url.toString()));
                Map.Entry pair = null;
                Iterator it = urlParams.entrySet().iterator();
                boolean bFirst = false;
                if (url.toString().indexOf(63) == -1) {
                    urlBuf.append('?');
                    bFirst = true;
                } else if (url.charAt(url.length() - 1) != '&' && it.hasNext()) {
                    urlBuf.append("&");
                }
                while (it.hasNext()) {
                    pair = it.next();
                    String name = (String)pair.getKey();
                    if (bFirst) {
                        if (name.startsWith("amp;")) {
                            name = name.substring(4);
                        }
                        bFirst = false;
                    } else if (!name.startsWith("amp;")) {
                        urlBuf.append("amp;");
                    }
                    urlBuf.append(name);
                    urlBuf.append('=');
                    urlBuf.append((String)pair.getValue());
                    if (!it.hasNext()) continue;
                    urlBuf.append("&");
                }
                result.write(urlBuf.toString());
            }
            catch (IOException e) {
                throw new URLRewriteException("cps.wsrp.consumer.rewriteioerror", (Throwable)e);
            }
        }

        public void generateUniquePortletId(Writer result) throws URLRewriteException {
            try {
                if (this.m_namespacePrefix != null) {
                    result.write(this.m_namespacePrefix);
                } else {
                    result.write("p" + Integer.toString(this.hashCode()).replace("-", "_"));
                }
            }
            catch (IOException e) {
                throw new URLRewriteException("cps.wsrp.consumer.rewriteioerror", (Throwable)e);
            }
        }
    }
}

