/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts;

import com.cognos.cps.bseries.xts.CPSCacheResult;
import com.cognos.cps.bseries.xts.common.cache.CacheManagerSingleton;
import com.cognos.cps.cache.Cache;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.cache.CacheManager;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CPSCacheRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static CacheManager cacheManager;
    private String identifier = null;

    public String getIdentifier() {
        return this.identifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.identifier = identifier;
        CPSCacheRequest.initializeCacheManager();
    }

    public void terminate() throws XTSInstructionException {
        this.identifier = null;
    }

    public boolean isInitialized() {
        return this.identifier != null && cacheManager != null;
    }

    private static synchronized void initializeCacheManager() throws XTSInstructionException {
        cacheManager = CacheManagerSingleton.getInstance();
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String method = UXTSInstructionUtils.getParameter((String)"method", (Map)instParams);
        if (method == null) {
            Object[] args = new String[]{this.identifier, "method"};
            throw new XTSInstructionException("cps.common.missingparameter.error", args);
        }
        try {
            if (method.equals("get")) {
                return this.handleGet(instParams);
            }
            if (method.equals("put")) {
                return this.handlePut(instParams, body);
            }
            if (method.equals("remove")) {
                return this.handleRemove(instParams);
            }
            if (method.equals("invalidate")) {
                return this.handleInvalidate(instParams);
            }
            if (method.equals("getRegions")) {
                return this.handleGetRegions(instParams);
            }
            if (method.equals("getIds")) {
                return this.handleGetIds(instParams);
            }
            Object[] args = new String[]{this.identifier, method};
            throw new XTSInstructionException("cps.common.undefinedmethod.error", args);
        }
        catch (CacheException e) {
            throw new XTSInstructionException("cps.cache.cacheexception", (Throwable)e);
        }
    }

    private IXTSInstructionResult handleGetIds(Map instParams) {
        Cache cache;
        String region = UXTSInstructionUtils.getParameter((String)"region", (Map)instParams);
        String result = null;
        if (region != null && (cache = cacheManager.getCache(region)) != null) {
            StringBuffer buf = new StringBuffer();
            Set keys = cache.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                buf.append(it.next().toString());
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            result = buf.toString();
        }
        return new CPSCacheResult(result);
    }

    private IXTSInstructionResult handleGetRegions(Map instParams) {
        String result = null;
        Collection regions = cacheManager.getCacheIds();
        StringBuffer buf = new StringBuffer();
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        result = buf.toString();
        return new CPSCacheResult(result);
    }

    private IXTSInstructionResult handleInvalidate(Map instParams) {
        String region = UXTSInstructionUtils.getParameter((String)"region", (Map)instParams);
        if (region != null) {
            cacheManager.removeCache(region);
        }
        return new CPSCacheResult("");
    }

    private IXTSInstructionResult handleRemove(Map instParams) {
        Cache cache;
        String region = UXTSInstructionUtils.getParameter((String)"region", (Map)instParams);
        String id = UXTSInstructionUtils.getParameter((String)"id", (Map)instParams);
        if (region != null && id != null && (cache = cacheManager.getCache(region)) != null) {
            cache.remove(id);
        }
        return new CPSCacheResult("");
    }

    private IXTSInstructionResult handlePut(Map instParams, Reader body) throws XTSInstructionException {
        String region = UXTSInstructionUtils.getParameter((String)"region", (Map)instParams);
        String id = UXTSInstructionUtils.getParameter((String)"id", (Map)instParams);
        if (region != null && id != null) {
            Cache cache = cacheManager.createCache(region);
            char[] buf = new char[1024];
            StringBuffer sb = new StringBuffer();
            if (body != null) {
                try {
                    int charsRead;
                    while ((charsRead = body.read(buf)) != -1) {
                        sb.append(buf, 0, charsRead);
                    }
                }
                catch (IOException e) {
                    Object[] args = new String[]{this.identifier};
                    throw new XTSInstructionException("cps.common.bodyread.error", args);
                }
            }
            cache.put(id, sb.toString());
        }
        return new CPSCacheResult("");
    }

    private IXTSInstructionResult handleGet(Map instParams) {
        Cache cache;
        String region = UXTSInstructionUtils.getParameter((String)"region", (Map)instParams);
        String id = UXTSInstructionUtils.getParameter((String)"id", (Map)instParams);
        String result = null;
        if (region != null && id != null && (cache = cacheManager.getCache(region)) != null) {
            result = (String)cache.get(id);
        }
        return new CPSCacheResult(result);
    }
}

