/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts;

import com.cognos.cps.bseries.xts.CPSFileWriteResult;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.properties.PropertiesManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Map;

public class CPSFileWriteRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final int WRITE_SIZE = 4096;
    private String m_sIdentifier = null;
    private String m_sTemplateRoot = null;

    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
    }

    public void terminate() throws XTSInstructionException {
    }

    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String target = (String)instAtts.get("target");
        if (target == null || target.length() == 0) {
            throw new XTSInstructionException("protocol.missingtarget");
        }
        String sFileName = null;
        try {
            sFileName = new File(this.m_sTemplateRoot, target).getCanonicalPath();
        }
        catch (IOException e) {
            Object[] args = new String[]{this.m_sIdentifier, this.m_sTemplateRoot, target};
            throw new XTSInstructionException("instruction.buildfullpathfailed", args, (Throwable)e);
        }
        try {
            File file = new File(sFileName);
            File parent = new File(file.getParent());
            if (!parent.isDirectory() && !parent.mkdirs()) {
                Object[] args = new String[]{this.m_sIdentifier, parent.getAbsolutePath()};
                throw new XTSInstructionException("cps.request.createpathfailed", args);
            }
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(sFileName));
            BufferedWriter bufWriter = new BufferedWriter(osw);
            char[] buf = new char[4096];
            int bytesRead = body.read(buf, 0, 4096);
            while (bytesRead != -1) {
                bufWriter.write(buf, 0, bytesRead);
                bytesRead = body.read(buf, 0, 4096);
            }
            bufWriter.flush();
            bufWriter.close();
            osw.close();
        }
        catch (IOException e) {
            Object[] args = new String[]{this.m_sIdentifier, sFileName};
            throw new XTSInstructionException("cps.request.ioexception", args, (Throwable)e);
        }
        return new CPSFileWriteResult();
    }
}

