/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts;

import com.cognos.cps.bseries.xts.CPSProducersResult;
import com.cognos.cps.bseries.xts.common.utils.XTSMessageFileHelper;
import com.cognos.portal.utils.localization.ResourceValue;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.resource.DirEnt;
import com.cognos.xts.resource.XTSResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CPSProducersRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final String CPS_PORTLETS = "/cps4/portlets";
    private String identifier = null;
    private DirEnt portletRoot = null;

    public String getIdentifier() {
        return this.identifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.identifier = identifier;
        try {
            DirEnt templateRoot = XTSResourceManager.getInstance().getTemplateRoot();
            this.portletRoot = templateRoot.getChild(CPS_PORTLETS);
        }
        catch (XTSException e) {
            Object[] args = new String[]{identifier};
            throw new XTSInstructionException("cps.common.init.error", args, (Throwable)e);
        }
        catch (IOException e) {
            Object[] args = new String[]{identifier};
            throw new XTSInstructionException("cps.common.init.error", args, (Throwable)e);
        }
    }

    public void terminate() throws XTSInstructionException {
    }

    public boolean isInitialized() {
        return this.identifier != null;
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String gateway = UXTSInstructionUtils.getParameter((String)"gateway", (Map)instParams);
        if (gateway == null) {
            gateway = "";
        }
        String[] localeNames = (String[])instParams.get("locale");
        String[] requestedProducers = (String[])instParams.get("producer");
        Element services = DocumentHelper.createElement((String)"services");
        List producers = this.portletRoot.getChildren();
        for (DirEnt producer : producers) {
            Object[] args;
            String visibleAttribute;
            boolean isVisible;
            Element producerImplementation;
            String producerName = producer.getName();
            if (requestedProducers != null && requestedProducers.length > 0) {
                boolean found = false;
                for (int i = 0; i < requestedProducers.length; ++i) {
                    String requestedProducer = requestedProducers[i];
                    if (!producerName.equals(requestedProducer)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if ((producerImplementation = this.getProducerImplementation(producer)) == null || !(isVisible = (visibleAttribute = producerImplementation.attributeValue("visible")) == null || visibleAttribute.equalsIgnoreCase("true"))) continue;
            Element service = DocumentHelper.createElement((String)"service");
            services.add(service);
            Element id = DocumentHelper.createElement((String)"id");
            id.setText(producerName);
            service.add(id);
            String implementationMessageFile = this.getImplementationMessageFile(producerImplementation);
            String titleResourceId = this.getProducerTitleResourceId(producerImplementation);
            List titleResourceValues = null;
            try {
                XTSMessageFileHelper messageFile = new XTSMessageFileHelper();
                titleResourceValues = messageFile.getResourceValueList(implementationMessageFile, titleResourceId, localeNames);
            }
            catch (DocumentException e) {
                args = new String[]{this.identifier};
                throw new XTSInstructionException("cps.common.parse.error", args, (Throwable)e);
            }
            catch (IOException e) {
                args = new String[]{this.identifier};
                throw new XTSInstructionException("cps.common.getresource.error", args, (Throwable)e);
            }
            Element title = DocumentHelper.createElement((String)"title");
            if (titleResourceValues != null && titleResourceValues.size() > 0) {
                ResourceValue resourceValue = (ResourceValue)titleResourceValues.remove(0);
                title.setText(resourceValue.getValue());
                title.addAttribute("xml:lang", resourceValue.getLocaleName());
                if (titleResourceValues.size() > 0) {
                    title.addAttribute("resourceName", titleResourceId);
                }
            } else {
                title.setText(this.getProducerDefaultTitle(producer, producerImplementation));
            }
            service.add(title);
            Element namespace = DocumentHelper.createElement((String)"namespace");
            namespace.setText("urn:oasis:names:tc:wsrp:v1:types");
            service.add(namespace);
            Element definition = DocumentHelper.createElement((String)"definition");
            definition.setText(gateway + "/wsrp/cps4/portlets/" + producer.getName() + "?wsdl&b_action=cps.wsdl");
            service.add(definition);
            service.add(this.createBinding(producer.getName(), producerImplementation));
            if (titleResourceValues == null || titleResourceValues.size() <= 0) continue;
            Element resources = DocumentHelper.createElement((String)"resources");
            resources.addAttribute("resourceName", titleResourceId);
            Iterator it2 = titleResourceValues.iterator();
            while (it2.hasNext()) {
                Element values = DocumentHelper.createElement((String)"values");
                ResourceValue resourceValue = (ResourceValue)it2.next();
                values.setText(resourceValue.getValue());
                values.addAttribute("xml:lang", resourceValue.getLocaleName());
                resources.add(values);
            }
            Element resourceList = DocumentHelper.createElement((String)"resourceList");
            resourceList.add(resources);
            service.add(resourceList);
        }
        return new CPSProducersResult(services.asXML());
    }

    private Element getProducerImplementation(DirEnt producer) throws XTSInstructionException {
        String implementationPath = "/cps4/portlets/" + producer.getName() + "/" + "implementation.xml";
        InputStream implementationInputStream = null;
        try {
            implementationInputStream = XTSResourceManager.getInstance().getResource(implementationPath);
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.identifier};
            throw new XTSInstructionException("cps.common.getresource.error", args, (Throwable)e);
        }
        if (implementationInputStream != null) {
            Document doc;
            SAXReader reader = new SAXReader();
            try {
                doc = reader.read(implementationInputStream);
            }
            catch (DocumentException e) {
                Object[] args = new String[]{this.identifier};
                throw new XTSInstructionException("cps.common.parse.error", args, (Throwable)e);
            }
            Element implementationElement = doc.getRootElement();
            return implementationElement;
        }
        return null;
    }

    private String getProducerDefaultTitle(DirEnt producer, Element implementationElement) {
        Element producerNameElement;
        String title = producer.getName();
        if (implementationElement != null && (producerNameElement = implementationElement.element("producerName")) != null && !"".equals(producerNameElement.getText())) {
            title = producerNameElement.getText();
        }
        return title;
    }

    private String getProducerTitleResourceId(Element implementationElement) {
        Element producerNameElement;
        String resourceId = null;
        if (implementationElement != null && (producerNameElement = implementationElement.element("producerName")) != null) {
            resourceId = producerNameElement.attributeValue("resourceID");
        }
        return resourceId;
    }

    private String getImplementationMessageFile(Element implementationElement) {
        Element messageElement;
        String messageFile = null;
        if (implementationElement != null && (messageElement = implementationElement.element("message")) != null) {
            messageFile = messageElement.getText();
        }
        return messageFile;
    }

    private Element createBinding(String name, Element implementation) {
        Element binding = DocumentHelper.createElement((String)"binding");
        Element service = DocumentHelper.createElement((String)"service");
        service.addAttribute("name", "WSRPService");
        Element routing = (Element)implementation.selectSingleNode("extension/*[local-name()='segment']");
        if (routing != null) {
            routing.detach();
            service.add(routing);
        }
        binding.add(service);
        service.add(this.createPort("WSRPBaseService", "interface://wsrp/cps4/portlets/" + name, implementation));
        service.add(this.createPort("WSRPServiceDescriptionService", "interface://wsrp/cps4/portlets/" + name, implementation));
        service.add(this.createPort("WSRPRegistrationService", "interface://wsrp/cps4/portlets/" + name, implementation));
        service.add(this.createPort("WSRPPortletManagementService", "interface://wsrp/cps4/portlets/" + name, implementation));
        return binding;
    }

    private Element createPort(String serviceName, String portAddress, Element implementation) {
        Element port = DocumentHelper.createElement((String)"port");
        port.addAttribute("name", serviceName);
        Element address = DocumentHelper.createElement((String)"address");
        address.addAttribute("location", portAddress);
        port.add(address);
        List elements = implementation.selectNodes("extension/*[local-name()='port' and @name='" + serviceName + "']/*[local-name()='portletAddress']");
        if (elements != null) {
            for (Element e : elements) {
                e.detach();
                port.add(e);
            }
        }
        return port;
    }
}

